"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VehicleModel = exports.CanDefinition = exports.NetworkFileDefinition = exports.CanVehicleSignal = exports.VehicleSignal = exports.CanVehicleInterface = exports.VehicleInterface = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class VehicleInterface {
    constructor() {
        this.intf = {};
    }
    toObject() {
        return (this.intf);
    }
}
exports.VehicleInterface = VehicleInterface;
_a = JSII_RTTI_SYMBOL_1;
VehicleInterface[_a] = { fqn: "cdk-aws-iotfleetwise.VehicleInterface", version: "0.2.1" };
class CanVehicleInterface extends VehicleInterface {
    constructor(interfaceId, name) {
        super();
        this.intf = {
            type: 'CAN_INTERFACE',
            interfaceId,
            canInterface: {
                canInterfaceName: name,
                protocolName: 'CAN',
                protocolVersion: '2.0b',
            },
        };
    }
}
exports.CanVehicleInterface = CanVehicleInterface;
_b = JSII_RTTI_SYMBOL_1;
CanVehicleInterface[_b] = { fqn: "cdk-aws-iotfleetwise.CanVehicleInterface", version: "0.2.1" };
class VehicleSignal {
    constructor() {
        this.signal = {};
    }
    toObject() {
        return (this.signal);
    }
}
exports.VehicleSignal = VehicleSignal;
_c = JSII_RTTI_SYMBOL_1;
VehicleSignal[_c] = { fqn: "cdk-aws-iotfleetwise.VehicleSignal", version: "0.2.1" };
class CanVehicleSignal extends VehicleSignal {
    constructor(name, fullyQualifiedName, interfaceId, messageId, factor, isBigEndian, isSigned, length, offset, startBit) {
        super();
        this.signal = {
            type: 'CAN_SIGNAL',
            fullyQualifiedName,
            interfaceId,
            canSignal: {
                canSignalName: name,
                factor,
                isBigEndian,
                isSigned,
                length,
                messageId,
                offset,
                startBit,
            },
        };
    }
}
exports.CanVehicleSignal = CanVehicleSignal;
_d = JSII_RTTI_SYMBOL_1;
CanVehicleSignal[_d] = { fqn: "cdk-aws-iotfleetwise.CanVehicleSignal", version: "0.2.1" };
class NetworkFileDefinition {
    constructor() {
        this.definition = {};
    }
    toObject() {
        return (this.definition);
    }
}
exports.NetworkFileDefinition = NetworkFileDefinition;
_e = JSII_RTTI_SYMBOL_1;
NetworkFileDefinition[_e] = { fqn: "cdk-aws-iotfleetwise.NetworkFileDefinition", version: "0.2.1" };
class CanDefinition extends NetworkFileDefinition {
    constructor(networkInterface, signalsMap, canDbcFiles) {
        super();
        this.definition = {
            networkFileType: 'CAN_DBC',
            canDbc: {
                canDbcFiles,
                networkInterface,
                signalsMap,
            },
        };
    }
}
exports.CanDefinition = CanDefinition;
_f = JSII_RTTI_SYMBOL_1;
CanDefinition[_f] = { fqn: "cdk-aws-iotfleetwise.CanDefinition", version: "0.2.1" };
class VehicleModel extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = '';
        this.signalCatalog = {};
        this.name = props.name || '';
        this.signalCatalog = props.signalCatalog;
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Lambda', {
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: 'vehiclemodelhandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.signalCatalog.lambdaLayer],
            role: this.signalCatalog.lambdaRole,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: onEventHandler,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                name: this.name,
                signal_catalog_arn: props.signalCatalog.arn,
                model_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:model-manifest/${this.name}`,
                description: props.description,
                network_interfaces: JSON.stringify(props.networkInterfaces.map(i => i.toObject())),
                signals: (props.signals) ? JSON.stringify(props.signals.map(s => s.toObject())) : '{}',
                network_file_definitions: (props.networkFileDefinitions) ? JSON.stringify(props.networkFileDefinitions.map(s => s.toObject())) : '{}',
            },
        });
        resource.node.addDependency(this.signalCatalog);
    }
}
exports.VehicleModel = VehicleModel;
_g = JSII_RTTI_SYMBOL_1;
VehicleModel[_g] = { fqn: "cdk-aws-iotfleetwise.VehicleModel", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,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