"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ifw = require(".");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'integ-stack', { env });
        const database = new aws_cdk_lib_1.aws_timestream.CfnDatabase(stack, 'Database', {
            databaseName: 'FleetWise',
        });
        const table = new aws_cdk_lib_1.aws_timestream.CfnTable(stack, 'Table', {
            databaseName: 'FleetWise',
            tableName: 'FleetWise',
        });
        table.node.addDependency(database);
        const role = new aws_cdk_lib_1.aws_iam.Role(stack, 'Role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('iotfleetwise.amazonaws.com'),
            managedPolicies: [
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AdministratorAccess'),
            ],
        });
        const signalCatalog = new ifw.SignalCatalog(stack, 'SignalCatalog', {
            database,
            table,
            role,
            description: 'my signal catalog',
            nodes: [
                new ifw.SignalCatalogBranch('Vehicle', 'Vehicle'),
                new ifw.SignalCatalogSensor('EngineTorque', 'Vehicle.EngineTorque', 'DOUBLE'),
            ],
        });
        const model_a = new ifw.VehicleModel(stack, 'ModelA', {
            signalCatalog,
            name: 'modelA',
            description: 'Model A vehicle',
            networkInterfaces: [new ifw.CanVehicleInterface('1', 'vcan0')],
            signals: [
                new ifw.CanVehicleSignal('EngineTorque', 'Vehicle.EngineTorque', '1', 401, // messageId
                1.0, // factor
                true, // isBigEndian
                false, // isSigned
                8, // length
                0.0, // offset
                9),
            ],
        });
        const vin100 = new ifw.Vehicle(stack, 'vin100', {
            vehicleId: 'vin100',
            vehicleModel: model_a,
            createIotThing: true,
        });
        new cdk.CfnOutput(stack, 'certificateId', { value: vin100.certificateId });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
process.env.GITLAB_REGISTRATION_TOKEN = 'mock';
process.env.CDK_INTEG_REGION = 'eu-central-1';
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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