#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from .property import PropertyFragment, QUERY as PropertyFragmentQuery

from gql_client.runtime.enum_utils import enum_field_metadata
from ..enum.work_order_priority import WorkOrderPriority
from ..enum.work_order_status import WorkOrderStatus

# fmt: off
QUERY: List[str] = PropertyFragmentQuery + ["""
fragment WorkOrderFragment on WorkOrder {
    id
    name
    description
    workOrderType{
        id
        name
    }
    location{
        id
    }
    project{
        id
    }
    properties{
        ...PropertyFragment
    }
    owner{
        id
    }
    assignedTo{
        id
    }
    organizationFk{
        id
    }
    status
    priority
}
"""]

@dataclass(frozen=True)
class WorkOrderFragment(DataClassJsonMixin):
    @dataclass(frozen=True)
    class WorkOrderType(DataClassJsonMixin):
        id: str
        name: str

    @dataclass(frozen=True)
    class Location(DataClassJsonMixin):
        id: str

    @dataclass(frozen=True)
    class Project(DataClassJsonMixin):
        id: str

    @dataclass(frozen=True)
    class Property(PropertyFragment):
        pass

    @dataclass(frozen=True)
    class User(DataClassJsonMixin):
        id: str

    @dataclass(frozen=True)
    class Organization(DataClassJsonMixin):
        id: str

    id: str
    name: str
    description: Optional[str]
    workOrderType: WorkOrderType
    location: Optional[Location]
    project: Optional[Project]
    properties: List[Property]
    owner: User
    assignedTo: Optional[User]
    organizationFk: Optional[Organization]
    status: WorkOrderStatus = _field(metadata=enum_field_metadata(WorkOrderStatus))
    priority: WorkOrderPriority = _field(metadata=enum_field_metadata(WorkOrderPriority))
