"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateModelSchema = exports.EXTRA_DIRECTIVES_DOCUMENT = exports.specifiedRules = void 0;
const language_1 = require("graphql/language");
const validation_1 = require("graphql/validation");
const buildASTSchema_1 = require("graphql/utilities/buildASTSchema");
const SingleFieldSubscriptions_1 = require("graphql/validation/rules/SingleFieldSubscriptions");
const KnownTypeNames_1 = require("graphql/validation/rules/KnownTypeNames");
const FragmentsOnCompositeTypes_1 = require("graphql/validation/rules/FragmentsOnCompositeTypes");
const VariablesAreInputTypes_1 = require("graphql/validation/rules/VariablesAreInputTypes");
const ScalarLeafs_1 = require("graphql/validation/rules/ScalarLeafs");
const FieldsOnCorrectType_1 = require("graphql/validation/rules/FieldsOnCorrectType");
const KnownDirectives_1 = require("graphql/validation/rules/KnownDirectives");
const KnownArgumentNames_1 = require("graphql/validation/rules/KnownArgumentNames");
const UniqueArgumentNames_1 = require("graphql/validation/rules/UniqueArgumentNames");
const ValuesOfCorrectType_1 = require("graphql/validation/rules/ValuesOfCorrectType");
const VariablesInAllowedPosition_1 = require("graphql/validation/rules/VariablesInAllowedPosition");
const OverlappingFieldsCanBeMerged_1 = require("graphql/validation/rules/OverlappingFieldsCanBeMerged");
const UniqueInputFieldNames_1 = require("graphql/validation/rules/UniqueInputFieldNames");
const ProvidedRequiredArguments_1 = require("graphql/validation/rules/ProvidedRequiredArguments");
const UniqueOperationNames_1 = require("graphql/validation/rules/UniqueOperationNames");
const LoneAnonymousOperation_1 = require("graphql/validation/rules/LoneAnonymousOperation");
const UniqueFragmentNames_1 = require("graphql/validation/rules/UniqueFragmentNames");
const KnownFragmentNames_1 = require("graphql/validation/rules/KnownFragmentNames");
const NoUnusedFragments_1 = require("graphql/validation/rules/NoUnusedFragments");
const PossibleFragmentSpreads_1 = require("graphql/validation/rules/PossibleFragmentSpreads");
const NoFragmentCycles_1 = require("graphql/validation/rules/NoFragmentCycles");
const UniqueVariableNames_1 = require("graphql/validation/rules/UniqueVariableNames");
const NoUndefinedVariables_1 = require("graphql/validation/rules/NoUndefinedVariables");
const NoUnusedVariables_1 = require("graphql/validation/rules/NoUnusedVariables");
const UniqueDirectivesPerLocation_1 = require("graphql/validation/rules/UniqueDirectivesPerLocation");
exports.specifiedRules = [
    UniqueOperationNames_1.UniqueOperationNames,
    LoneAnonymousOperation_1.LoneAnonymousOperation,
    SingleFieldSubscriptions_1.SingleFieldSubscriptions,
    KnownTypeNames_1.KnownTypeNames,
    FragmentsOnCompositeTypes_1.FragmentsOnCompositeTypes,
    VariablesAreInputTypes_1.VariablesAreInputTypes,
    ScalarLeafs_1.ScalarLeafs,
    FieldsOnCorrectType_1.FieldsOnCorrectType,
    UniqueFragmentNames_1.UniqueFragmentNames,
    KnownFragmentNames_1.KnownFragmentNames,
    NoUnusedFragments_1.NoUnusedFragments,
    PossibleFragmentSpreads_1.PossibleFragmentSpreads,
    NoFragmentCycles_1.NoFragmentCycles,
    UniqueVariableNames_1.UniqueVariableNames,
    NoUndefinedVariables_1.NoUndefinedVariables,
    NoUnusedVariables_1.NoUnusedVariables,
    KnownDirectives_1.KnownDirectives,
    UniqueDirectivesPerLocation_1.UniqueDirectivesPerLocation,
    KnownArgumentNames_1.KnownArgumentNames,
    UniqueArgumentNames_1.UniqueArgumentNames,
    ValuesOfCorrectType_1.ValuesOfCorrectType,
    ProvidedRequiredArguments_1.ProvidedRequiredArguments,
    VariablesInAllowedPosition_1.VariablesInAllowedPosition,
    OverlappingFieldsCanBeMerged_1.OverlappingFieldsCanBeMerged,
    UniqueInputFieldNames_1.UniqueInputFieldNames,
];
const EXTRA_SCALARS_DOCUMENT = language_1.parse(`
scalar AWSDate
scalar AWSTime
scalar AWSDateTime
scalar AWSTimestamp
scalar AWSEmail
scalar AWSJSON
scalar AWSURL
scalar AWSPhone
scalar AWSIPAddress
scalar BigInt
scalar Double
`);
exports.EXTRA_DIRECTIVES_DOCUMENT = language_1.parse(`
directive @aws_subscribe(mutations: [String!]!) on FIELD_DEFINITION
directive @aws_auth(cognito_groups: [String!]!) on FIELD_DEFINITION
directive @aws_api_key on FIELD_DEFINITION | OBJECT
directive @aws_iam on FIELD_DEFINITION | OBJECT
directive @aws_oidc on FIELD_DEFINITION | OBJECT
directive @aws_cognito_user_pools(cognito_groups: [String!]) on FIELD_DEFINITION | OBJECT

# Allows transformer libraries to deprecate directive arguments.
directive @deprecated(reason: String) on FIELD_DEFINITION | INPUT_FIELD_DEFINITION | ENUM | ENUM_VALUE
`);
const NOOP_QUERY = language_1.parse(`
type Query {
  noop: String
}
`);
exports.validateModelSchema = (doc) => {
    const fullDocument = {
        kind: language_1.Kind.DOCUMENT,
        definitions: [...exports.EXTRA_DIRECTIVES_DOCUMENT.definitions, ...doc.definitions, ...EXTRA_SCALARS_DOCUMENT.definitions],
    };
    const schemaDef = doc.definitions.find(d => d.kind === language_1.Kind.SCHEMA_DEFINITION);
    const queryOperation = schemaDef ? schemaDef.operationTypes.find(o => o.operation === 'query') : undefined;
    const queryName = queryOperation ? queryOperation.type.name.value : 'Query';
    const existingQueryType = doc.definitions.find(d => d.kind !== language_1.Kind.DIRECTIVE_DEFINITION && d.kind !== language_1.Kind.SCHEMA_DEFINITION && d.name && d.name.value === queryName);
    if (!existingQueryType) {
        fullDocument.definitions.push(...NOOP_QUERY.definitions);
    }
    const schema = buildASTSchema_1.buildASTSchema(fullDocument);
    return validation_1.validate(schema, fullDocument, exports.specifiedRules);
};
//# sourceMappingURL=validation.js.map