"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transformer = void 0;
const graphql_1 = require("graphql");
const errors_1 = require("./errors");
class Transformer {
    constructor(name, document) {
        const doc = typeof document === 'string' ? graphql_1.parse(document) : document;
        this.name = name;
        const directives = doc.definitions.filter(d => d.kind === graphql_1.Kind.DIRECTIVE_DEFINITION);
        const extraDefs = doc.definitions.filter(d => d.kind !== graphql_1.Kind.DIRECTIVE_DEFINITION);
        if (directives.length !== 1) {
            throw new errors_1.InvalidTransformerError('Transformers must specify exactly one directive definition.');
        }
        this.directive = directives[0];
        this.typeDefinitions = extraDefs;
    }
}
exports.Transformer = Transformer;
//# sourceMappingURL=Transformer.js.map