"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getGraphQLTypeFromMySQLType = exports.getArgumentNode = exports.getOperationTypeDefinition = exports.getDirectiveNode = exports.getStringValueNode = exports.getListValueNode = exports.getSingletonListTypeNode = exports.getNameNode = exports.getInputTypeDefinition = exports.getTypeDefinition = exports.getFieldDefinition = exports.getOperationFieldDefinition = exports.getInputValueDefinition = exports.getNamedType = exports.getNonNullType = void 0;
const graphql_1 = require("graphql");
const intTypes = [`INTEGER`, `INT`, `SMALLINT`, `TINYINT`, `MEDIUMINT`, `BIGINT`, `BIT`];
const floatTypes = [`FLOAT`, `DOUBLE`, `REAL`, `REAL_AS_FLOAT`, `DOUBLE PRECISION`, `DEC`, `DECIMAL`, `FIXED`, `NUMERIC`];
function getNonNullType(typeNode) {
    return {
        kind: graphql_1.Kind.NON_NULL_TYPE,
        type: typeNode,
    };
}
exports.getNonNullType = getNonNullType;
function getNamedType(name) {
    return {
        kind: graphql_1.Kind.NAMED_TYPE,
        name: {
            kind: graphql_1.Kind.NAME,
            value: name,
        },
    };
}
exports.getNamedType = getNamedType;
function getInputValueDefinition(typeNode, name) {
    return {
        kind: graphql_1.Kind.INPUT_VALUE_DEFINITION,
        name: {
            kind: graphql_1.Kind.NAME,
            value: name,
        },
        type: typeNode,
        directives: [],
    };
}
exports.getInputValueDefinition = getInputValueDefinition;
function getOperationFieldDefinition(name, args, type, directives) {
    return {
        kind: graphql_1.Kind.FIELD_DEFINITION,
        name: {
            kind: graphql_1.Kind.NAME,
            value: name,
        },
        arguments: args,
        type: type,
        directives: directives || [],
    };
}
exports.getOperationFieldDefinition = getOperationFieldDefinition;
function getFieldDefinition(fieldName, type) {
    return {
        kind: graphql_1.Kind.FIELD_DEFINITION,
        name: {
            kind: graphql_1.Kind.NAME,
            value: fieldName,
        },
        type,
        directives: [],
    };
}
exports.getFieldDefinition = getFieldDefinition;
function getTypeDefinition(fields, typeName) {
    return {
        kind: graphql_1.Kind.OBJECT_TYPE_DEFINITION,
        name: {
            kind: graphql_1.Kind.NAME,
            value: typeName,
        },
        fields: fields,
        directives: [],
        interfaces: [],
    };
}
exports.getTypeDefinition = getTypeDefinition;
function getInputTypeDefinition(fields, typeName) {
    return {
        kind: graphql_1.Kind.INPUT_OBJECT_TYPE_DEFINITION,
        name: {
            kind: graphql_1.Kind.NAME,
            value: typeName,
        },
        fields: fields,
        directives: [],
    };
}
exports.getInputTypeDefinition = getInputTypeDefinition;
function getNameNode(name) {
    return {
        kind: graphql_1.Kind.NAME,
        value: name,
    };
}
exports.getNameNode = getNameNode;
function getSingletonListTypeNode(name) {
    return {
        kind: graphql_1.Kind.LIST_TYPE,
        type: getNamedType(name),
    };
}
exports.getSingletonListTypeNode = getSingletonListTypeNode;
function getListValueNode(values) {
    return {
        kind: graphql_1.Kind.LIST,
        values: values,
    };
}
exports.getListValueNode = getListValueNode;
function getStringValueNode(value) {
    return {
        kind: graphql_1.Kind.STRING,
        value: value,
    };
}
exports.getStringValueNode = getStringValueNode;
function getDirectiveNode(mutationName) {
    return {
        kind: graphql_1.Kind.DIRECTIVE,
        name: this.getNameNode('aws_subscribe'),
        arguments: [this.getArgumentNode(mutationName)],
    };
}
exports.getDirectiveNode = getDirectiveNode;
function getOperationTypeDefinition(operationType, operation) {
    return {
        kind: graphql_1.Kind.OPERATION_TYPE_DEFINITION,
        operation: operationType,
        type: operation,
    };
}
exports.getOperationTypeDefinition = getOperationTypeDefinition;
function getArgumentNode(argument) {
    return {
        kind: graphql_1.Kind.ARGUMENT,
        name: this.getNameNode('mutations'),
        value: this.getListValueNode([this.getStringValueNode(argument)]),
    };
}
exports.getArgumentNode = getArgumentNode;
function getGraphQLTypeFromMySQLType(dbType) {
    const normalizedType = dbType.toUpperCase().split('(')[0];
    if (`BOOL` == normalizedType) {
        return `Boolean`;
    }
    else if (`JSON` == normalizedType) {
        return `AWSJSON`;
    }
    else if (`TIME` == normalizedType) {
        return `AWSTime`;
    }
    else if (`DATE` == normalizedType) {
        return `AWSDate`;
    }
    else if (`DATETIME` == normalizedType) {
        return `AWSDateTime`;
    }
    else if (`TIMESTAMP` == normalizedType) {
        return `AWSTimestamp`;
    }
    else if (intTypes.indexOf(normalizedType) > -1) {
        return `Int`;
    }
    else if (floatTypes.indexOf(normalizedType) > -1) {
        return `Float`;
    }
    return `String`;
}
exports.getGraphQLTypeFromMySQLType = getGraphQLTypeFromMySQLType;
//# sourceMappingURL=RelationalDBSchemaTransformerUtils.js.map