"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColumnDescription = exports.DataApiParams = exports.AuroraDataAPIClient = void 0;
class AuroraDataAPIClient {
    constructor(databaseRegion, awsSecretStoreArn, dbClusterOrInstanceArn, database, aws) {
        this.listTables = async () => {
            this.Params.sql = 'SHOW TABLES';
            const response = await this.RDS.executeStatement(this.Params).promise();
            let tableList = [];
            const records = response['records'];
            for (const record of records) {
                tableList.push(record[0]['stringValue']);
            }
            return tableList;
        };
        this.describeTable = async (tableName) => {
            this.Params.sql = `DESCRIBE \`${tableName}\``;
            const response = await this.RDS.executeStatement(this.Params).promise();
            const listOfColumns = response['records'];
            let columnDescriptions = [];
            for (const column of listOfColumns) {
                let colDescription = new ColumnDescription();
                colDescription.Field = column[MYSQL_DESCRIBE_TABLE_ORDER.Field]['stringValue'];
                colDescription.Type = column[MYSQL_DESCRIBE_TABLE_ORDER.Type]['stringValue'];
                colDescription.Null = column[MYSQL_DESCRIBE_TABLE_ORDER.Null]['stringValue'];
                colDescription.Key = column[MYSQL_DESCRIBE_TABLE_ORDER.Key]['stringValue'];
                colDescription.Default = column[MYSQL_DESCRIBE_TABLE_ORDER.Default]['stringValue'];
                colDescription.Extra = column[MYSQL_DESCRIBE_TABLE_ORDER.Extra]['stringValue'];
                columnDescriptions.push(colDescription);
            }
            return columnDescriptions;
        };
        this.getTableForeignKeyReferences = async (tableName) => {
            this.Params.sql = `SELECT TABLE_NAME FROM information_schema.key_column_usage 
            WHERE referenced_table_name is not null 
            AND REFERENCED_TABLE_NAME = '${tableName}';`;
            const response = await this.RDS.executeStatement(this.Params).promise();
            let tableList = [];
            const records = response['records'];
            for (const record of records) {
                tableList.push(record[0]['stringValue']);
            }
            return tableList;
        };
        this.AWS = aws;
        this.AWS.config.update({
            region: databaseRegion,
        });
        this.RDS = new this.AWS.RDSDataService();
        this.Params = new DataApiParams();
        this.Params.secretArn = awsSecretStoreArn;
        this.Params.resourceArn = dbClusterOrInstanceArn;
        this.Params.database = database;
    }
    setRDSClient(rdsClient) {
        this.RDS = rdsClient;
    }
}
exports.AuroraDataAPIClient = AuroraDataAPIClient;
class DataApiParams {
}
exports.DataApiParams = DataApiParams;
class ColumnDescription {
}
exports.ColumnDescription = ColumnDescription;
var MYSQL_DESCRIBE_TABLE_ORDER;
(function (MYSQL_DESCRIBE_TABLE_ORDER) {
    MYSQL_DESCRIBE_TABLE_ORDER[MYSQL_DESCRIBE_TABLE_ORDER["Field"] = 0] = "Field";
    MYSQL_DESCRIBE_TABLE_ORDER[MYSQL_DESCRIBE_TABLE_ORDER["Type"] = 1] = "Type";
    MYSQL_DESCRIBE_TABLE_ORDER[MYSQL_DESCRIBE_TABLE_ORDER["Null"] = 2] = "Null";
    MYSQL_DESCRIBE_TABLE_ORDER[MYSQL_DESCRIBE_TABLE_ORDER["Key"] = 3] = "Key";
    MYSQL_DESCRIBE_TABLE_ORDER[MYSQL_DESCRIBE_TABLE_ORDER["Default"] = 4] = "Default";
    MYSQL_DESCRIBE_TABLE_ORDER[MYSQL_DESCRIBE_TABLE_ORDER["Extra"] = 5] = "Extra";
})(MYSQL_DESCRIBE_TABLE_ORDER || (MYSQL_DESCRIBE_TABLE_ORDER = {}));
//# sourceMappingURL=AuroraDataAPIClient.js.map