"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateUpdateInputWithConnectionField = exports.updateCreateInputWithConnectionField = void 0;
const graphql_transformer_common_1 = require("graphql-transformer-common");
function updateCreateInputWithConnectionField(input, connectionFieldName, nonNull = false) {
    const keyFieldExists = Boolean(input.fields.find(f => f.name.value === connectionFieldName));
    if (keyFieldExists) {
        return input;
    }
    const updatedFields = [
        ...input.fields,
        graphql_transformer_common_1.makeInputValueDefinition(connectionFieldName, nonNull ? graphql_transformer_common_1.makeNonNullType(graphql_transformer_common_1.makeNamedType('ID')) : graphql_transformer_common_1.makeNamedType('ID')),
    ];
    return {
        ...input,
        fields: updatedFields,
    };
}
exports.updateCreateInputWithConnectionField = updateCreateInputWithConnectionField;
function updateUpdateInputWithConnectionField(input, connectionFieldName) {
    const keyFieldExists = Boolean(input.fields.find(f => f.name.value === connectionFieldName));
    if (keyFieldExists) {
        return input;
    }
    const updatedFields = [...input.fields, graphql_transformer_common_1.makeInputValueDefinition(connectionFieldName, graphql_transformer_common_1.makeNamedType('ID'))];
    return {
        ...input,
        fields: updatedFields,
    };
}
exports.updateUpdateInputWithConnectionField = updateUpdateInputWithConnectionField;
//# sourceMappingURL=definitions.js.map