"use strict";
const aws_route53_1 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const util_1 = require("../lib/util");
module.exports = {
    'apex domain': {
        'returns right domain'(test) {
            test.equals('domain.com', util_1.apexDomain('domain.com'));
            test.equals('domain.com', util_1.apexDomain('test.domain.com'));
            test.done();
        },
        'understands eTLDs'(test) {
            test.equals('domain.co.uk', util_1.apexDomain('test.domain.co.uk'));
            test.done();
        },
    },
    'isDnsValidatedCertificate': {
        'new DnsValidatedCertificate is a DnsValidatedCertificate'(test) {
            const stack = new core_1.Stack();
            const hostedZone = new aws_route53_1.PublicHostedZone(stack, 'ExampleDotCom', {
                zoneName: 'example.com',
            });
            const cert = new lib_1.DnsValidatedCertificate(stack, 'Certificate', {
                domainName: 'test.example.com',
                hostedZone,
            });
            test.ok(util_1.isDnsValidatedCertificate(cert));
            test.done();
        },
        'new Certificate is not a DnsValidatedCertificate'(test) {
            const stack = new core_1.Stack();
            const cert = new lib_1.Certificate(stack, 'Certificate', {
                domainName: 'test.example.com',
            });
            test.ok(!util_1.isDnsValidatedCertificate(cert));
            test.done();
        },
        'fromCertificateArn is not a DnsValidatedCertificate'(test) {
            const stack = new core_1.Stack();
            const cert = lib_1.Certificate.fromCertificateArn(stack, 'Certificate', 'cert-arn');
            test.ok(!util_1.isDnsValidatedCertificate(cert));
            test.done();
        },
    },
    'getCertificateRegion': {
        'from stack'(test) {
            // GIVEN
            const app = new core_1.App();
            const stack = new core_1.Stack(app, 'RegionStack', { env: { region: 'eu-west-1' } });
            const certificate = new lib_1.Certificate(stack, 'TestCertificate', {
                domainName: 'www.example.com',
            });
            test.equals(util_1.getCertificateRegion(certificate), 'eu-west-1');
            test.done();
        },
        'from DnsValidatedCertificate region'(test) {
            // GIVEN
            const app = new core_1.App();
            const stack = new core_1.Stack(app, 'RegionStack', { env: { region: 'eu-west-1' } });
            const hostedZone = new aws_route53_1.PublicHostedZone(stack, 'ExampleDotCom', {
                zoneName: 'example.com',
            });
            const certificate = new lib_1.DnsValidatedCertificate(stack, 'TestCertificate', {
                domainName: 'www.example.com',
                hostedZone,
                region: 'eu-west-3',
            });
            test.equals(util_1.getCertificateRegion(certificate), 'eu-west-3');
            test.done();
        },
        'fromCertificateArn'(test) {
            // GIVEN
            const app = new core_1.App();
            const stack = new core_1.Stack(app, 'RegionStack', { env: { region: 'eu-west-1' } });
            const certificate = lib_1.Certificate.fromCertificateArn(stack, 'TestCertificate', 'arn:aws:acm:us-east-2:1111111:certificate/11-3336f1-44483d-adc7-9cd375c5169d');
            test.equals(util_1.getCertificateRegion(certificate), 'us-east-2');
            test.done();
        },
        'region agnostic stack'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            const certificate = new lib_1.Certificate(stack, 'TestCertificate', {
                domainName: 'www.example.com',
            });
            test.equals(util_1.getCertificateRegion(certificate), '${Token[AWS::Region.4]}');
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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