"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubnetGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const rds_generated_1 = require("./rds.generated");
/**
 * Class for creating a RDS DB subnet group.
 *
 * @stability stable
 * @resource AWS::RDS::DBSubnetGroup
 */
class SubnetGroup extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const { subnetIds } = props.vpc.selectSubnets((_b = props.vpcSubnets) !== null && _b !== void 0 ? _b : { subnetType: ec2.SubnetType.PRIVATE });
        // Using 'Default' as the resource id for historical reasons (usage from `Instance` and `Cluster`).
        const subnetGroup = new rds_generated_1.CfnDBSubnetGroup(this, 'Default', {
            dbSubnetGroupDescription: props.description,
            // names are actually stored by RDS changed to lowercase on the server side,
            // and not lowercasing them in CloudFormation means things like { Ref }
            // do not work correctly
            dbSubnetGroupName: core_1.Token.isUnresolved(props.subnetGroupName)
                ? props.subnetGroupName
                : (_c = props.subnetGroupName) === null || _c === void 0 ? void 0 : _c.toLowerCase(),
            subnetIds,
        });
        if (props.removalPolicy) {
            subnetGroup.applyRemovalPolicy(props.removalPolicy);
        }
        this.subnetGroupName = subnetGroup.ref;
    }
    /**
     * Imports an existing subnet group by name.
     *
     * @stability stable
     */
    static fromSubnetGroupName(scope, id, subnetGroupName) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.subnetGroupName = subnetGroupName;
            }
        }(scope, id);
    }
}
exports.SubnetGroup = SubnetGroup;
_a = JSII_RTTI_SYMBOL_1;
SubnetGroup[_a] = { fqn: "@aws-cdk/aws-rds.SubnetGroup", version: "1.98.0" };
//# sourceMappingURL=data:application/json;base64,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