"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const secretsmanager = require("@aws-cdk/aws-secretsmanager");
const core_1 = require("@aws-cdk/core");
const util_1 = require("./private/util");
/**
 * A database secret.
 *
 * @stability stable
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends secretsmanager.Secret {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c;
        const excludeCharacters = (_b = props.excludeCharacters) !== null && _b !== void 0 ? _b : util_1.DEFAULT_PASSWORD_EXCLUDE_CHARS;
        super(scope, id, {
            encryptionKey: props.encryptionKey,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            secretName: props.secretName,
            generateSecretString: {
                passwordLength: 30,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: (_c = props.masterSecret) === null || _c === void 0 ? void 0 : _c.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters,
            },
        });
        if (props.replaceOnPasswordCriteriaChanges) {
            const hash = crypto.createHash('md5');
            hash.update(JSON.stringify({
                // Use here the options that influence the password generation.
                // If at some point we add other password customization options
                // they sould be added here below (e.g. `passwordLength`).
                excludeCharacters,
            }));
            const logicalId = `${core_1.Names.uniqueId(this)}${hash.digest('hex')}`;
            const secret = this.node.defaultChild;
            secret.overrideLogicalId(logicalId.slice(-255)); // Take last 255 chars
        }
    }
}
exports.DatabaseSecret = DatabaseSecret;
_a = JSII_RTTI_SYMBOL_1;
DatabaseSecret[_a] = { fqn: "@aws-cdk/aws-rds.DatabaseSecret", version: "1.98.0" };
//# sourceMappingURL=data:application/json;base64,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