from setuptools import setup

if __name__ == '__main__':
    setup(
        name='stackctl',
        version='0.0.2',
        author='Zach Kazanski',
        author_email='kazanski.zachary@gmail.com',
        description='Wrapper around python-novaclient to facilitate cloning and maintianing openstack instances.',
        url="https://github.com/Kazanz/stackctl",
        packages=['stackctl'],
        keywords=['openstack'],
        install_requires=[
            "ansicolors==1.0.2",
            "Babel==2.1.1",
            "debtcollector==1.0.0",
            "ecdsa==0.13",
            "iso8601==0.1.11",
            "keystoneauth1==2.0.0",
            "monotonic==0.4",
            "msgpack-python==0.4.6",
            "netaddr==0.7.18",
            "netifaces==0.10.4",
            "oslo.config==3.0.0",
            "oslo.i18n==3.0.0",
            "oslo.serialization==2.0.0",
            "oslo.utils==3.0.0",
            "paramiko==1.16.0",
            "pbr==1.8.1",
            "prettytable==0.7.2",
            "progressbar2==3.5.1",
            "pycrypto==2.6.1",
            "python-keystoneclient==2.0.0",
            "python-novaclient==2.35.0",
            "pytz==2015.7",
            "requests==2.8.1",
            "simplejson==3.8.1",
            "six==1.10.0",
            "stevedore==1.9.0",
            "tabulate==0.7.5",
            "wrapt==1.10.5",
        ],
        entry_points={
            'console_scripts': [
                'stackctl=stackctl.stackctl:cli',
            ],
        },
        classifiers=[
            'Programming Language :: Python',
            'Intended Audience :: Developers',
            'Operating System :: OS Independent',
            'License :: OSI Approved :: MIT License',
            'Programming Language :: Python :: 2.7',
        ],
    )
