# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['layeredimage']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=8.0.1,<10',
 'blendmodes>=2020.3.0,<2022',
 'defusedxml>=0.6.0,<2',
 'gimpformats>=2020.3.0,<2022',
 'metprint>=2020.7.1,<2022',
 'psdtoolsx>=19.5.0,<21',
 'pylsr>=2020.1.0,<2022',
 'pyora>=0.3.10,<2',
 'pypdn>=1.0.6,<3']

setup_kwargs = {
    'name': 'layeredimage',
    'version': '2021.1.1',
    'description': 'Use this module to read, and write to a number of layered image formats',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/LayeredImage.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/layeredimage.svg?style=for-the-badge)](https://pypistats.org/packages/layeredimage)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Flayeredimage)](https://pepy.tech/project/layeredimage)\n[![PyPI Version](https://img.shields.io/pypi/v/layeredimage.svg?style=for-the-badge)](https://pypi.org/project/layeredimage)\n\n<!-- omit in TOC -->\n# LayeredImage\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nUse this module to read, and write to a number of layered image formats\n\n- [Compatibility](#compatibility)\n\t- [Overview](#overview)\n\t\t- [Key](#key)\n\t- [Reading](#reading)\n\t\t- [Group](#group)\n\t\t- [Layer](#layer)\n\t- [Writing](#writing)\n\t\t- [Group](#group-1)\n\t\t- [Layer](#layer-1)\n- [.layered](#layered)\n- [Example Usage](#example-usage)\n- [Documentation](#documentation)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Compatibility\n\nBear in mind that the tables below may not be completely accurate. If that is\nthe case, please open an issue and I will fix the tables.\n\n### Overview\n\n#### Key\n- :heavy_check_mark: - Supported\n- :warning: - Things will look the same, but data is lost\n- :x: - This is not supported and will cause loss of data\n- N/A - The source format does not support this so treat this as a :heavy_check_mark:\n\n|Format|.ora|.pdn|.xcf|.psd|.tiff/ .tif|.webp|.gif|.lsr|\n|------|----|----|----|----|-----|----|-----|----|\n|Read  |:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|\n|Layers|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|\n|Groups|:heavy_check_mark:|N/A |:heavy_check_mark:|:heavy_check_mark:|N/A|N/A|N/A|:heavy_check_mark:|\n|Write |:heavy_check_mark:|:x:  |:x:  |:x:  |:warning:|:warning:|:warning:|:heavy_check_mark:|\n\n### Reading\n\n#### Group\n\n|Format    |.ora|.pdn|.xcf|.psd|.tiff/ .tif|.webp|.gif|.lsr|\n|----------|----|----|----|----|-----|----|-----|----|\n|Name      |:heavy_check_mark:|N/A |:heavy_check_mark:|:heavy_check_mark:|N/A |N/A |N/A |:heavy_check_mark:|\n|Dimensions|:warning:|N/A |:heavy_check_mark:|:heavy_check_mark:|N/A |N/A |N/A |:heavy_check_mark:|\n|Offsets   |:heavy_check_mark:|N/A |:heavy_check_mark:|:heavy_check_mark:|N/A |N/A |N/A |:heavy_check_mark:|\n|Opacity   |:heavy_check_mark:|N/A |:heavy_check_mark:|:heavy_check_mark:|N/A |N/A |N/A |N/A |\n|Visibility|:heavy_check_mark:|N/A |:heavy_check_mark:  |:heavy_check_mark:|N/A |N/A |N/A |N/A |\n|Blend Mode|:heavy_check_mark:|N/A |:heavy_check_mark:|:heavy_check_mark:|N/A|N/A |N/A |N/A |\n\n#### Layer\n\n|Format    |.ora|.pdn|.xcf|.psd|.tiff/ .tif|.webp|.gif|.lsr|\n|----------|----|----|----|----|-----|----|-----|----|\n|Name      |:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:warning:|:warning:|:heavy_check_mark:|\n|Dimensions|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|\n|Offsets   |:heavy_check_mark:|N/A |:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|N/A|N/A|N/A |\n|Opacity   |:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|N/A |N/A |N/A |N/A |\n|Visibility|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:  |:heavy_check_mark:|N/A |N/A |N/A |N/A |\n|Blend Mode|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|N/A|N/A |N/A |N/A |\n\n### Writing\n\n#### Group\n\n|Format    |.ora|.pdn|.xcf|.psd|.tiff/ .tif|.webp|.gif|.lsr|\n|----------|----|----|----|----|-----|----|-----|----|\n|Name      |:heavy_check_mark:|:x:|:x:|:x:|:x:|:x:|:x:|:heavy_check_mark:|\n|Dimensions|:heavy_check_mark:|:x:|:x:|:x:|:warning:|:warning:|:warning:|:heavy_check_mark:|\n|Offsets   |:heavy_check_mark:|:x:|:x:|:x:|:warning:|:warning:|:warning:|:heavy_check_mark:|\n|Opacity   |:heavy_check_mark:|:x:|:x:|:x:|:warning:|:warning:|:warning:|:warning:|\n|Visibility|:heavy_check_mark:|:x:|:x:|:x:|:warning:|:warning:|:warning:|:warning:|\n|Blend Mode|:heavy_check_mark:|:x:|:x:|:x:|:x:|:x:|:x:|:x:|\n\n```none\nLayers are extracted from groups and saved to TIFF/ GIF or WEBP\n```\n\n#### Layer\n\n|Format    |.ora|.pdn|.xcf|.psd|.tiff/ .tif|.webp|.gif|.lsr|\n|----------|----|----|----|----|-----|----|-----|----|\n|Name      |:heavy_check_mark:|:x:|:x:|:x:|:x:|:x:|:x:|:warning:|\n|Dimensions|:heavy_check_mark:|:x:|:x:|:x:|:warning:|:warning:|:warning:|:warning:|\n|Offsets   |:heavy_check_mark:|:x:|:x:|:x:|:warning:|:warning:|:warning:|:warning:|\n|Opacity   |:heavy_check_mark:|:x:|:x:|:x:|:warning:|:warning:|:warning:|:warning:|\n|Visibility|:heavy_check_mark:|:x:|:x:|:x:|:warning:|:warning:|:warning:|:warning:|\n|Blend Mode|:heavy_check_mark:|:x:|:x:|:x:|:x:|:x:|:x:|:x:|\n\n```none\nLayers are rasterized before being written to TIFF/ GIF or WEBP\nFirst child layers are placed in a group when written to LSR\n```\n\n## .layered\n.layered is highly inspired by the open raster format and aims to provide an\nexchange format in the cases when saving in ora would cause unacceptable data\nloss. .layered has been designed so that if the format became deprecated and no\nreaders existed for it tomorrow, the data would be easily salvageable.\n\nSee the [LAYERED_SPEC](/LAYERED_SPEC.md) for more information.\n\n\n## Example Usage\n\nHere\'s some basic example usage below.\n\n```python\n"""Example module """\nfrom pathlib import Path\nTHISDIR = str(Path(__file__).resolve().parent)\nimport layeredimage.io\n\n# Do stuff\nora = layeredimage.io.openLayerImage(THISDIR + "/image.ora")\n\nimageDimensions = ora.dimensions\n# There are a load of handy functions for getting layers, and adding new\n# layers, but here we will act directly on the object\nlayer = ora.layersAndGroups[0] # For the sake of the e.g. this is a layer\n\n# Lets overwrite the layer with a transparent image (bit boring I know...)\nlayer.image = Image.new("RGBA", imageDimensions)\nora.layersAndGroups[0] = layer\n\n# And let\'s save\nlayeredimage.io.saveLayerImage(THISDIR + "/image(modified).ora", ora)\n\n# Let\'s save a flattened version too\nora.getFlattenLayers().save(THISDIR + "/image(modified).png")\n\n# Doing stuff with a group\ngroup = ora.getLayerOrGroup(1) # For the sake of the e.g. this is a group\ngroup.layers[0].image.show() # Open the image of the first layer of the group\n\n# Deleting a layer/ group\nora.removeLayerOrGroup(2)\n```\n\nImages are PIL.Image (s) and so you can use the power of Pillow to apply\nfilters, and other modifications to the images.\n\nSee below for an old version of the tests. These provide a few examples of\nfile conversions. Not going to get 100% coverage anytime soon but hopefully\nthis will help a little.\n\n```python\n"""Test module """\n\nimport sys\nimport os\nfrom pathlib import Path\nTHISDIR = str(Path(__file__).resolve().parent)\nsys.path.insert(0, os.path.dirname(THISDIR))\nimport layeredimage.io\n\n# ORA\nora = layeredimage.io.openLayerImage(THISDIR + "/base24.ora")\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(ora).ora", ora)\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(ora).tiff", ora)\nora.getFlattenLayers().save(THISDIR + "/base24(ora).png")\n\n# PSD\npsd = layeredimage.io.openLayerImage(THISDIR + "/base24.psd")\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(psd).ora", psd)\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(psd).tiff", psd)\npsd.getFlattenLayers().save(THISDIR + "/base24(psd).png")\n\n# PDN\npdn = layeredimage.io.openLayerImage(THISDIR + "/base24.pdn")\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(pdn).ora", pdn)\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(pdn).tiff", pdn)\npdn.getFlattenLayers().save(THISDIR + "/base24(pdn).png")\n\n# XCF\nxcf = layeredimage.io.openLayerImage(THISDIR + "/base24.xcf")\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(xcf).ora", xcf)\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(xcf).tiff", xcf)\nxcf.getFlattenLayers().save(THISDIR + "/base24(xcf).png")\n\n# TIFF\ntiff = layeredimage.io.openLayerImage(THISDIR + "/base24.tiff")\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(tiff).ora", tiff)\nlayeredimage.io.saveLayerImage(THISDIR + "/base24(tiff).tiff", tiff)\ntiff.getFlattenLayers().save(THISDIR + "/base24(tiff).png")\n```\n\n## Documentation\nSee the [Docs](/DOCS/) for more information.\n\n## Install With PIP\n```python\npip install layeredimage\n```\n\nHead to https://pypi.org/project/layeredimage/ for more info\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.9.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.9\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.9 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.9)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n## Download Project\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\n$ git clone https://github.com/FHPythonUtils/LayeredImage\n```\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n### Licence\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/LayeredImage',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
