/***************************************************************************
  **************************************************************************
    
  Spherical Harmonic Transform Kit 2.7
    
  Copyright 1997-2003  Sean Moore, Dennis Healy,
                       Dan Rockmore, Peter Kostelec
  Copyright 2004  Peter Kostelec, Dan Rockmore

  This file is part of SpharmonicKit.

  SpharmonicKit is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  SpharmonicKit is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
  See the accompanying LICENSE file for details.

  ************************************************************************
  ************************************************************************/

/* quadrature weights file */


/**
  contains precomputed arrays of Legendre quadrature weight values
  for ODD order !!! The sin factor is already present here !!!
  In a nutshell, the purpose of precomputing these weights is to
  save a multiplication in seminaivex.c (when the order is odd).
  **/

/***

  The interface function to these arrays is defined at the end
  of this file. It is

  const double *get_oddweights( int bw )

  ***/

static const double ow4[8] =
{0.0130677244459852, 0.1238854579060207, 0.2695229693546575, 0.3784620915132186, 
 0.3784620915135136, 0.2695229693547305, 0.1238854579060396, 0.0130677244459872};

static const double ow8[16] =
{0.0016469580173477, 0.0169341816445308, 0.0432357135521227, 0.0793813894095676, 
 0.1170279554057073, 0.1529422668923013, 0.1796652878558445, 0.1945100966313875, 
 0.1945100966320044, 0.1796652878560336, 0.1529422668923990, 0.1170279554057610, 
 0.0793813894095944, 0.0432357135521349, 0.0169341816445349, 0.0016469580173482};

static const double ow16[32] =
{0.0002062930740058, 0.0021640291839523, 0.0057415678114794, 0.0111972504895041, 
 0.0178930728089408, 0.0259990600279925, 0.0347897736331906, 0.0443206791778128, 
 0.0538581883411703, 0.0633727713806255, 0.0721958552759619, 0.0802540295805748, 
 0.0870119991694323, 0.0923933475135159, 0.0960521727207131, 0.0979413816063274, 
 0.0979413816075809, 0.0960521727211216, 0.0923933475137517, 0.0870119991695906, 
 0.0802540295806897, 0.0721958552760469, 0.0633727713806883, 0.0538581883412164, 
 0.0443206791778439, 0.0347897736332128, 0.0259990600280075, 0.0178930728089499, 
 0.0111972504895093, 0.0057415678114816, 0.0021640291839533, 0.0002062930740059};

static const double ow32[64] =
{0.0000257998762313, 0.0002719963328992, 0.0007285551655023, 0.0014419143849654, 
 0.0023492196299524, 0.0034990775392484, 0.0048228709609411, 0.0063650580023922, 
 0.0080542400902157, 0.0099298000591963, 0.0119191123704765, 0.0140563265952599, 
 0.0162689596309466, 0.0185860547971697, 0.0209366261496682, 0.0233449007140944, 
 0.0257427470523766, 0.0281499721421785, 0.0305026394644358, 0.0328165981698009, 
 0.0350333990269573, 0.0371654265132021, 0.0391609283963208, 0.0410293162611077, 
 0.0427266274173210, 0.0442597612670725, 0.0455934877956728, 0.0467325973884478, 
 0.0476513580258637, 0.0483527742646833, 0.0488211762339878, 0.0490580082650788, 
 0.0490580082676000, 0.0488211762348225, 0.0483527742651796, 0.0476513580262125, 
 0.0467325973887132, 0.0455934877958839, 0.0442597612672463, 0.0427266274174657, 
 0.0410293162612303, 0.0391609283964271, 0.0371654265132945, 0.0350333990270351, 
 0.0328165981698689, 0.0305026394644934, 0.0281499721422278, 0.0257427470524194, 
 0.0233449007141283, 0.0209366261496963, 0.0185860547971938, 0.0162689596309663, 
 0.0140563265952755, 0.0119191123704894, 0.0099298000592062, 0.0080542400902239, 
 0.0063650580023980, 0.0048228709609452, 0.0034990775392512, 0.0023492196299544, 
 0.0014419143849666, 0.0007285551655031, 0.0002719963328996, 0.0000257998762314};

static const double ow64[128] =
{0.0000032253984437, 0.0000340463131158, 0.0000914113258540, 0.0001815794657534, 
 0.0002972579769116, 0.0004454616309845, 0.0006184538564501, 0.0008232297879527, 
 0.0010518793946314, 0.0013112566599011, 0.0015933553489263, 0.0019048449349610, 
 0.0022376655422937, 0.0025982788787924, 0.0029786044203960, 0.0033848806292108, 
 0.0038090361826578, 0.0042570748486767, 0.0047209633097769, 0.0052064617945353, 
 0.0057056035126863, 0.0062238982588875, 0.0067534742806377, 0.0072995856431080, 
 0.0078544841887785, 0.0084231643337913, 0.0089980300767539, 0.0095838134769448, 
 0.0101730991587936, 0.0107703551919536, 0.0113683750802881, 0.0119713622227730, 
 0.0125723468987302, 0.0131752679901405, 0.0137734199390811, 0.0143704779852115, 
 0.0149600274557836, 0.0155454814319868, 0.0161207420259307, 0.0166889621432480, 
 0.0172443856007590, 0.0177899075024394, 0.0183201371555761, 0.0188377145219606, 
 0.0193376369013747, 0.0198222919565129, 0.0202870860544883, 0.0207341574880596, 
 0.0211593412034746, 0.0215645290465210, 0.0219460023643870, 0.0223054093866584, 
 0.0226394938764397, 0.0229496631067230, 0.0232331373589767, 0.0234910853670587, 
 0.0237212160271207, 0.0239244616468889, 0.0240990297467417, 0.0242456179638030, 
 0.0243629402984804, 0.0244514610722414, 0.0245104064147662, 0.0245400082524635, 
 0.0245400082575181, 0.0245104064164491, 0.0244514610732485, 0.0243629402991958, 
 0.0242456179643576, 0.0240990297471916, 0.0239244616472670, 0.0237212160274452, 
 0.0234910853673425, 0.0232331373592268, 0.0229496631069464, 0.0226394938766414, 
 0.0223054093868395, 0.0219460023645526, 0.0215645290466719, 0.0211593412036139, 
 0.0207341574881874, 0.0202870860546083, 0.0198222919566235, 0.0193376369014777, 
 0.0188377145220570, 0.0183201371556643, 0.0177899075025212, 0.0172443856008336, 
 0.0166889621433190, 0.0161207420259947, 0.0155454814320465, 0.0149600274558390, 
 0.0143704779852628, 0.0137734199391291, 0.0131752679901853, 0.0125723468987703, 
 0.0119713622228087, 0.0113683750803208, 0.0107703551919828, 0.0101730991588207, 
 0.0095838134769692, 0.0089980300767763, 0.0084231643338125, 0.0078544841887972, 
 0.0072995856431249, 0.0067534742806529, 0.0062238982589012, 0.0057056035126984, 
 0.0052064617945460, 0.0047209633097861, 0.0042570748486851, 0.0038090361826649, 
 0.0033848806292171, 0.0029786044204013, 0.0025982788787973, 0.0022376655422979, 
 0.0019048449349640, 0.0015933553489289, 0.0013112566599029, 0.0010518793946331, 
 0.0008232297879540, 0.0006184538564511, 0.0004454616309852, 0.0002972579769120, 
 0.0001815794657536, 0.0000914113258541, 0.0000340463131159, 0.0000032253984437};

static const double ow128[256] =
{0.0000004031877411, 0.0000042572517279, 0.0000114371212962, 0.0000227394678764, 
 0.0000372706105964, 0.0000559374174465, 0.0000778003287466, 0.0001037808939654, 
 0.0001329253585440, 0.0001661559916342, 0.0002025122569627, 0.0002429127798856, 
 0.0002863931929124, 0.0003338664588291, 0.0003843660183533, 0.0004387979596864, 
 0.0004961946768772, 0.0005574545147950, 0.0006216097483909, 0.0006895502807964, 
 0.0007603090893828, 0.0008347670328544, 0.0009119585571518, 0.0009927549337468, 
 0.0010761928130954, 0.0011631333778394, 0.0012526162019960, 0.0013454919086076, 
 0.0014408037047417, 0.0015393912077987, 0.0016403019619817, 0.0017443641539806, 
 0.0018506303661590, 0.0019599169479956, 0.0020712822192443, 0.0021855303026347, 
 0.0023017259533606, 0.0024206606936965, 0.0025414064113338, 0.0026647416694145, 
 0.0027897461840940, 0.0029171852151115, 0.0030461470016833, 0.0031773831697918, 
 0.0033099911745278, 0.0034447086912688, 0.0035806430814968, 0.0037185177662876, 
 0.0038574507011619, 0.0039981507620213, 0.0041397471825670, 0.0042829340151838, 
 0.0044268524517274, 0.0045721814549507, 0.0047180748499802, 0.0048651962557715, 
 0.0050127128002511, 0.0051612725160799, 0.0053100564972084, 0.0054596969588818, 
 0.0056093896172428, 0.0057597506501033, 0.0059099910441545, 0.0060607107305658, 
 0.0062111366063786, 0.0063618521574240, 0.0065121008215768, 0.0066624494508584, 
 0.0068121586443852, 0.0069617784418220, 0.0071105872131109, 0.0072591180166316, 
 0.0074066675911598, 0.0075537518541932, 0.0076996864990270, 0.0078449701516869, 
 0.0079889380326350, 0.0081320713345467, 0.0082737253639241, 0.0084143637466193, 
 0.0085533624195640, 0.0086911673164237, 0.0088271755337647, 0.0089618151955077, 
 0.0090945050711964, 0.0092256553649445, 0.0093547070160997, 0.0094820522061123, 
 0.0096071545237771, 0.0097303880319512, 0.0098512394307129, 0.0099700645750316, 
 0.0100863737196908, 0.0102005044288344, 0.0103119909363740, 0.0104211524387798, 
 0.0105275475539465, 0.0106314770396442, 0.0107325242824967, 0.0108309715361439, 
 0.0109264273200529, 0.0110191553236244, 0.0111087895421770, 0.0111955750458730, 
 0.0112791716273089, 0.0113598056872980, 0.0114371631151296, 0.0115114515968326, 
 0.0115823833953884, 0.0116501474410987, 0.0117144826248282, 0.0117755590845228, 
 0.0118331425699827, 0.0118873843943057, 0.0119380773738240, 0.0119853539682929, 
 0.0120290342444165, 0.0120692317839818, 0.0121057940639119, 0.0121388157671288, 
 0.0121681719164085, 0.0121939382785572, 0.0122160175334249, 0.0122344665180003, 
 0.0122492156558582, 0.0122603028439109, 0.0122676863112395, 0.0122713850057145, 
 0.0122713850158343, 0.0122676863146129, 0.0122603028459330, 0.0122492156573018, 
 0.0122344665191206, 0.0122160175343388, 0.0121939382793297, 0.0121681719170756, 
 0.0121388157677166, 0.0121057940644353, 0.0120692317844549, 0.0120290342448472, 
 0.0119853539686872, 0.0119380773741870, 0.0118873843946433, 0.0118331425702960, 
 0.0117755590848147, 0.0117144826251027, 0.0116501474413569, 0.0115823833956312, 
 0.0115114515970631, 0.0114371631153478, 0.0113598056875039, 0.0112791716275054, 
 0.0111955750460593, 0.0111087895423549, 0.0110191553237950, 0.0109264273202152, 
 0.0108309715362999, 0.0107325242826444, 0.0106314770397866, 0.0105275475540827, 
 0.0104211524389098, 0.0103119909364987, 0.0102005044289547, 0.0100863737198059, 
 0.0099700645751415, 0.0098512394308186, 0.0097303880320537, 0.0096071545238753, 
 0.0094820522062073, 0.0093547070161914, 0.0092256553650329, 0.0090945050712816, 
 0.0089618151955897, 0.0088271755338436, 0.0086911673165003, 0.0085533624196358, 
 0.0084143637466897, 0.0082737253639915, 0.0081320713346119, 0.0079889380326979, 
 0.0078449701517469, 0.0076996864990841, 0.0075537518542481, 0.0074066675912135, 
 0.0072591180166831, 0.0071105872131597, 0.0069617784418702, 0.0068121586444314, 
 0.0066624494509026, 0.0065121008216191, 0.0063618521574643, 0.0062111366064170, 
 0.0060607107306023, 0.0059099910441906, 0.0057597506501376, 0.0056093896172753, 
 0.0054596969589132, 0.0053100564972380, 0.0051612725161084, 0.0050127128002786, 
 0.0048651962557974, 0.0047180748500051, 0.0045721814549745, 0.0044268524517502, 
 0.0042829340152050, 0.0041397471825873, 0.0039981507620413, 0.0038574507011804, 
 0.0037185177663058, 0.0035806430815131, 0.0034447086912847, 0.0033099911745429, 
 0.0031773831698060, 0.0030461470016963, 0.0029171852151242, 0.0027897461841059, 
 0.0026647416694257, 0.0025414064113443, 0.0024206606937063, 0.0023017259533697, 
 0.0021855303026432, 0.0020712822192526, 0.0019599169480033, 0.0018506303661660, 
 0.0017443641539874, 0.0016403019619876, 0.0015393912078041, 0.0014408037047469, 
 0.0013454919086122, 0.0012526162020005, 0.0011631333778434, 0.0010761928130990, 
 0.0009927549337503, 0.0009119585571548, 0.0008347670328573, 0.0007603090893848, 
 0.0006895502807987, 0.0006216097483927, 0.0005574545147967, 0.0004961946768788, 
 0.0004387979596878, 0.0003843660183543, 0.0003338664588302, 0.0002863931929132, 
 0.0002429127798865, 0.0002025122569633, 0.0001661559916349, 0.0001329253585443, 
 0.0001037808939658, 0.0000778003287468, 0.0000559374174468, 0.0000372706105964, 
 0.0000227394678765, 0.0000114371212961, 0.0000042572517277, 0.0000004031877411};

static const double ow256[512] =
{0.0000000503988719, 0.0000005322021795, 0.0000014299748691, 0.0000028437482766, 
 0.0000046623743494, 0.0000070001551135, 0.0000097405151956, 0.0000130001396394, 
 0.0000166609291795, 0.0000208402566660, 0.0000254193675505, 0.0000305158256204, 
 0.0000360105307871, 0.0000420210325671, 0.0000484280301854, 0.0000553489530863, 
 0.0000626643819209, 0.0000704915617133, 0.0000787110085660, 0.0000874397385525, 
 0.0000965582431600, 0.0001061832754636, 0.0001161953345785, 0.0001267108825187, 
 0.0001376104537987, 0.0001490101949509, 0.0001607907009179, 0.0001730677806754, 
 0.0001857221128717, 0.0001988691484239, 0.0002123896718106, 0.0002263987564969, 
 0.0002407773141311, 0.0002556400221397, 0.0002708679401365, 0.0002865753315395, 
 0.0003026434243346, 0.0003191860504417, 0.0003360846263478, 0.0003534525353780, 
 0.0003711714024422, 0.0003893541455001, 0.0004078826176560, 0.0004268692550174, 
 0.0004461961585328, 0.0004659752662216, 0.0004860889464387, 0.0005066486231022, 
 0.0005275369514629, 0.0005488648255347, 0.0005705152068941, 0.0005925984440394, 
 0.0006149978242566, 0.0006378231351013, 0.0006609580089055, 0.0006845116570344, 
 0.0007083680761675, 0.0007326358863963, 0.0007571994680142, 0.0007821668349258, 
 0.0008074227702667, 0.0008330746670054, 0.0008590077303131, 0.0008853287176324, 
 0.0009119232753305, 0.0009388975108920, 0.0009661375310029, 0.0009937487789159, 
 0.0010216178407210, 0.0010498494813196, 0.0010783307852522, 0.0011071658251057, 
 0.0011362422028727, 0.0011656632850180, 0.0011953172099442, 0.0012253066243398, 
 0.0012555202219256, 0.0012860599161173, 0.0013168149748112, 0.0013478865648035, 
 0.0013791645469700, 0.0014107493282988, 0.0014425313813895, 0.0014746103403859, 
 0.0015068773082973, 0.0015394311335413, 0.0015721635681525, 0.0016051726621011, 
 0.0016383508349957, 0.0016717953257854, 0.0017053992401323, 0.0017392589935504, 
 0.0017732683961548, 0.0018075230277629, 0.0018419174212634, 0.0018765463086756, 
 0.0019113049638979, 0.0019462872592022, 0.0019813892276426, 0.0020167038699539, 
 0.0020521279964036, 0.0020877537245520, 0.0021234786598393, 0.0021593940251726, 
 0.0021953982390259, 0.0022315816183282, 0.0022678434123458, 0.0023042730208647, 
 0.0023407705415869, 0.0023774244461483, 0.0024141356982232, 0.0024509918304441, 
 0.0024878946898792, 0.0025249308594598, 0.0025620030869473, 0.0025991969950361, 
 0.0026364162493550, 0.0026737455019772, 0.0027110893534475, 0.0027485314749958, 
 0.0027859774189947, 0.0028235098657626, 0.0028610353362810, 0.0028986355100442, 
 0.0029362178932804, 0.0029738631549048, 0.0030114798028875, 0.0030491474859668, 
 0.0030867757302002, 0.0031244431547064, 0.0031620603198245, 0.0031997048057705, 
 0.0032372882231989, 0.0032748871042949, 0.0033124141259063, 0.0033499447632141, 
 0.0033873927749724, 0.0034248325705398, 0.0034621790061244, 0.0034995054165968, 
 0.0035367277709935, 0.0035739183211925, 0.0036109941642547, 0.0036480264607129, 
 0.0036849334506708, 0.0037217851951218, 0.0037585010920467, 0.0037951500948531, 
 0.0038316527740490, 0.0038680769675677, 0.0039043444329043, 0.0039405218847823, 
 0.0039765322819429, 0.0040124412083191, 0.0040481728379677, 0.0040837916166021, 
 0.0041192229474548, 0.0041545301307440, 0.0041896398125412, 0.0042246141404427, 
 0.0042593810168107, 0.0042940014296450, 0.0043284045508361, 0.0043626502019704, 
 0.0043966688374903, 0.0044305191058973, 0.0044641327569899, 0.0044975672596662, 
 0.0045307556716626, 0.0045637542759047, 0.0045964974504274, 0.0046290402859595, 
 0.0046613184929642, 0.0046933859639081, 0.0047251797535731, 0.0047567525502474, 
 0.0047880427646935, 0.0048191018752423, 0.0048498696600673, 0.0048803963819184, 
 0.0049106231975597, 0.0049405991486828, 0.0049702667815839, 0.0049996739115667, 
 0.0050287644851504, 0.0050575850860686, 0.0050860810715039, 0.0051142977885854, 
 0.0051421820153511, 0.0051697778574313, 0.0051970335236570, 0.0052239918734116, 
 0.0052506025559990, 0.0052769071799553, 0.0053028568444711, 0.0053284919027832, 
 0.0053537649131212, 0.0053787149691104, 0.0054032960969100, 0.0054275461263623, 
 0.0054514205601801, 0.0054749559603983, 0.0054981093146323, 0.0055209159132295, 
 0.0055433342367868, 0.0055653983002200, 0.0055870680849164, 0.0056083763267655, 
 0.0056292845154677, 0.0056498241044311, 0.0056699580989195, 0.0056897166665438, 
 0.0057090643351035, 0.0057280299832396, 0.0057465796679684, 0.0057647409759292, 
 0.0057824814997583, 0.0057998275312001, 0.0058167482046312, 0.0058332685141460, 
 0.0058493591416872, 0.0058650437810878, 0.0058802946673962, 0.0058951341917120, 
 0.0059095361474370, 0.0059235216205986, 0.0059370659679141, 0.0059501889681429, 
 0.0059628675459741, 0.0059751201708476, 0.0059869253397918, 0.0059983002110071, 
 0.0060092248579347, 0.0060197151257507, 0.0060297526680870, 0.0060393520154528, 
 0.0060484964051434, 0.0060571990514995, 0.0060654447786592, 0.0060732454834224, 
 0.0060805875796474, 0.0060874816453641, 0.0060939156867294, 0.0060998989619073, 
 0.0061054210716277, 0.0061104899532344, 0.0061150968039998, 0.0061192482396297, 
 0.0061229370556083, 0.0061261685453132, 0.0061289371038043, 0.0061312467015727, 
 0.0061330933342860, 0.0061344796490370, 0.0061354032424285, 0.0061358654334170, 
 0.0061358654536659, 0.0061354032491772, 0.0061344796530855, 0.0061330933371773, 
 0.0061312467038219, 0.0061289371056442, 0.0061261685468690, 0.0061229370569549, 
 0.0061192482408171, 0.0061150968050620, 0.0061104899541924, 0.0061054210725015, 
 0.0060998989627109, 0.0060939156874719, 0.0060874816460554, 0.0060805875802925, 
 0.0060732454840283, 0.0060654447792299, 0.0060571990520381, 0.0060484964056537, 
 0.0060393520159379, 0.0060297526685490, 0.0060197151261915, 0.0060092248583553, 
 0.0059983002114095, 0.0059869253401790, 0.0059751201712177, 0.0059628675463300, 
 0.0059501889684856, 0.0059370659682446, 0.0059235216209179, 0.0059095361477452, 
 0.0058951341920100, 0.0058802946676850, 0.0058650437813664, 0.0058493591419577, 
 0.0058332685144083, 0.0058167482048863, 0.0057998275314480, 0.0057824814999981, 
 0.0057647409761618, 0.0057465796681958, 0.0057280299834609, 0.0057090643353196, 
 0.0056897166667547, 0.0056699580991233, 0.0056498241046297, 0.0056292845156611, 
 0.0056083763269548, 0.0055870680851016, 0.0055653983004009, 0.0055433342369617, 
 0.0055209159134012, 0.0054981093148008, 0.0054749559605627, 0.0054514205603403, 
 0.0054275461265194, 0.0054032960970639, 0.0053787149692611, 0.0053537649132678, 
 0.0053284919029276, 0.0053028568446115, 0.0052769071800935, 0.0052506025561341, 
 0.0052239918735436, 0.0051970335237858, 0.0051697778575580, 0.0051421820154747, 
 0.0051142977887059, 0.0050860810716223, 0.0050575850861821, 0.0050287644852645, 
 0.0049996739116759, 0.0049702667816937, 0.0049405991487878, 0.0049106231976644, 
 0.0048803963820192, 0.0048498696601687, 0.0048191018753389, 0.0047880427647906, 
 0.0047567525503407, 0.0047251797536678, 0.0046933859639982, 0.0046613184930548, 
 0.0046290402860473, 0.0045964974505148, 0.0045637542759892, 0.0045307556717468, 
 0.0044975672597467, 0.0044641327570701, 0.0044305191059755, 0.0043966688375674, 
 0.0043626502020446, 0.0043284045509108, 0.0042940014297161, 0.0042593810168832, 
 0.0042246141405132, 0.0041896398126114, 0.0041545301308107, 0.0041192229475228, 
 0.0040837916166666, 0.0040481728380327, 0.0040124412083814, 0.0039765322820049, 
 0.0039405218848424, 0.0039043444329649, 0.0038680769676264, 0.0038316527741067, 
 0.0037951500949090, 0.0037585010921023, 0.0037217851951755, 0.0036849334507243, 
 0.0036480264607638, 0.0036109941643054, 0.0035739183212414, 0.0035367277710428, 
 0.0034995054166444, 0.0034621790061717, 0.0034248325705854, 0.0033873927750184, 
 0.0033499447632578, 0.0033124141259504, 0.0032748871043365, 0.0032372882232410, 
 0.0031997048058109, 0.0031620603198647, 0.0031244431547457, 0.0030867757302385, 
 0.0030491474860042, 0.0030114798029254, 0.0029738631549403, 0.0029362178933164, 
 0.0028986355100785, 0.0028610353363158, 0.0028235098657958, 0.0027859774190278, 
 0.0027485314750272, 0.0027110893534788, 0.0026737455020075, 0.0026364162493845, 
 0.0025991969950647, 0.0025620030869764, 0.0025249308594874, 0.0024878946899065, 
 0.0024509918304707, 0.0024141356982496, 0.0023774244461732, 0.0023407705416122, 
 0.0023042730208886, 0.0022678434123695, 0.0022315816183511, 0.0021953982390480, 
 0.0021593940251939, 0.0021234786598605, 0.0020877537245725, 0.0020521279964239, 
 0.0020167038699740, 0.0019813892276625, 0.0019462872592208, 0.0019113049639169, 
 0.0018765463086938, 0.0018419174212810, 0.0018075230277792, 0.0017732683961715, 
 0.0017392589935664, 0.0017053992401482, 0.0016717953258001, 0.0016383508350107, 
 0.0016051726621154, 0.0015721635681666, 0.0015394311335548, 0.0015068773083102, 
 0.0014746103403992, 0.0014425313814021, 0.0014107493283103, 0.0013791645469819, 
 0.0013478865648148, 0.0013168149748223, 0.0012860599161283, 0.0012555202219361, 
 0.0012253066243496, 0.0011953172099539, 0.0011656632850271, 0.0011362422028818, 
 0.0011071658251146, 0.0010783307852610, 0.0010498494813279, 0.0010216178407288, 
 0.0009937487789236, 0.0009661375310105, 0.0009388975108991, 0.0009119232753374, 
 0.0008853287176389, 0.0008590077303191, 0.0008330746670113, 0.0008074227702725, 
 0.0007821668349315, 0.0007571994680195, 0.0007326358864015, 0.0007083680761722, 
 0.0006845116570391, 0.0006609580089101, 0.0006378231351052, 0.0006149978242607, 
 0.0005925984440434, 0.0005705152068981, 0.0005488648255383, 0.0005275369514664, 
 0.0005066486231056, 0.0004860889464418, 0.0004659752662246, 0.0004461961585355, 
 0.0004268692550201, 0.0004078826176586, 0.0003893541455026, 0.0003711714024445, 
 0.0003534525353802, 0.0003360846263500, 0.0003191860504438, 0.0003026434243366, 
 0.0002865753315412, 0.0002708679401380, 0.0002556400221409, 0.0002407773141325, 
 0.0002263987564982, 0.0002123896718119, 0.0001988691484250, 0.0001857221128727, 
 0.0001730677806764, 0.0001607907009189, 0.0001490101949518, 0.0001376104537994, 
 0.0001267108825195, 0.0001161953345792, 0.0001061832754641, 0.0000965582431604, 
 0.0000874397385529, 0.0000787110085664, 0.0000704915617137, 0.0000626643819212, 
 0.0000553489530865, 0.0000484280301855, 0.0000420210325674, 0.0000360105307872, 
 0.0000305158256206, 0.0000254193675506, 0.0000208402566661, 0.0000166609291796, 
 0.0000130001396395, 0.0000097405151956, 0.0000070001551135, 0.0000046623743495, 
 0.0000028437482766, 0.0000014299748691, 0.0000005322021795, 0.0000000503988719};

static const double ow512[1024] =
{0.0000000062998716, 0.0000000665267011, 0.0000001787573194, 0.0000003555096312, 
 0.0000005829077118, 0.0000008752688415, 0.0000012180483504, 0.0000016258786125, 
 0.0000020840324286, 0.0000026072470207, 0.0000031807195185, 0.0000038192315249, 
 0.0000045079414932, 0.0000052616513873, 0.0000060654973566, 0.0000069342901200, 
 0.0000078531520481, 0.0000088368961772, 0.0000098706361046, 0.0000109691832139, 
 0.0000121176455666, 0.0000133308302185, 0.0000145938419643, 0.0000159214815954, 
 0.0000172988523436, 0.0000187407472402, 0.0000202322693094, 0.0000217882026071, 
 0.0000233936510798, 0.0000250633887770, 0.0000267825215486, 0.0000285658125301, 
 0.0000303983703544, 0.0000322949464230, 0.0000342406529570, 0.0000362502288676, 
 0.0000383087907177, 0.0000404310642169, 0.0000426021709856, 0.0000448368228561, 
 0.0000471201471914, 0.0000494668412967, 0.0000518620389420, 0.0000543204222765, 
 0.0000568271321242, 0.0000593968348657, 0.0000620146790120, 0.0000646953145760, 
 0.0000674238983794, 0.0000702150634768, 0.0000730539756169, 0.0000759552503150, 
 0.0000789040628550, 0.0000819150106401, 0.0000849732790913, 0.0000880934469343, 
 0.0000912607103246, 0.0000944896287478, 0.0000977654096903, 0.0001011025928398, 
 0.0001044863976047, 0.0001079313433219, 0.0001114226619110, 0.0001149748518099, 
 0.0001185731580342, 0.0001222320575768, 0.0001259368091352, 0.0001297018677145, 
 0.0001335125062757, 0.0001373831572966, 0.0001412991085836, 0.0001452747695494, 
 0.0001492954434257, 0.0001533755160246, 0.0001575003065831, 0.0001616841767795, 
 0.0001659124624336, 0.0001701995005604, 0.0001745306441382, 0.0001789202049904, 
 0.0001833535538303, 0.0001878449767629, 0.0001923798628127, 0.0001969724718410, 
 0.0002016082117565, 0.0002063013156562, 0.0002110372109065, 0.0002158301033190, 
 0.0002206654402907, 0.0002255573998286, 0.0002304914499333, 0.0002354817402902, 
 0.0002405137600734, 0.0002456016301333, 0.0002507308613888, 0.0002559155453400, 
 0.0002611412152218, 0.0002664219326724, 0.0002717432538113, 0.0002771192099067, 
 0.0002825353805303, 0.0002880057660717, 0.0002935159701243, 0.0002990799616920, 
 0.0003046833689573, 0.0003103401290341, 0.0003160358952602, 0.0003217845723576, 
 0.0003275718393853, 0.0003334115681715, 0.0003392894640614, 0.0003452193654918, 
 0.0003511870046589, 0.0003572061861081, 0.0003632626694510, 0.0003693702248476, 
 0.0003755146398890, 0.0003817096498524, 0.0003879410708697, 0.0003942226028487, 
 0.0004005400910204, 0.0004069071994310, 0.0004133098029753, 0.0004197615293463, 
 0.0004262482836621, 0.0004327836567789, 0.0004393535845950, 0.0004459716206432, 
 0.0004526237321632, 0.0004593234348808, 0.0004660567279326, 0.0004728370887566, 
 0.0004796505489436, 0.0004865105471640, 0.0004934031480173, 0.0005003417509294, 
 0.0005073124540631, 0.0005143286171242, 0.0005213763723921, 0.0005284690393772, 
 0.0005355927850296, 0.0005427608881924, 0.0005499595510369, 0.0005572020112695, 
 0.0005644745068324, 0.0005717902338269, 0.0005791354665174, 0.0005865233589327, 
 0.0005939402222065, 0.0006013991678316, 0.0006088865443579, 0.0006164154202802, 
 0.0006239721821118, 0.0006315698548864, 0.0006391948636267, 0.0006468601894477, 
 0.0006545522964227, 0.0006622841212942, 0.0006700421677293, 0.0006778393276386, 
 0.0006856621448273, 0.0006935234659241, 0.0007014098754079, 0.0007093341741757, 
 0.0007172829879203, 0.0007252690713578, 0.0007332790919336, 0.0007413257577338, 
 0.0007493957784933, 0.0007575018152248, 0.0007656306204870, 0.0007737948077760, 
 0.0007819811730068, 0.0007902022817212, 0.0007984449737218, 0.0008067217661550, 
 0.0008150195432433, 0.0008233507733023, 0.0008317023855038, 0.0008400867988966, 
 0.0008484909881291, 0.0008569273225517, 0.0008653828228176, 0.0008738698081487, 
 0.0008823753457217, 0.0008909117042066, 0.0008994659978311, 0.0009080504442815, 
 0.0009166522053579, 0.0009252834473406, 0.0009339313801220, 0.0009426081181553, 
 0.0009513009199448, 0.0009600218476946, 0.0009687582090367, 0.0009775220135127, 
 0.0009863006183963, 0.0009951059801498, 0.0010039255062019, 0.0010127710995234, 
 0.0010216302182107, 0.0010305147113307, 0.0010394120881589, 0.0010483341434489, 
 0.0010572684381624, 0.0010662267123360, 0.0010751965791227, 0.0010841897234365, 
 0.0010931938111275, 0.0011022204715858, 0.0011112574238615, 0.0011203162414188, 
 0.0011293846970105, 0.0011384743077792, 0.0011475729006754, 0.0011566919361269, 
 0.0011658192957807, 0.0011749663829544, 0.0011841211344866, 0.0011932948961954, 
 0.0012024756606043, 0.0012116747156435, 0.0012208801100113, 0.0012301030733634, 
 0.0012393317110646, 0.0012485771941130, 0.0012578276850234, 0.0012670942957559, 
 0.0012763652464622, 0.0012856515896837, 0.0012949416036937, 0.0013042462812357, 
 0.0013135539591860, 0.0013228755701192, 0.0013321995099890, 0.0013415366508298, 
 0.0013508754481524, 0.0013602267130786, 0.0013695789611493, 0.0013789429422079, 
 0.0013883072322996, 0.0013976825196231, 0.0014070574411964, 0.0014164426232115, 
 0.0014258267641266, 0.0014352204277685, 0.0014446123745021, 0.0014540131054267, 
 0.0014634114432785, 0.0014728178260760, 0.0014822211393860, 0.0014916317577944, 
 0.0015010386301556, 0.0015104520672720, 0.0015198610817419, 0.0015292759202373, 
 0.0015386856595556, 0.0015481004818889, 0.0015575095286841, 0.0015669229173127, 
 0.0015763298543229, 0.0015857403919217, 0.0015951438022011, 0.0016045500718706, 
 0.0016139485390090, 0.0016233491244893, 0.0016327412328229, 0.0016421347187100, 
 0.0016515190535327, 0.0016609040254904, 0.0016702791732694, 0.0016796542182400, 
 0.0016890187668287, 0.0016983824732490, 0.0017077350120975, 0.0017170859701091, 
 0.0017264250904787, 0.0017357618921414, 0.0017450861873176, 0.0017544074268202, 
 0.0017637154923213, 0.0017730197661962, 0.0017823101999859, 0.0017915961073177, 
 0.0018008675100187, 0.0018101336526552, 0.0018193846277578, 0.0018286296105215, 
 0.0018378587645942, 0.0018470811954937, 0.0018562871383912, 0.0018654856288283, 
 0.0018746669739055, 0.0018838401388841, 0.0018929955032023, 0.0019021419615408, 
 0.0019112699660730, 0.0019203883406069, 0.0019294876104522, 0.0019385765282469, 
 0.0019476456928308, 0.0019567037853831, 0.0019657414786691, 0.0019747673821188, 
 0.0019837722428090, 0.0019927645981390, 0.0020017352698863, 0.0020106927231299, 
 0.0020196278547337, 0.0020285490571804, 0.0020374473027966, 0.0020463309111918, 
 0.0020551909305326, 0.0020640356072792, 0.0020728560658170, 0.0020816604791816, 
 0.0020904400483464, 0.0020992028726561, 0.0021079402300406, 0.0021166601458820, 
 0.0021253539754358, 0.0021340296698573, 0.0021426786620870, 0.0021513088287943, 
 0.0021599116809617, 0.0021684950205125, 0.0021770504368337, 0.0021855856568370, 
 0.0021940923486674, 0.0022025781639765, 0.0022110348500157, 0.0022194699829228, 
 0.0022278753894018, 0.0022362585698280, 0.0022446114307018, 0.0022529413963921, 
 0.0022612404535330, 0.0022695159502426, 0.0022777599536256, 0.0022859797353081, 
 0.0022941674432055, 0.0023023302722063, 0.0023104604513644, 0.0023185650986026, 
 0.0023266365244383, 0.0023346817695915, 0.0023426932263692, 0.0023506778580612, 
 0.0023586281390800, 0.0023665509550580, 0.0023744388628329, 0.0023822986701506, 
 0.0023901230165907, 0.0023979186317891, 0.0024056782383785, 0.0024134084876646, 
 0.0024211021856383, 0.0024287659050609, 0.0024363925355837, 0.0024439885712065, 
 0.0024515469855428, 0.0024590741936209, 0.0024665632533123, 0.0024740205004650, 
 0.0024814390775008, 0.0024888252408787, 0.0024961722178643, 0.0025034861853212, 
 0.0025107604556465, 0.0025180011259070, 0.0025252015939132, 0.0025323678767394, 
 0.0025394934578847, 0.0025465842742355, 0.0025536338952582, 0.0025606481774583, 
 0.0025676207765394, 0.0025745574684341, 0.0025814519953549, 0.0025883100524742, 
 0.0025951254687760, 0.0026019038584868, 0.0026086391376278, 0.0026153368392965, 
 0.0026219909668045, 0.0026286069719433, 0.0026351789455701, 0.0026417122579911, 
 0.0026482010878637, 0.0026546507238335, 0.0026610554326018, 0.0026674204209835, 
 0.0026737400439661, 0.0026800194263678, 0.0026862530117037, 0.0026924458426251, 
 0.0026985924514092, 0.0027046977983786, 0.0027107565048086, 0.0027167734485301, 
 0.0027227433400419, 0.0027286709745293, 0.0027345511519358, 0.0027403885846486, 
 0.0027461781622812, 0.0027519245142614, 0.0027576226200908, 0.0027632770260957, 
 0.0027688828018752, 0.0027744444105049, 0.0027799570118927, 0.0027854249857195, 
 0.0027908435824098, 0.0027962170981062, 0.0028015408739492, 0.0028068191224081, 
 0.0028120472755407, 0.0028172294620008, 0.0028223612049586, 0.0028274465491235, 
 0.0028324811089666, 0.0028374688451202, 0.0028424054635417, 0.0028472948406658, 
 0.0028521327741184, 0.0028569230560023, 0.0028616615757984, 0.0028663520411557, 
 0.0028709904335794, 0.0028755803761515, 0.0028801179425726, 0.0028846066712382, 
 0.0028890427282098, 0.0028934295670850, 0.0028977634464528, 0.0029020477349963, 
 0.0029062787839930, 0.0029104598771064, 0.0029145874584542, 0.0029186647265760, 
 0.0029226882185828, 0.0029266610477842, 0.0029305798444333, 0.0029344476365126, 
 0.0029382611475590, 0.0029420233201288, 0.0029457309711839, 0.0029493869577601, 
 0.0029529881903814, 0.0029565374404773, 0.0029600317122428, 0.0029634736914280, 
 0.0029668604760411, 0.0029701946660440, 0.0029734734533893, 0.0029766993521699, 
 0.0029798696484008, 0.0029829867702224, 0.0029860480978312, 0.0029890559733387, 
 0.0029920078712319, 0.0029949060475170, 0.0029977480710819, 0.0030005361117581, 
 0.0030032678329324, 0.0030059453181898, 0.0030085663255241, 0.0030111328522086, 
 0.0030136427509304, 0.0030160979325872, 0.0030184963446578, 0.0030208398116011, 
 0.0030231263757753, 0.0030253577751408, 0.0030275321470168, 0.0030296511428146, 
 0.0030317129948925, 0.0030337192680568, 0.0030356682897817, 0.0030375615382204, 
 0.0030393974360335, 0.0030411773746724, 0.0030428998720523, 0.0030445662328784, 
 0.0030461750703845, 0.0030477276024884, 0.0030492225377991, 0.0030506610074081, 
 0.0030520418153568, 0.0030533660058756, 0.0030546324784877, 0.0030558421905265, 
 0.0030569941370438, 0.0030580891884508, 0.0030591264353690, 0.0030601066612555, 
 0.0030610290523421, 0.0030618943051089, 0.0030627017014304, 0.0030634518507903, 
 0.0030641441307299, 0.0030647790637204, 0.0030653561229957, 0.0030658757439969, 
 0.0030663374956626, 0.0030667417263938, 0.0030670881008312, 0.0030673768803136, 
 0.0030676078251071, 0.0030677811093294, 0.0030678965879504, 0.0030679543394163, 
 0.0030679543799252, 0.0030678966014542, 0.0030677811174322, 0.0030676078308938, 
 0.0030673768848132, 0.0030670881045127, 0.0030667417295092, 0.0030663374983619, 
 0.0030658757463780, 0.0030653561251268, 0.0030647790656484, 0.0030641441324888, 
 0.0030634518524081, 0.0030627017029292, 0.0030618943065025, 0.0030610290536456, 
 0.0030601066624789, 0.0030591264365224, 0.0030580891895420, 0.0030569941380780, 
 0.0030558421915086, 0.0030546324794247, 0.0030533660067705, 0.0030520418162136, 
 0.0030506610082288, 0.0030492225385877, 0.0030477276032459, 0.0030461750711139, 
 0.0030445662335817, 0.0030428998727325, 0.0030411773753295, 0.0030393974366695, 
 0.0030375615388364, 0.0030356682903795, 0.0030337192686365, 0.0030317129954551, 
 0.0030296511433622, 0.0030275321475493, 0.0030253577756591, 0.0030231263762796, 
 0.0030208398120932, 0.0030184963451369, 0.0030160979330542, 0.0030136427513873, 
 0.0030111328526544, 0.0030085663259608, 0.0030059453186165, 0.0030032678333479, 
 0.0030005361121646, 0.0029977480714813, 0.0029949060479083, 0.0029920078716141, 
 0.0029890559737138, 0.0029860480981982, 0.0029829867705823, 0.0029798696487536, 
 0.0029766993525166, 0.0029734734537299, 0.0029701946663776, 0.0029668604763685, 
 0.0029634736917504, 0.0029600317125601, 0.0029565374407885, 0.0029529881906875, 
 0.0029493869580601, 0.0029457309714799, 0.0029420233204187, 0.0029382611478447, 
 0.0029344476367933, 0.0029305798447099, 0.0029266610480567, 0.0029226882188502, 
 0.0029186647268403, 0.0029145874587144, 0.0029104598773626, 0.0029062787842461, 
 0.0029020477352453, 0.0028977634466977, 0.0028934295673268, 0.0028890427284486, 
 0.0028846066714729, 0.0028801179428042, 0.0028755803763809, 0.0028709904338058, 
 0.0028663520413781, 0.0028616615760177, 0.0028569230562194, 0.0028521327743315, 
 0.0028472948408768, 0.0028424054637506, 0.0028374688453250, 0.0028324811091693, 
 0.0028274465493241, 0.0028223612051572, 0.0028172294621963, 0.0028120472757341, 
 0.0028068191225984, 0.0028015408741375, 0.0027962170982914, 0.0027908435825939, 
 0.0027854249859005, 0.0027799570120726, 0.0027744444106818, 0.0027688828020500, 
 0.0027632770262685, 0.0027576226202624, 0.0027519245144299, 0.0027461781624477, 
 0.0027403885848140, 0.0027345511521001, 0.0027286709746906, 0.0027227433402002, 
 0.0027167734486882, 0.0027107565049637, 0.0027046977985326, 0.0026985924515611, 
 0.0026924458427760, 0.0026862530118525, 0.0026800194265164, 0.0026737400441117, 
 0.0026674204211271, 0.0026610554327434, 0.0026546507239740, 0.0026482010880030, 
 0.0026417122581294, 0.0026351789457064, 0.0026286069720775, 0.0026219909669385, 
 0.0026153368394295, 0.0026086391377596, 0.0026019038586166, 0.0025951254689048, 
 0.0025883100526001, 0.0025814519954806, 0.0025745574685587, 0.0025676207766620, 
 0.0025606481775798, 0.0025536338953795, 0.0025465842743549, 0.0025394934580030, 
 0.0025323678768557, 0.0025252015940294, 0.0025180011260247, 0.0025107604557569, 
 0.0025034861854332, 0.0024961722179752, 0.0024888252409913, 0.0024814390776078, 
 0.0024740205005727, 0.0024665632534199, 0.0024590741937293, 0.0024515469856447, 
 0.0024439885713092, 0.0024363925356862, 0.0024287659051650, 0.0024211021857378, 
 0.0024134084877648, 0.0024056782384768, 0.0023979186318899, 0.0023901230166852, 
 0.0023822986702458, 0.0023744388629279, 0.0023665509551538, 0.0023586281391729, 
 0.0023506778581549, 0.0023426932264618, 0.0023346817696857, 0.0023266365245263, 
 0.0023185650986922, 0.0023104604514529, 0.0023023302722964, 0.0022941674432902, 
 0.0022859797353944, 0.0022777599537109, 0.0022695159503286, 0.0022612404536146, 
 0.0022529413964753, 0.0022446114307839, 0.0022362585699108, 0.0022278753894802, 
 0.0022194699830028, 0.0022110348500955, 0.0022025781640561, 0.0021940923487435, 
 0.0021855856569138, 0.0021770504369095, 0.0021684950205907, 0.0021599116810364, 
 0.0021513088288680, 0.0021426786621622, 0.0021340296699315, 0.0021253539755065, 
 0.0021166601459535, 0.0021079402301127, 0.0020992028727248, 0.0020904400484158, 
 0.0020816604792508, 0.0020728560658861, 0.0020640356073448, 0.0020551909305981, 
 0.0020463309112572, 0.0020374473028626, 0.0020285490572438, 0.0020196278547962, 
 0.0020106927231939, 0.0020017352699493, 0.0019927645982002, 0.0019837722428702, 
 0.0019747673821790, 0.0019657414787299, 0.0019567037854422, 0.0019476456928890, 
 0.0019385765283050, 0.0019294876105117, 0.0019203883406638, 0.0019112699661291, 
 0.0019021419615967, 0.0018929955032589, 0.0018838401389381, 0.0018746669739595, 
 0.0018654856288822, 0.0018562871384457, 0.0018470811955457, 0.0018378587646461, 
 0.0018286296105740, 0.0018193846278102, 0.0018101336527051, 0.0018008675100693, 
 0.0017915961073681, 0.0017823102000362, 0.0017730197662441, 0.0017637154923698, 
 0.0017544074268686, 0.0017450861873652, 0.0017357618921873, 0.0017264250905252, 
 0.0017170859701547, 0.0017077350121438, 0.0016983824732929, 0.0016890187668725, 
 0.0016796542182852, 0.0016702791733137, 0.0016609040255331, 0.0016515190535760, 
 0.0016421347187531, 0.0016327412328652, 0.0016233491245308, 0.0016139485390503, 
 0.0016045500719111, 0.0015951438022422, 0.0015857403919612, 0.0015763298543623, 
 0.0015669229173528, 0.0015575095287233, 0.0015481004819259, 0.0015386856595932, 
 0.0015292759202762, 0.0015198610817799, 0.0015104520673085, 0.0015010386301913, 
 0.0014916317578314, 0.0014822211394229, 0.0014728178261113, 0.0014634114433131, 
 0.0014540131054625, 0.0014446123745371, 0.0014352204278027, 0.0014258267641600, 
 0.0014164426232448, 0.0014070574412296, 0.0013976825196548, 0.0013883072323313, 
 0.0013789429422401, 0.0013695789611807, 0.0013602267131093, 0.0013508754481836, 
 0.0013415366508609, 0.0013321995100200, 0.0013228755701488, 0.0013135539592154, 
 0.0013042462812651, 0.0012949416037223, 0.0012856515897115, 0.0012763652464899, 
 0.0012670942957835, 0.0012578276850516, 0.0012485771941398, 0.0012393317110920, 
 0.0012301030733907, 0.0012208801100378, 0.0012116747156693, 0.0012024756606299, 
 0.0011932948962210, 0.0011841211345121, 0.0011749663829791, 0.0011658192958054, 
 0.0011566919361514, 0.0011475729006999, 0.0011384743078024, 0.0011293846970335, 
 0.0011203162414424, 0.0011112574238844, 0.0011022204716085, 0.0010931938111502, 
 0.0010841897234591, 0.0010751965791446, 0.0010662267123573, 0.0010572684381841, 
 0.0010483341434699, 0.0010394120881798, 0.0010305147113509, 0.0010216302182309, 
 0.0010127710995435, 0.0010039255062219, 0.0009951059801691, 0.0009863006184156, 
 0.0009775220135319, 0.0009687582090558, 0.0009600218477125, 0.0009513009199626, 
 0.0009426081181736, 0.0009339313801396, 0.0009252834473576, 0.0009166522053754, 
 0.0009080504442989, 0.0008994659978479, 0.0008909117042228, 0.0008823753457378, 
 0.0008738698081641, 0.0008653828228325, 0.0008569273225676, 0.0008484909881444, 
 0.0008400867989118, 0.0008317023855184, 0.0008233507733173, 0.0008150195432577, 
 0.0008067217661694, 0.0007984449737356, 0.0007902022817349, 0.0007819811730204, 
 0.0007737948077896, 0.0007656306204995, 0.0007575018152382, 0.0007493957785061, 
 0.0007413257577471, 0.0007332790919458, 0.0007252690713700, 0.0007172829879324, 
 0.0007093341741877, 0.0007014098754194, 0.0006935234659355, 0.0006856621448386, 
 0.0006778393276504, 0.0006700421677400, 0.0006622841213053, 0.0006545522964338, 
 0.0006468601894588, 0.0006391948636367, 0.0006315698548969, 0.0006239721821222, 
 0.0006164154202905, 0.0006088865443677, 0.0006013991678414, 0.0005939402222162, 
 0.0005865233589423, 0.0005791354665266, 0.0005717902338360, 0.0005644745068414, 
 0.0005572020112784, 0.0005499595510454, 0.0005427608882008, 0.0005355927850380, 
 0.0005284690393855, 0.0005213763724000, 0.0005143286171324, 0.0005073124540712, 
 0.0005003417509375, 0.0004934031480249, 0.0004865105471716, 0.0004796505489511, 
 0.0004728370887640, 0.0004660567279397, 0.0004593234348881, 0.0004526237321701, 
 0.0004459716206504, 0.0004393535846010, 0.0004327836567853, 0.0004262482836684, 
 0.0004197615293526, 0.0004133098029812, 0.0004069071994372, 0.0004005400910262, 
 0.0003942226028544, 0.0003879410708754, 0.0003817096498580, 0.0003755146398942, 
 0.0003693702248532, 0.0003632626694562, 0.0003572061861132, 0.0003511870046636, 
 0.0003452193654968, 0.0003392894640660, 0.0003334115681762, 0.0003275718393899, 
 0.0003217845723624, 0.0003160358952647, 0.0003103401290386, 0.0003046833689614, 
 0.0002990799616963, 0.0002935159701283, 0.0002880057660757, 0.0002825353805342, 
 0.0002771192099107, 0.0002717432538149, 0.0002664219326762, 0.0002611412152253, 
 0.0002559155453438, 0.0002507308613922, 0.0002456016301364, 0.0002405137600767, 
 0.0002354817402932, 0.0002304914499364, 0.0002255573998316, 0.0002206654402936, 
 0.0002158301033217, 0.0002110372109091, 0.0002063013156591, 0.0002016082117591, 
 0.0001969724718438, 0.0001923798628152, 0.0001878449767654, 0.0001833535538330, 
 0.0001789202049926, 0.0001745306441406, 0.0001701995005627, 0.0001659124624359, 
 0.0001616841767816, 0.0001575003065849, 0.0001533755160267, 0.0001492954434275, 
 0.0001452747695514, 0.0001412991085855, 0.0001373831572983, 0.0001335125062774, 
 0.0001297018677163, 0.0001259368091366, 0.0001222320575784, 0.0001185731580356, 
 0.0001149748518112, 0.0001114226619123, 0.0001079313433232, 0.0001044863976059, 
 0.0001011025928409, 0.0000977654096915, 0.0000944896287490, 0.0000912607103257, 
 0.0000880934469353, 0.0000849732790923, 0.0000819150106411, 0.0000789040628558, 
 0.0000759552503158, 0.0000730539756179, 0.0000702150634777, 0.0000674238983801, 
 0.0000646953145768, 0.0000620146790127, 0.0000593968348664, 0.0000568271321249, 
 0.0000543204222772, 0.0000518620389426, 0.0000494668412973, 0.0000471201471921, 
 0.0000448368228567, 0.0000426021709861, 0.0000404310642174, 0.0000383087907180, 
 0.0000362502288677, 0.0000342406529574, 0.0000322949464233, 0.0000303983703548, 
 0.0000285658125304, 0.0000267825215489, 0.0000250633887773, 0.0000233936510801, 
 0.0000217882026074, 0.0000202322693097, 0.0000187407472404, 0.0000172988523438, 
 0.0000159214815955, 0.0000145938419644, 0.0000133308302186, 0.0000121176455667, 
 0.0000109691832141, 0.0000098706361047, 0.0000088368961773, 0.0000078531520482, 
 0.0000069342901201, 0.0000060654973567, 0.0000052616513873, 0.0000045079414933, 
 0.0000038192315250, 0.0000031807195185, 0.0000026072470207, 0.0000020840324286, 
 0.0000016258786125, 0.0000012180483504, 0.0000008752688415, 0.0000005829077118, 
 0.0000003555096313, 0.0000001787573194, 0.0000000665267011, 0.0000000062998716};

static const double ow1024[2048] =
{0.0000000007874844, 0.0000000083158823, 0.0000000223449917, 0.0000000444399885, 
 0.0000000728669303, 0.0000001094164017, 0.0000001522711704, 0.0000002032617448, 
 0.0000002605483274, 0.0000003259751238, 0.0000003976930737, 0.0000004775525746, 
 0.0000005636998746, 0.0000006579886128, 0.0000007585623403, 0.0000008672765373, 
 0.0000009822730712, 0.0000011054085119, 0.0000012348236144, 0.0000013723755939, 
 0.0000015162044443, 0.0000016681677442, 0.0000018264049576, 0.0000019927738345, 
 0.0000021654134692, 0.0000023461816487, 0.0000025332172120, 0.0000027283778833, 
 0.0000029298023358, 0.0000031393481516, 0.0000033551539074, 0.0000035790769824, 
 0.0000038092559118, 0.0000040475478207, 0.0000042920912510, 0.0000045447430298, 
 0.0000048036417463, 0.0000050706438910, 0.0000053438881370, 0.0000056252306052, 
 0.0000059128100833, 0.0000062084822926, 0.0000065103861654, 0.0000068203769942, 
 0.0000071365938840, 0.0000074608916730, 0.0000077914096636, 0.0000081300022142, 
 0.0000084748088497, 0.0000088276834261, 0.0000091867657130, 0.0000095539090414, 
 0.0000099272534484, 0.0000103086517185, 0.0000106962441772, 0.0000110918830415, 
 0.0000114937089469, 0.0000119035735225, 0.0000123196177336, 0.0000127436926016, 
 0.0000131739394424, 0.0000136122086489, 0.0000140566419083, 0.0000145090889654, 
 0.0000149676918980, 0.0000154342997844, 0.0000159070551114, 0.0000163878062717, 
 0.0000168746961811, 0.0000173695725286, 0.0000178705786767, 0.0000183795615920, 
 0.0000188946651038, 0.0000194177354367, 0.0000199469169054, 0.0000204840549758, 
 0.0000210272944656, 0.0000215784800629, 0.0000221357571084, 0.0000227009694939, 
 0.0000232722631005, 0.0000238514810075, 0.0000244367696540, 0.0000250299712874, 
 0.0000256292329250, 0.0000262363959645, 0.0000268496080182, 0.0000274707096172, 
 0.0000280978489874, 0.0000287328657747, 0.0000293739088365, 0.0000300228169173, 
 0.0000306777395231, 0.0000313405144790, 0.0000320092919587, 0.0000326859088492, 
 0.0000333685160104, 0.0000340589493752, 0.0000347553605053, 0.0000354595843619, 
 0.0000361697732286, 0.0000368877610766, 0.0000376117009288, 0.0000383434257493, 
 0.0000390810893179, 0.0000398265235749, 0.0000405778830748, 0.0000413369987158, 
 0.0000421020258454, 0.0000428747943033, 0.0000436534602468, 0.0000444398524404, 
 0.0000452321278689, 0.0000460321142032, 0.0000468379692748, 0.0000476515196442, 
 0.0000484709240065, 0.0000492980077942, 0.0000501309305833, 0.0000509715166629, 
 0.0000518179265077, 0.0000526719832440, 0.0000535318482643, 0.0000543993435162, 
 0.0000552726313257, 0.0000561535324454, 0.0000570402101521, 0.0000579344839867, 
 0.0000588345181954, 0.0000597421310889, 0.0000606554879006, 0.0000615764056947, 
 0.0000625030507095, 0.0000634372387448, 0.0000643771370619, 0.0000653245601803, 
 0.0000662776764005, 0.0000672382989439, 0.0000682045971699, 0.0000691783829853, 
 0.0000701578268236, 0.0000711447392606, 0.0000721372918228, 0.0000731372937379, 
 0.0000741429176421, 0.0000751559713987, 0.0000761746287714, 0.0000772006962408, 
 0.0000782323487171, 0.0000792713912816, 0.0000803160000074, 0.0000813679785606, 
 0.0000824255041942, 0.0000834903791425, 0.0000845607818559, 0.0000856385131199, 
 0.0000867217526004, 0.0000878122996168, 0.0000889083350682, 0.0000900116567917, 
 0.0000911204469360, 0.0000922365018396, 0.0000933580049188, 0.0000944867509966, 
 0.0000956209247742, 0.0000967623195422, 0.0000979091213041, 0.0000990631218020, 
 0.0001002225083593, 0.0001013890711526, 0.0001025609988422, 0.0001037400800235, 
 0.0001049245047104, 0.0001061160598997, 0.0001073129369784, 0.0001085169213274, 
 0.0001097262057234, 0.0001109425739156, 0.0001121642200874, 0.0001133929263399, 
 0.0001146268882805, 0.0001158678863456, 0.0001171141175844, 0.0001183673607522, 
 0.0001196258143564, 0.0001208912554557, 0.0001221618840329, 0.0001234394754327, 
 0.0001247222311318, 0.0001260119247443, 0.0001273067592578, 0.0001286085065396, 
 0.0001299153711046, 0.0001312291230581, 0.0001325479684601, 0.0001338736756359, 
 0.0001352044522080, 0.0001365420647060, 0.0001378847223327, 0.0001392341898059, 
 0.0001405886779247, 0.0001419499495781, 0.0001433162171807, 0.0001446892417763, 
 0.0001460672374107, 0.0001474519632673, 0.0001488416350403, 0.0001502380100367, 
 0.0001516393056151, 0.0001530472771906, 0.0001544601438045, 0.0001558796589620, 
 0.0001573040434052, 0.0001587350487133, 0.0001601708973462, 0.0001616133389411, 
 0.0001630605976918, 0.0001645144212789, 0.0001659730356471, 0.0001674381865030, 
 0.0001689081015600, 0.0001703845245348, 0.0001718656849266, 0.0001733533244467, 
 0.0001748456743966, 0.0001763444744648, 0.0001778479577737, 0.0001793578619743, 
 0.0001808724220246, 0.0001823933735228, 0.0001839189532800, 0.0001854508948244, 
 0.0001869874368391, 0.0001885303107661, 0.0001900777571757, 0.0001916315054086, 
 0.0001931897979406, 0.0001947543619947, 0.0001963234419679, 0.0001978987629501, 
 0.0001994785712766, 0.0002010645898895, 0.0002026550670793, 0.0002042517236218, 
 0.0002058528097816, 0.0002074600441531, 0.0002090716789909, 0.0002106894306924, 
 0.0002123115535180, 0.0002139397616543, 0.0002155723113838, 0.0002172109146660, 
 0.0002188538298230, 0.0002205027665704, 0.0002221559852876, 0.0002238151934309, 
 0.0002254786534540, 0.0002271480705375, 0.0002288217092251, 0.0002305012724080, 
 0.0002321850267372, 0.0002338746727969, 0.0002355684793628, 0.0002372681446973, 
 0.0002389719397171, 0.0002406815603476, 0.0002423952796616, 0.0002441147912333, 
 0.0002458383703098, 0.0002475677080962, 0.0002493010820312, 0.0002510401809357, 
 0.0002527832844562, 0.0002545320790152, 0.0002562848464826, 0.0002580432708666, 
 0.0002598056362782, 0.0002615736242952, 0.0002633455212870, 0.0002651230063862, 
 0.0002669043682347, 0.0002686912835060, 0.0002704820431329, 0.0002722783213117, 
 0.0002740784112836, 0.0002758839847534, 0.0002776933372862, 0.0002795081380799, 
 0.0002813266850404, 0.0002831506448438, 0.0002849783177526, 0.0002868113679063, 
 0.0002886480979410, 0.0002904901694440, 0.0002923358874410, 0.0002941869109518, 
 0.0002960415474085, 0.0002979014532497, 0.0002997649383281, 0.0003016336564866, 
 0.0003035059200164, 0.0003053833801471, 0.0003072643516271, 0.0003091504830573, 
 0.0003110400916575, 0.0003129348233873, 0.0003148329979539, 0.0003167362586583, 
 0.0003186429277138, 0.0003205546457487, 0.0003224697374972, 0.0003243898408991, 
 0.0003263132832262, 0.0003282416997160, 0.0003301734201933, 0.0003321100771788, 
 0.0003340500030667, 0.0003359948276456, 0.0003379428858953, 0.0003398958048577, 
 0.0003418519221144, 0.0003438128619456, 0.0003457769645510, 0.0003477458514341, 
 0.0003497178654292, 0.0003516946252483, 0.0003536744763765, 0.0003556590347193, 
 0.0003576466484285, 0.0003596389305897, 0.0003616342320356, 0.0003636341630177, 
 0.0003656370770676, 0.0003676445815856, 0.0003696550328192, 0.0003716700353034, 
 0.0003736879480166, 0.0003757103726153, 0.0003777356708232, 0.0003797654414040, 
 0.0003817980488449, 0.0003838350889993, 0.0003858749291346, 0.0003879191621812, 
 0.0003899661582000, 0.0003920175071863, 0.0003940715820097, 0.0003961299697141, 
 0.0003981910459964, 0.0004002563949327, 0.0004023243950638, 0.0004043966274853, 
 0.0004064714735947, 0.0004085505114937, 0.0004106321254533, 0.0004127178905667, 
 0.0004148061939941, 0.0004168986078046, 0.0004189935220651, 0.0004210925058062, 
 0.0004231939520159, 0.0004252994266737, 0.0004274073257030, 0.0004295192120181, 
 0.0004316334844949, 0.0004337517029671, 0.0004358722692791, 0.0004379967401705, 
 0.0004401235204682, 0.0004422541638051, 0.0004443870780052, 0.0004465238135799, 
 0.0004486627813687, 0.0004508055287460, 0.0004529504695816, 0.0004550991480992, 
 0.0004572499812148, 0.0004594045099871, 0.0004615611543939, 0.0004637214523150, 
 0.0004658838268051, 0.0004680498125528, 0.0004702178357037, 0.0004723894277398, 
 0.0004745630179156, 0.0004767401344929, 0.0004789192098474, 0.0004811017690086, 
 0.0004832862474910, 0.0004854741670755, 0.0004876639664300, 0.0004898571640746, 
 0.0004920522018456, 0.0004942505949886, 0.0004964507885233, 0.0004986542944072, 
 0.0005008595608591, 0.0005030680965336, 0.0005052783528645, 0.0005074918351911, 
 0.0005097069981753, 0.0005119253438276, 0.0005141453300551, 0.0005163684555246, 
 0.0005185931814033, 0.0005208210030011, 0.0005230503847607, 0.0005252828186219, 
 0.0005275167723163, 0.0005297537344009, 0.0005319921759128, 0.0005342335820120, 
 0.0005364764270546, 0.0005387221927903, 0.0005409693569112, 0.0005432193977432, 
 0.0005454707963271, 0.0005477250275524, 0.0005499805758254, 0.0005522389125846, 
 0.0005544985256154, 0.0005567608828933, 0.0005590244755989, 0.0005612907682297, 
 0.0005635582553762, 0.0005658283980463, 0.0005680996942535, 0.0005703736015037, 
 0.0005726486212478, 0.0005749262074766, 0.0005772048650949, 0.0005794860445633, 
 0.0005817682542546, 0.0005840529410879, 0.0005863386169185, 0.0005886267251094, 
 0.0005909157810140, 0.0005932072244277, 0.0005954995742142, 0.0005977942665885, 
 0.0006000898239418, 0.0006023876788933, 0.0006046863573759, 0.0006069872884026, 
 0.0006092890014609, 0.0006115929219434, 0.0006138975829085, 0.0006162044061167, 
 0.0006185119282092, 0.0006208215673018, 0.0006231318636344, 0.0006254442316655, 
 0.0006277572152477, 0.0006300722251681, 0.0006323878089063, 0.0006347053735666, 
 0.0006370234702709, 0.0006393435024266, 0.0006416640248113, 0.0006439864371250, 
 0.0006463092978145, 0.0006486340028576, 0.0006509591143875, 0.0006532860246470, 
 0.0006556132994669, 0.0006579423273461, 0.0006602716778268, 0.0006626027356486, 
 0.0006649340740807, 0.0006672670740920, 0.0006696003126926, 0.0006719351670671, 
 0.0006742702179808, 0.0006766068388229, 0.0006789436141269, 0.0006812819134734, 
 0.0006836203251788, 0.0006859602150040, 0.0006883001750620, 0.0006906415672807, 
 0.0006929829875827, 0.0006953257940523, 0.0006976685864359, 0.0007000127189606, 
 0.0007023567952107, 0.0007047021655448, 0.0007070474373993, 0.0007093939572504, 
 0.0007117403364014, 0.0007140879174348, 0.0007164353155318, 0.0007187838693719, 
 0.0007211321980280, 0.0007234816362617, 0.0007258308070543, 0.0007281810412373, 
 0.0007305309657114, 0.0007328819073677, 0.0007352324970405, 0.0007375840576675, 
 0.0007399352240314, 0.0007422873151041, 0.0007446389696293, 0.0007469915026031, 
 0.0007493435567419, 0.0007516964430531, 0.0007540488082424, 0.0007564019593165, 
 0.0007587545469819, 0.0007611078742335, 0.0007634605957915, 0.0007658140106283, 
 0.0007681667774913, 0.0007705201913179, 0.0007728729148966, 0.0007752262391179, 
 0.0007775788308235, 0.0007799319768471, 0.0007822843480968, 0.0007846372273377, 
 0.0007869892895574, 0.0007893418134393, 0.0007916934780660, 0.0007940455580274, 
 0.0007963967365133, 0.0007987482840087, 0.0008010988878232, 0.0008034498143278, 
 0.0008057997549629, 0.0008081499719745, 0.0008104991609478, 0.0008128485799912, 
 0.0008151969288484, 0.0008175454614774, 0.0008198928817953, 0.0008222404395987, 
 0.0008245868429884, 0.0008269333375911, 0.0008292786357033, 0.0008316239787705, 
 0.0008339680832973, 0.0008363121865361, 0.0008386550092147, 0.0008409977843798, 
 0.0008433392369951, 0.0008456805958914, 0.0008480205902802, 0.0008503604447658, 
 0.0008526988928200, 0.0008550371548098, 0.0008573739684786, 0.0008597105499471, 
 0.0008620456412421, 0.0008643804542265, 0.0008667137352257, 0.0008690466918305, 
 0.0008713780746773, 0.0008737090870768, 0.0008760384839874, 0.0008783674644288, 
 0.0008806947876938, 0.0008830216485007, 0.0008853468104902, 0.0008876714640667, 
 0.0008899943772298, 0.0008923167360625, 0.0008946373129351, 0.0008969572895964, 
 0.0008992754428011, 0.0009015929499548, 0.0009039085922066, 0.0009062235426068, 
 0.0009085365867140, 0.0009108488932137, 0.0009131592520839, 0.0009154688276340, 
 0.0009177764142748, 0.0009200831719290, 0.0009223878994525, 0.0009246917523724, 
 0.0009269935339983, 0.0009292943954517, 0.0009315931445112, 0.0009338909278819, 
 0.0009361865578210, 0.0009384811766048, 0.0009407736009855, 0.0009430649688018, 
 0.0009453541013066, 0.0009476421318942, 0.0009499278863312, 0.0009522124935546, 
 0.0009544947838584, 0.0009567758817119, 0.0009590546219470, 0.0009613321245565, 
 0.0009636072289225, 0.0009658810505491, 0.0009681524333807, 0.0009704224884249, 
 0.0009726900641979, 0.0009749562672017, 0.0009772199505350, 0.0009794822161838, 
 0.0009817419218440, 0.0009840001649735, 0.0009862558078756, 0.0009885099434722, 
 0.0009907614386845, 0.0009930113818892, 0.0009952586446352, 0.0009975043107464, 
 0.0009997472564125, 0.0010019885608900, 0.0010042271050210, 0.0010064639634885, 
 0.0010086980217973, 0.0010109303500471, 0.0010131598384145, 0.0010153875524076, 
 0.0010176123868878, 0.0010198354027595, 0.0010220554995807, 0.0010242737336436, 
 0.0010264890092127, 0.0010287023779579, 0.0010309127488646, 0.0010331211689695, 
 0.0010353265519852, 0.0010375299403107, 0.0010397302523974, 0.0010419285259948, 
 0.0010441236843049, 0.0010463167604170, 0.0010485066822959, 0.0010506944783633, 
 0.0010528790813548, 0.0010550615150150, 0.0010572407168626, 0.0010594177059553, 
 0.0010615914246057, 0.0010637628871762, 0.0010659310407828, 0.0010680968950846, 
 0.0010702594020098, 0.0010724195665066, 0.0010745763453268, 0.0010767307386969, 
 0.0010788817082030, 0.0010810302493412, 0.0010831753285441, 0.0010853179365664, 
 0.0010874570446964, 0.0010895936389432, 0.0010917266954574, 0.0010938571954937, 
 0.0010959841200779, 0.0010981084456965, 0.0011002291582653, 0.0011023472294967, 
 0.0011044616501996, 0.0011065733873035, 0.0011086814365267, 0.0011107867600083, 
 0.0011128883583780, 0.0011149871889747, 0.0011170822573605, 0.0011191745160644, 
 0.0011212629755802, 0.0011233485836225, 0.0011254303556334, 0.0011275092345022, 
 0.0011295842406224, 0.0011316563120518, 0.0011337244741521, 0.0011357896601406, 
 0.0011378509003506, 0.0011399091231481, 0.0011419633638550, 0.0011440145459807, 
 0.0011460617098382, 0.0011481057740691, 0.0011501457839947, 0.0011521826533831, 
 0.0011542154325658, 0.0011562450304278, 0.0011582705023276, 0.0011602927522610, 
 0.0011623108406138, 0.0011643256664837, 0.0011663362953038, 0.0011683436212637, 
 0.0011703467148442, 0.0011723464653224, 0.0011743419482420, 0.0011763340479592, 
 0.0011783218450832, 0.0011803062190400, 0.0011822862555229, 0.0011842628290193, 
 0.0011862350303068, 0.0011882037289278, 0.0011901680207616, 0.0011921287703977, 
 0.0011940850788167, 0.0011960378056491, 0.0011979860569956, 0.0011999306875126, 
 0.0012018708084266, 0.0012038072694200, 0.0012057391868543, 0.0012076674054245, 
 0.0012095910466324, 0.0012115109501888, 0.0012134262427459, 0.0012153377590113, 
 0.0012172446307965, 0.0012191476878090, 0.0012210460670288, 0.0012229405931453, 
 0.0012248304083160, 0.0012267163322154, 0.0012285975121855, 0.0012304747628695, 
 0.0012323472368018, 0.0012342157435989, 0.0012360794409966, 0.0012379391335632, 
 0.0012397939842473, 0.0012416447925743, 0.0012434907267102, 0.0012453325811209, 
 0.0012471695291998, 0.0012490023603544, 0.0012508302532158, 0.0012526539921159, 
 0.0012544727609293, 0.0012562873389173, 0.0012580969152066, 0.0012599022639708, 
 0.0012617025795961, 0.0012634986311709, 0.0012652896183507, 0.0012670763051223, 
 0.0012688578964163, 0.0012706351511218, 0.0012724072794536, 0.0012741750351856, 
 0.0012759376338255, 0.0012776958240345, 0.0012794488266216, 0.0012811973851185, 
 0.0012829407256414, 0.0012846795865995, 0.0012864131994241, 0.0012881422973804, 
 0.0012898661172254, 0.0012915853870869, 0.0012932993490510, 0.0012950087260936, 
 0.0012967127656370, 0.0012984121855082, 0.0013001062384760, 0.0013017956371978, 
 0.0013034796397989, 0.0013051589537724, 0.0013068328426049, 0.0013085020086103, 
 0.0013101657206423, 0.0013118246758412, 0.0013134781484365, 0.0013151268303753, 
 0.0013167700012700, 0.0013184083478821, 0.0013200411552125, 0.0013216691048194, 
 0.0013232914871006, 0.0013249089784157, 0.0013265208745685, 0.0013281278466994, 
 0.0013297291960234, 0.0013313255884737, 0.0013329163306823, 0.0013345020833519, 
 0.0013360821585431, 0.0013376572117359, 0.0013392265604218, 0.0013407908548415, 
 0.0013423494179268, 0.0013439028946837, 0.0013454506134903, 0.0013469932141022, 
 0.0013485300303481, 0.0013500616967408, 0.0013515875525682, 0.0013531082270796, 
 0.0013546230650301, 0.0013561326904126, 0.0013576364534548, 0.0013591349728765, 
 0.0013606276043836, 0.0013621149614309, 0.0013635964052086, 0.0013650725438872, 
 0.0013665427441487, 0.0013680076088869, 0.0013694665102829, 0.0013709200459349, 
 0.0013723675935263, 0.0013738097453704, 0.0013752458846626, 0.0013766765984064, 
 0.0013781012753166, 0.0013795204970992, 0.0013809336579924, 0.0013823413343858, 
 0.0013837429260459, 0.0013851390040560, 0.0013865289737177, 0.0013879134007862, 
 0.0013892916961054, 0.0013906644201136, 0.0013920309892032, 0.0013933919584733, 
 0.0013947467498686, 0.0013960959131660, 0.0013974388758649, 0.0013987761823972, 
 0.0014001072658262, 0.0014014326652484, 0.0014027518192977, 0.0014040652617117, 
 0.0014053724367043, 0.0014066738726694, 0.0014079690193900, 0.0014092583999035, 
 0.0014105414695868, 0.0014118187461158, 0.0014130896904521, 0.0014143548149030, 
 0.0014156135860362, 0.0014168665107913, 0.0014181130613282, 0.0014193537392082, 
 0.0014205880222129, 0.0014218164065215, 0.0014230383755179, 0.0014242544200011, 
 0.0014254640289825, 0.0014266676878695, 0.0014278648912891, 0.0014290561192565, 
 0.0014302408720370, 0.0014314196242501, 0.0014325918817838, 0.0014337581138548, 
 0.0014349178320027, 0.0014360715000390, 0.0014372186351354, 0.0014383596956943, 
 0.0014394942045465, 0.0014406226146814, 0.0014417444545729, 0.0014428601717928, 
 0.0014439693004835, 0.0014450722827957, 0.0014461686585248, 0.0014472588643948, 
 0.0014483424458808, 0.0014494198342778, 0.0014504905807212, 0.0014515551110737, 
 0.0014526129821581, 0.0014536646144016, 0.0014547095702970, 0.0014557482648295, 
 0.0014567802661902, 0.0014578059839201, 0.0014588249918888, 0.0014598376941896, 
 0.0014608436703982, 0.0014618433191576, 0.0014628362257286, 0.0014638227832999, 
 0.0014648025828486, 0.0014657760121053, 0.0014667426677391, 0.0014677029320214, 
 0.0014686564073451, 0.0014696034705144, 0.0014705437296259, 0.0014714775560175, 
 0.0014724045635145, 0.0014733251179843, 0.0014742388389628, 0.0014751460868429, 
 0.0014760464868996, 0.0014769403940471, 0.0014778274392799, 0.0014787079720306, 
 0.0014795816290390, 0.0014804487542567, 0.0014813089901467, 0.0014821626751735, 
 0.0014830094575548, 0.0014838496702661, 0.0014846829672556, 0.0014855096760058, 
 0.0014863294562279, 0.0014871426299095, 0.0014879488624977, 0.0014887484704818, 
 0.0014895411250796, 0.0014903271372783, 0.0014911061840408, 0.0014918785708499, 
 0.0014926439804433, 0.0014934027127995, 0.0014941544564048, 0.0014948995057279, 
 0.0014956375550415, 0.0014963688933005, 0.0014970932205314, 0.0014978108201763, 
 0.0014985213980526, 0.0014992252320860, 0.0014999220338528, 0.0015006120757587, 
 0.0015012950751797, 0.0015019712990012, 0.0015026404703592, 0.0015033028506191, 
 0.0015039581687192, 0.0015046066804991, 0.0015052481206666, 0.0015058827395330, 
 0.0015065102776174, 0.0015071309796992, 0.0015077445920717, 0.0015083513539806, 
 0.0015089510175372, 0.0015095438164533, 0.0015101295086145, 0.0015107083221976, 
 0.0015112800209116, 0.0015118448273944, 0.0015124025111357, 0.0015129532892319, 
 0.0015134969370013, 0.0015140336659998, 0.0015145632573287, 0.0015150859169988, 
 0.0015156014319472, 0.0015161100026372, 0.0015166114217940, 0.0015171058843334, 
 0.0015175931888196, 0.0015180735246184, 0.0015185466960856, 0.0015190128870345, 
 0.0015194719076809, 0.0015199239362438, 0.0015203687887569, 0.0015208066379151, 
 0.0015212373055753, 0.0015216609588464, 0.0015220774254070, 0.0015224868668415, 
 0.0015228891166541, 0.0015232843308372, 0.0015236723487234, 0.0015240533207755, 
 0.0015244270921595, 0.0015247938077406, 0.0015251533185134, 0.0015255057638162, 
 0.0015258510004774, 0.0015261891622343, 0.0015265201117478, 0.0015268439772275, 
 0.0015271606271710, 0.0015274701841819, 0.0015277725225923, 0.0015280677594779, 
 0.0015283557750142, 0.0015286366806625, 0.0015289103624348, 0.0015291769262690, 
 0.0015294362640197, 0.0015296884760049, 0.0015299334599191, 0.0015301713105589, 
 0.0015304019314655, 0.0015306254118068, 0.0015308416609648, 0.0015310507625920, 
 0.0015312526319194, 0.0015314473469611, 0.0015316348287922, 0.0015318151499157, 
 0.0015319882372597, 0.0015321541576766, 0.0015323128439387, 0.0015324643573990, 
 0.0015326086366863, 0.0015327457374865, 0.0015328756042711, 0.0015329982872417, 
 0.0015331137367314, 0.0015332219972508, 0.0015333230249784, 0.0015334168589568, 
 0.0015335034612354, 0.0015335828651268, 0.0015336550385193, 0.0015337200092899, 
 0.0015337777512128, 0.0015338282863447, 0.0015338715942592, 0.0015339076915832, 
 0.0015339365637228, 0.0015339582208192, 0.0015339726521951, 0.0015339798444893, 
 0.0015339799255174, 0.0015339726792043, 0.0015339582370247, 0.0015339365752979, 
 0.0015339077005868, 0.0015338716016246, 0.0015338282925767, 0.0015337777566137, 
 0.0015337200140545, 0.0015336550427823, 0.0015335828689844, 0.0015335034647574, 
 0.0015334168621969, 0.0015333230279784, 0.0015332220000448, 0.0015331137393450, 
 0.0015329982896959, 0.0015328756065848, 0.0015327457396744, 0.0015326086387627, 
 0.0015324643593747, 0.0015323128458210, 0.0015321541594754, 0.0015319882389816, 
 0.0015318151515673, 0.0015316348303788, 0.0015314473484878, 0.0015312526333904, 
 0.0015310507640113, 0.0015308416623350, 0.0015306254131320, 0.0015304019327484, 
 0.0015301713118024, 0.0015299334611252, 0.0015296884771761, 0.0015294362651577, 
 0.0015291769273750, 0.0015289103635110, 0.0015286366817114, 0.0015283557760358, 
 0.0015280677604741, 0.0015277725235637, 0.0015274701851304, 0.0015271606280976, 
 0.0015268439781319, 0.0015265201126322, 0.0015261891630996, 0.0015258510013243, 
 0.0015255057646455, 0.0015251533193258, 0.0015247938085370, 0.0015244270929402, 
 0.0015240533215412, 0.0015236723494735, 0.0015232843315737, 0.0015228891173770, 
 0.0015224868675517, 0.0015220774261056, 0.0015216609595320, 0.0015212373062492, 
 0.0015208066385779, 0.0015203687894078, 0.0015199239368842, 0.0015194719083111, 
 0.0015190128876558, 0.0015185466966963, 0.0015180735252207, 0.0015175931894120, 
 0.0015171058849171, 0.0015166114223691, 0.0015161100032040, 0.0015156014325060, 
 0.0015150859175499, 0.0015145632578721, 0.0015140336665352, 0.0015134969375301, 
 0.0015129532897530, 0.0015124025116500, 0.0015118448279020, 0.0015112800214126, 
 0.0015107083226924, 0.0015101295091030, 0.0015095438169353, 0.0015089510180131, 
 0.0015083513544508, 0.0015077445925362, 0.0015071309801583, 0.0015065102780712, 
 0.0015058827399816, 0.0015052481211100, 0.0015046066809363, 0.0015039581691527, 
 0.0015033028510466, 0.0015026404707832, 0.0015019712994195, 0.0015012950755946, 
 0.0015006120761693, 0.0014999220342578, 0.0014992252324868, 0.0014985213984493, 
 0.0014978108205690, 0.0014970932209190, 0.0014963688936842, 0.0014956375554212, 
 0.0014948995061051, 0.0014941544567783, 0.0014934027131683, 0.0014926439808085, 
 0.0014918785712117, 0.0014911061843992, 0.0014903271376333, 0.0014895411254303, 
 0.0014887484708293, 0.0014879488628421, 0.0014871426302508, 0.0014863294565661, 
 0.0014855096763410, 0.0014846829675879, 0.0014838496705953, 0.0014830094578812, 
 0.0014821626754972, 0.0014813089904674, 0.0014804487545749, 0.0014795816293545, 
 0.0014787079723425, 0.0014778274395892, 0.0014769403943547, 0.0014760464872039, 
 0.0014751460871446, 0.0014742388392622, 0.0014733251182812, 0.0014724045638091, 
 0.0014714775563089, 0.0014705437299158, 0.0014696034708020, 0.0014686564076297, 
 0.0014677029323038, 0.0014667426680202, 0.0014657760123835, 0.0014648025831247, 
 0.0014638227835739, 0.0014628362259998, 0.0014618433194268, 0.0014608436706653, 
 0.0014598376944548, 0.0014588249921521, 0.0014578059841815, 0.0014567802664497, 
 0.0014557482650872, 0.0014547095705529, 0.0014536646146557, 0.0014526129824103, 
 0.0014515551113234, 0.0014504905809692, 0.0014494198345241, 0.0014483424461254, 
 0.0014472588646377, 0.0014461686587653, 0.0014450722830346, 0.0014439693007215, 
 0.0014428601720286, 0.0014417444548072, 0.0014406226149142, 0.0014394942047776, 
 0.0014383596959240, 0.0014372186353629, 0.0014360715002650, 0.0014349178322285, 
 0.0014337581140779, 0.0014325918820054, 0.0014314196244705, 0.0014302408722559, 
 0.0014290561194741, 0.0014278648915040, 0.0014266676880830, 0.0014254640291948, 
 0.0014242544202133, 0.0014230383757287, 0.0014218164067299, 0.0014205880224200, 
 0.0014193537394153, 0.0014181130615328, 0.0014168665109946, 0.0014156135862384, 
 0.0014143548151040, 0.0014130896906508, 0.0014118187463144, 0.0014105414697841, 
 0.0014092584000988, 0.0014079690195850, 0.0014066738728635, 0.0014053724368960, 
 0.0014040652619036, 0.0014027518194872, 0.0014014326654370, 0.0014001072660136, 
 0.0013987761825836, 0.0013974388760502, 0.0013960959133493, 0.0013947467500519, 
 0.0013933919586557, 0.0013920309893833, 0.0013906644202939, 0.0013892916962836, 
 0.0013879134009634, 0.0013865289738940, 0.0013851390042314, 0.0013837429262202, 
 0.0013823413345593, 0.0013809336581649, 0.0013795204972707, 0.0013781012754862, 
 0.0013766765985751, 0.0013752458848304, 0.0013738097455375, 0.0013723675936934, 
 0.0013709200461002, 0.0013694665104483, 0.0013680076090504, 0.0013665427443113, 
 0.0013650725440491, 0.0013635964053697, 0.0013621149615911, 0.0013606276045429, 
 0.0013591349730351, 0.0013576364536125, 0.0013561326905687, 0.0013546230651853, 
 0.0013531082272341, 0.0013515875527219, 0.0013500616968937, 0.0013485300305002, 
 0.0013469932142536, 0.0013454506136409, 0.0013439028948337, 0.0013423494180751, 
 0.0013407908549900, 0.0013392265605686, 0.0013376572118820, 0.0013360821586885, 
 0.0013345020834967, 0.0013329163308254, 0.0013313255886170, 0.0013297291961660, 
 0.0013281278468405, 0.0013265208747089, 0.0013249089785564, 0.0013232914872406, 
 0.0013216691049578, 0.0013200411553503, 0.0013184083480192, 0.0013167700014065, 
 0.0013151268305112, 0.0013134781485717, 0.0013118246759759, 0.0013101657207763, 
 0.0013085020087437, 0.0013068328427368, 0.0013051589539036, 0.0013034796399296, 
 0.0013017956373278, 0.0013001062386056, 0.0012984121856372, 0.0012967127657653, 
 0.0012950087262213, 0.0012932993491782, 0.0012915853872128, 0.0012898661173505, 
 0.0012881422975059, 0.0012864131995481, 0.0012846795867232, 0.0012829407257644, 
 0.0012811973852411, 0.0012794488267427, 0.0012776958241558, 0.0012759376339455, 
 0.0012741750353052, 0.0012724072795727, 0.0012706351512403, 0.0012688578965342, 
 0.0012670763052398, 0.0012652896184647, 0.0012634986312896, 0.0012617025797113, 
 0.0012599022640828, 0.0012580969153216, 0.0012562873390311, 0.0012544727610453, 
 0.0012526539922288, 0.0012508302533253, 0.0012490023604684, 0.0012471695293105, 
 0.0012453325812290, 0.0012434907268206, 0.0012416447926837, 0.0012397939843587, 
 0.0012379391336715, 0.0012360794411017, 0.0012342157437083, 0.0012323472369087, 
 0.0012304747629727, 0.0012285975122909, 0.0012267163323204, 0.0012248304084231, 
 0.0012229405932494, 0.0012210460671298, 0.0012191476879142, 0.0012172446308986, 
 0.0012153377591104, 0.0012134262428472, 0.0012115109502897, 0.0012095910467354, 
 0.0012076674055246, 0.0012057391869514, 0.0012038072695212, 0.0012018708085248, 
 0.0011999306876085, 0.0011979860570936, 0.0011960378057461, 0.0011940850789157, 
 0.0011921287704940, 0.0011901680208573, 0.0011882037290257, 0.0011862350304013, 
 0.0011842628291115, 0.0011822862556190, 0.0011803062191345, 0.0011783218451755, 
 0.0011763340480529, 0.0011743419483353, 0.0011723464654172, 0.0011703467149362, 
 0.0011683436213536, 0.0011663362953968, 0.0011643256665746, 0.0011623108407026, 
 0.0011602927523512, 0.0011582705024174, 0.0011562450305190, 0.0011542154326544, 
 0.0011521826534691, 0.0011501457840837, 0.0011481057741555, 0.0011460617099231, 
 0.0011440145460676, 0.0011419633639415, 0.0011399091232354, 0.0011378509004364, 
 0.0011357896602239, 0.0011337244742383, 0.0011316563121355, 0.0011295842407037, 
 0.0011275092345853, 0.0011254303557161, 0.0011233485837071, 0.0011212629756623, 
 0.0011191745161441, 0.0011170822574430, 0.0011149871890559, 0.0011128883584556, 
 0.0011107867600878, 0.0011086814366058, 0.0011065733873845, 0.0011044616502781, 
 0.0011023472295740, 0.0011002291583454, 0.0010981084457742, 0.0010959841201532, 
 0.0010938571955708, 0.0010917266955342, 0.0010895936390207, 0.0010874570447726, 
 0.0010853179366412, 0.0010831753286198, 0.0010810302494156, 0.0010788817082761, 
 0.0010767307387717, 0.0010745763454003, 0.0010724195665818, 0.0010702594020826, 
 0.0010680968951564, 0.0010659310408561, 0.0010637628872483, 0.0010615914246756, 
 0.0010594177060278, 0.0010572407169329, 0.0010550615150871, 0.0010528790814245, 
 0.0010506944784329, 0.0010485066823671, 0.0010463167604860, 0.0010441236843717, 
 0.0010419285260643, 0.0010397302524647, 0.0010375299403806, 0.0010353265520529, 
 0.0010331211690361, 0.0010309127489328, 0.0010287023780249, 0.0010264890092776, 
 0.0010242737337101, 0.0010220554996460, 0.0010198354028264, 0.0010176123869535, 
 0.0010153875524714, 0.0010131598384797, 0.0010109303501112, 0.0010086980218603, 
 0.0010064639635529, 0.0010042271050835, 0.0010019885609541, 0.0009997472564746, 
 0.0009975043108082, 0.0009952586446976, 0.0009930113819506, 0.0009907614387440, 
 0.0009885099435340, 0.0009862558079354, 0.0009840001650358, 0.0009817419219042, 
 0.0009794822162431, 0.0009772199505948, 0.0009749562672605, 0.0009726900642557, 
 0.0009704224884849, 0.0009681524334388, 0.0009658810506087, 0.0009636072289802, 
 0.0009613321246141, 0.0009590546220051, 0.0009567758817690, 0.0009544947839136, 
 0.0009522124936120, 0.0009499278863868, 0.0009476421319512, 0.0009453541013626, 
 0.0009430649688569, 0.0009407736010411, 0.0009384811766602, 0.0009361865578738, 
 0.0009338909279369, 0.0009315931445652, 0.0009292943955070, 0.0009269935340519, 
 0.0009246917524251, 0.0009223878995065, 0.0009200831719821, 0.0009177764143260, 
 0.0009154688276867, 0.0009131592521363, 0.0009108488932645, 0.0009085365867660, 
 0.0009062235426580, 0.0009039085922583, 0.0009015929500057, 0.0008992754428517, 
 0.0008969572896476, 0.0008946373129853, 0.0008923167361111, 0.0008899943772796, 
 0.0008876714641157, 0.0008853468105403, 0.0008830216485500, 0.0008806947877423, 
 0.0008783674644778, 0.0008760384840354, 0.0008737090871233, 0.0008713780747250, 
 0.0008690466918774, 0.0008667137352737, 0.0008643804542737, 0.0008620456412884, 
 0.0008597105499940, 0.0008573739685245, 0.0008550371548543, 0.0008526988928663, 
 0.0008503604448113, 0.0008480205903261, 0.0008456805959365, 0.0008433392370393, 
 0.0008409977844247, 0.0008386550092586, 0.0008363121865792, 0.0008339680833417, 
 0.0008316239788134, 0.0008292786357479, 0.0008269333376343, 0.0008245868430307, 
 0.0008222404396416, 0.0008198928818373, 0.0008175454615187, 0.0008151969288908, 
 0.0008128485800328, 0.0008104991609905, 0.0008081499720158, 0.0008057997550040, 
 0.0008034498143688, 0.0008010988878640, 0.0007987482840482, 0.0007963967365539, 
 0.0007940455580672, 0.0007916934781069, 0.0007893418134794, 0.0007869892895968, 
 0.0007846372273776, 0.0007822843481364, 0.0007799319768854, 0.0007775788308629, 
 0.0007752262391559, 0.0007728729149357, 0.0007705201913563, 0.0007681667775295, 
 0.0007658140106664, 0.0007634605958288, 0.0007611078742702, 0.0007587545470195, 
 0.0007564019593533, 0.0007540488082797, 0.0007516964430897, 0.0007493435567778, 
 0.0007469915026395, 0.0007446389696655, 0.0007422873151397, 0.0007399352240674, 
 0.0007375840577027, 0.0007352324970767, 0.0007328819074026, 0.0007305309657457, 
 0.0007281810412726, 0.0007258308070889, 0.0007234816362957, 0.0007211321980629, 
 0.0007187838694056, 0.0007164353155664, 0.0007140879174682, 0.0007117403364347, 
 0.0007093939572841, 0.0007070474374323, 0.0007047021655767, 0.0007023567952434, 
 0.0007000127189928, 0.0006976685864689, 0.0006953257940847, 0.0006929829876145, 
 0.0006906415673129, 0.0006883001750935, 0.0006859602150350, 0.0006836203252106, 
 0.0006812819135042, 0.0006789436141584, 0.0006766068388539, 0.0006742702180111, 
 0.0006719351670979, 0.0006696003127226, 0.0006672670741215, 0.0006649340741110, 
 0.0006626027356778, 0.0006602716778569, 0.0006579423273756, 0.0006556132994963, 
 0.0006532860246764, 0.0006509591144162, 0.0006486340028863, 0.0006463092978435, 
 0.0006439864371534, 0.0006416640248405, 0.0006393435024547, 0.0006370234702985, 
 0.0006347053735946, 0.0006323878089336, 0.0006300722251949, 0.0006277572152752, 
 0.0006254442316926, 0.0006231318636623, 0.0006208215673290, 0.0006185119282354, 
 0.0006162044061437, 0.0006138975829345, 0.0006115929219694, 0.0006092890014871, 
 0.0006069872884287, 0.0006046863574012, 0.0006023876789197, 0.0006000898239673, 
 0.0005977942666143, 0.0005954995742395, 0.0005932072244525, 0.0005909157810390, 
 0.0005886267251344, 0.0005863386169425, 0.0005840529411126, 0.0005817682542788, 
 0.0005794860445883, 0.0005772048651194, 0.0005749262075006, 0.0005726486212721, 
 0.0005703736015270, 0.0005680996942763, 0.0005658283980703, 0.0005635582553993, 
 0.0005612907682536, 0.0005590244756218, 0.0005567608829157, 0.0005544985256382, 
 0.0005522389126073, 0.0005499805758471, 0.0005477250275753, 0.0005454707963490, 
 0.0005432193977659, 0.0005409693569336, 0.0005387221928120, 0.0005364764270766, 
 0.0005342335820336, 0.0005319921759338, 0.0005297537344226, 0.0005275167723372, 
 0.0005252828186435, 0.0005230503847818, 0.0005208210030217, 0.0005185931814242, 
 0.0005163684555450, 0.0005141453300750, 0.0005119253438483, 0.0005097069981951, 
 0.0005074918352112, 0.0005052783528845, 0.0005030680965532, 0.0005008595608789, 
 0.0004986542944266, 0.0004964507885422, 0.0004942505950078, 0.0004920522018647, 
 0.0004898571640941, 0.0004876639664486, 0.0004854741670941, 0.0004832862475098, 
 0.0004811017690274, 0.0004789192098653, 0.0004767401345109, 0.0004745630179334, 
 0.0004723894277583, 0.0004702178357217, 0.0004680498125705, 0.0004658838268230, 
 0.0004637214523328, 0.0004615611544109, 0.0004594045100045, 0.0004572499812316, 
 0.0004550991481167, 0.0004529504695986, 0.0004508055287627, 0.0004486627813855, 
 0.0004465238135964, 0.0004443870780212, 0.0004422541638211, 0.0004401235204844, 
 0.0004379967401872, 0.0004358722692953, 0.0004337517029829, 0.0004316334845106, 
 0.0004295192120334, 0.0004274073257179, 0.0004252994266889, 0.0004231939520309, 
 0.0004210925058216, 0.0004189935220798, 0.0004168986078196, 0.0004148061940089, 
 0.0004127178905812, 0.0004106321254677, 0.0004085505115081, 0.0004064714736089, 
 0.0004043966274998, 0.0004023243950780, 0.0004002563949468, 0.0003981910460105, 
 0.0003961299697277, 0.0003940715820230, 0.0003920175071999, 0.0003899661582138, 
 0.0003879191621946, 0.0003858749291480, 0.0003838350890126, 0.0003817980488582, 
 0.0003797654414173, 0.0003777356708360, 0.0003757103726284, 0.0003736879480296, 
 0.0003716700353166, 0.0003696550328317, 0.0003676445815981, 0.0003656370770801, 
 0.0003636341630301, 0.0003616342320480, 0.0003596389306020, 0.0003576466484408, 
 0.0003556590347316, 0.0003536744763884, 0.0003516946252601, 0.0003497178654412, 
 0.0003477458514458, 0.0003457769645623, 0.0003438128619570, 0.0003418519221259, 
 0.0003398958048690, 0.0003379428859064, 0.0003359948276567, 0.0003340500030777, 
 0.0003321100771898, 0.0003301734202040, 0.0003282416997269, 0.0003263132832367, 
 0.0003243898409095, 0.0003224697375077, 0.0003205546457594, 0.0003186429277245, 
 0.0003167362586687, 0.0003148329979637, 0.0003129348233973, 0.0003110400916677, 
 0.0003091504830672, 0.0003072643516372, 0.0003053833801570, 0.0003035059200264, 
 0.0003016336564961, 0.0002997649383378, 0.0002979014532592, 0.0002960415474181, 
 0.0002941869109609, 0.0002923358874502, 0.0002904901694534, 0.0002886480979506, 
 0.0002868113679155, 0.0002849783177615, 0.0002831506448528, 0.0002813266850491, 
 0.0002795081380886, 0.0002776933372949, 0.0002758839847620, 0.0002740784112924, 
 0.0002722783213205, 0.0002704820431411, 0.0002686912835142, 0.0002669043682430, 
 0.0002651230063941, 0.0002633455212953, 0.0002615736243032, 0.0002598056362864, 
 0.0002580432708746, 0.0002562848464903, 0.0002545320790231, 0.0002527832844640, 
 0.0002510401809434, 0.0002493010820390, 0.0002475677081037, 0.0002458383703172, 
 0.0002441147912408, 0.0002423952796689, 0.0002406815603550, 0.0002389719397243, 
 0.0002372681447045, 0.0002355684793700, 0.0002338746728041, 0.0002321850267443, 
 0.0002305012724150, 0.0002288217092319, 0.0002271480705444, 0.0002254786534608, 
 0.0002238151934377, 0.0002221559852943, 0.0002205027665772, 0.0002188538298294, 
 0.0002172109146725, 0.0002155723113902, 0.0002139397616608, 0.0002123115535242, 
 0.0002106894306985, 0.0002090716789970, 0.0002074600441592, 0.0002058528097878, 
 0.0002042517236278, 0.0002026550670852, 0.0002010645898957, 0.0001994785712825, 
 0.0001978987629558, 0.0001963234419737, 0.0001947543620004, 0.0001931897979463, 
 0.0001916315054143, 0.0001900777571811, 0.0001885303107716, 0.0001869874368444, 
 0.0001854508948295, 0.0001839189532852, 0.0001823933735280, 0.0001808724220299, 
 0.0001793578619794, 0.0001778479577788, 0.0001763444744699, 0.0001748456744014, 
 0.0001733533244516, 0.0001718656849314, 0.0001703845245396, 0.0001689081015649, 
 0.0001674381865078, 0.0001659730356516, 0.0001645144212836, 0.0001630605976964, 
 0.0001616133389456, 0.0001601708973506, 0.0001587350487177, 0.0001573040434097, 
 0.0001558796589663, 0.0001544601438088, 0.0001530472771949, 0.0001516393056192, 
 0.0001502380100407, 0.0001488416350443, 0.0001474519632715, 0.0001460672374149, 
 0.0001446892417806, 0.0001433162171845, 0.0001419499495822, 0.0001405886779284, 
 0.0001392341898097, 0.0001378847223364, 0.0001365420647098, 0.0001352044522117, 
 0.0001338736756393, 0.0001325479684637, 0.0001312291230618, 0.0001299153711082, 
 0.0001286085065428, 0.0001273067592611, 0.0001260119247478, 0.0001247222311350, 
 0.0001234394754361, 0.0001221618840362, 0.0001208912554588, 0.0001196258143597, 
 0.0001183673607554, 0.0001171141175876, 0.0001158678863487, 0.0001146268882835, 
 0.0001133929263430, 0.0001121642200904, 0.0001109425739187, 0.0001097262057262, 
 0.0001085169213304, 0.0001073129369812, 0.0001061160599024, 0.0001049245047131, 
 0.0001037400800261, 0.0001025609988450, 0.0001013890711552, 0.0001002225083618, 
 0.0000990631218049, 0.0000979091213066, 0.0000967623195447, 0.0000956209247766, 
 0.0000944867509992, 0.0000933580049212, 0.0000922365018421, 0.0000911204469384, 
 0.0000900116567940, 0.0000889083350705, 0.0000878122996192, 0.0000867217526025, 
 0.0000856385131221, 0.0000845607818580, 0.0000834903791447, 0.0000824255041963, 
 0.0000813679785627, 0.0000803160000094, 0.0000792713912836, 0.0000782323487190, 
 0.0000772006962427, 0.0000761746287732, 0.0000751559714006, 0.0000741429176440, 
 0.0000731372937397, 0.0000721372918248, 0.0000711447392623, 0.0000701578268253, 
 0.0000691783829869, 0.0000682045971716, 0.0000672382989456, 0.0000662776764020, 
 0.0000653245601820, 0.0000643771370636, 0.0000634372387465, 0.0000625030507110, 
 0.0000615764056962, 0.0000606554879021, 0.0000597421310903, 0.0000588345181968, 
 0.0000579344839882, 0.0000570402101535, 0.0000561535324467, 0.0000552726313271, 
 0.0000543993435179, 0.0000535318482656, 0.0000526719832454, 0.0000518179265089, 
 0.0000509715166642, 0.0000501309305846, 0.0000492980077954, 0.0000484709240076, 
 0.0000476515196455, 0.0000468379692760, 0.0000460321142042, 0.0000452321278699, 
 0.0000444398524414, 0.0000436534602479, 0.0000428747943044, 0.0000421020258463, 
 0.0000413369987169, 0.0000405778830757, 0.0000398265235759, 0.0000390810893189, 
 0.0000383434257504, 0.0000376117009297, 0.0000368877610776, 0.0000361697732294, 
 0.0000354595843626, 0.0000347553605061, 0.0000340589493760, 0.0000333685160112, 
 0.0000326859088500, 0.0000320092919595, 0.0000313405144798, 0.0000306777395239, 
 0.0000300228169180, 0.0000293739088371, 0.0000287328657754, 0.0000280978489880, 
 0.0000274707096178, 0.0000268496080188, 0.0000262363959651, 0.0000256292329255, 
 0.0000250299712880, 0.0000244367696546, 0.0000238514810080, 0.0000232722631010, 
 0.0000227009694944, 0.0000221357571089, 0.0000215784800634, 0.0000210272944660, 
 0.0000204840549763, 0.0000199469169058, 0.0000194177354371, 0.0000188946651042, 
 0.0000183795615924, 0.0000178705786771, 0.0000173695725290, 0.0000168746961815, 
 0.0000163878062721, 0.0000159070551117, 0.0000154342997848, 0.0000149676918984, 
 0.0000145090889658, 0.0000140566419085, 0.0000136122086492, 0.0000131739394426, 
 0.0000127436926019, 0.0000123196177338, 0.0000119035735228, 0.0000114937089471, 
 0.0000110918830418, 0.0000106962441774, 0.0000103086517188, 0.0000099272534486, 
 0.0000095539090417, 0.0000091867657131, 0.0000088276834263, 0.0000084748088498, 
 0.0000081300022144, 0.0000077914096637, 0.0000074608916732, 0.0000071365938842, 
 0.0000068203769944, 0.0000065103861656, 0.0000062084822928, 0.0000059128100833, 
 0.0000056252306053, 0.0000053438881371, 0.0000050706438911, 0.0000048036417463, 
 0.0000045447430299, 0.0000042920912511, 0.0000040475478208, 0.0000038092559118, 
 0.0000035790769825, 0.0000033551539074, 0.0000031393481516, 0.0000029298023359, 
 0.0000027283778834, 0.0000025332172121, 0.0000023461816488, 0.0000021654134693, 
 0.0000019927738349, 0.0000018264049576, 0.0000016681677443, 0.0000015162044443, 
 0.0000013723755940, 0.0000012348236144, 0.0000011054085119, 0.0000009822730712, 
 0.0000008672765373, 0.0000007585623403, 0.0000006579886128, 0.0000005636998746, 
 0.0000004775525747, 0.0000003976930737, 0.0000003259751239, 0.0000002605483273, 
 0.0000002032617449, 0.0000001522711703, 0.0000001094164018, 0.0000000728669306, 
 0.0000000444399884, 0.0000000223449918, 0.0000000083158823, 0.0000000007874844};

/************************************************************************/
/* returns a pointer to the proper quadrature weights for a given
   bandwidth bw and IF THE ORDER IS ODD.  Weights array is of size 2*bw.
   A closed form for the weights can be found in the original Driscoll
   and Healy paper, but need to be normalized */

const double *get_oddweights( int bw )
{

  switch(bw)
    {
    case 4: return ow4;
    case 8: return ow8;
    case 16: return ow16;
    case 32: return ow32;
    case 64: return ow64;
    case 128: return ow128;
    case 256: return ow256;
    case 512: return ow512;
    case 1024: return ow1024;
    default: return 0;
    }
}
