# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/prestoConnection.json
#   timestamp: 2022-04-28T16:26:14+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class PrestoType(Enum):
    Presto = 'Presto'


class PrestoScheme(Enum):
    presto = 'presto'


class PrestoConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[PrestoType] = Field(
        PrestoType.Presto, description='Service Type', title='Service Type'
    )
    scheme: Optional[PrestoScheme] = Field(
        PrestoScheme.presto,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='username to connect  to the Postgres. This user should have privileges to read all the metadata in Postgres.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Postgres.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the Postgres.', title='Host and Port'
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
        title='Database',
    )
    catalog: Optional[str] = Field(None, description='Presto catalog', title='Catalog')
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
