# generated by datamodel-codegen:
#   filename:  schema/api/teams/createTeam.json
#   timestamp: 2022-04-28T16:26:14+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityReference, profile


class CreateTeamRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName
    displayName: Optional[str] = Field(
        None,
        description="Optional name used for display purposes. Example 'Marketing Team'.",
    )
    description: Optional[str] = Field(
        None, description='Optional description of the team.'
    )
    profile: Optional[profile.Profile] = Field(
        None, description='Optional team profile information.'
    )
    users: Optional[List[basic.Uuid]] = Field(
        None, description='Optional IDs of users that are part of the team.'
    )
    defaultRoles: Optional[List[basic.Uuid]] = Field(
        None,
        description='Roles to be assigned to all users that are part of this team.',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this team. '
    )
    isJoinable: Optional[bool] = Field(
        True,
        description='Can any user join this team during sign up? Value of true indicates yes, and false no.',
    )
