# generated by datamodel-codegen:
#   filename:  schema/api/data/createChart.json
#   timestamp: 2022-04-28T16:26:14+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from ...entity.data import chart
from ...type import basic, entityReference, tagLabel


class CreateChartRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(..., description='Name that identifies this Chart.')
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this Chart. It could be title or label from the source services',
    )
    description: Optional[str] = Field(
        None,
        description='Description of the chart instance. What it has and how to use it.',
    )
    chartType: Optional[chart.ChartType] = None
    chartUrl: Optional[AnyUrl] = Field(
        None, description='Chart URL, pointing to its own Service URL'
    )
    tables: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Link to tables used in this chart.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this chart'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this chart'
    )
    service: entityReference.EntityReference = Field(
        ..., description='Link to the chart service where this chart is hosted in'
    )
