# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['entrypoint']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'entrypoint',
    'version': '1.2.1',
    'description': 'Decorated functions as entry points.',
    'long_description': '# entrypoint\n\n[![License][License Badge]][License]\n[![Version][Version Badge]][Package]\n[![Downloads][Downloads Badge]][Package]\n[![Discord][Discord Badge]][Discord]\n\n[![Documentation][Documentation Badge]][Documentation]\n[![Check][Check Badge]][Actions]\n[![Test][Test Badge]][Actions]\n[![Coverage][Coverage Badge]][Coverage]\n\n**Decorated functions as entry points.**\n\nIn python, an *entry point* can be thought of as an explicit function\nthat gets called when the script is run directly from the console.\n\nDefining an entry point requires some boilerplate code, which is\nabstracted away by this library.\n\n## Installing\n\n**Python 3.7 or above is required.**\n\n### pip\n\nInstalling with `pip` is quite simple:\n\n```console\n$ pip install entrypoint\n```\n\nAlternatively, the library can be installed from source:\n\n```console\n$ git clone https://github.com/nekitdev/entrypoint.git\n$ cd entrypoint\n$ python -m pip install .\n```\n\n### poetry\n\nAdding `entrypoint` to dependencies:\n\n```console\n$ poetry add entrypoint\n```\n\nOr directly specifying it in the configuration:\n\n```toml\n[tool.poetry.dependencies]\nentrypoint = "^1.2.1"\n```\n\nAlternatively, the latest version can be included, installing from source:\n\n```toml\n[tool.poetry.dependencies.entrypoint]\ngit = "https://github.com/nekitdev/entrypoint.git"\n```\n\n## Examples\n\n### Decorated\n\nDeclare `main` function as an *entry point*:\n\n```python\nfrom entrypoint import entrypoint\n\n@entrypoint(__name__)\ndef main() -> None:\n    print("Hello, world!")\n```\n\nRun the script directly from the console:\n\n```console\n$ python file.py\nHello, world!\n```\n\nWhen importing the module, `main` does not get called:\n\n```python\n>>> import file\n>>> # no output\n```\n\n### Note\n\nNote that `main` gets called **immediately, before any code below can be executed**:\n\n```python\n@entrypoint(__name__)\ndef main() -> None:\n    print("-> in main")\n\nprint("<- outside")\n```\n\n```console\n$ python note.py\n-> in main\n<- outside\n```\n\n### Direct\n\nIt is possible to run `main` directly:\n\n```python\nentrypoint(__name__).call(main)\n```\n\nThis method allows to take control over where and when the function gets called.\n\n### Check\n\nThe library also provides `is_main` function that resembles\nthe common (and standard) way of implementing *entry points*:\n\n```python\nfrom entrypoint import is_main\n\nif is_main(__name__):\n    print("Hello, world!")\n```\n\n### Async\n\n`entrypoint` does not provide any specific functionality to run async functions.\n\nInstead, you can specify, for example, a `main` function that runs its `async_main` counterpart:\n\n```python\nimport asyncio\n\nasync def async_main() -> None:\n    print("Hello, world!")\n\n@entrypoint(__name__)\ndef main() -> None:\n    asyncio.run(async_main())\n```\n\n## Documentation\n\nDocumentation is located [here][Documentation].\n\n## Support\n\nPlease send an [email][Email] or refer to the official [Discord server][Discord] for support.\n\n## Changelog\n\nChangelog can be found [here][Changelog].\n\n## Contributing\n\nIf you are interested in contributing to `entrypoint`, make sure to take a look at the\n[Contributing Guide][Contributing Guide], as well as the [Code of Conduct][Code of Conduct].\n\n## License\n\n`entrypoint` is licensed under the MIT License terms. See [License][License] for details.\n\n[Email]: mailto:support@nekit.dev\n\n[Discord]: https://nekit.dev/discord\n\n[Actions]: https://github.com/nekitdev/entrypoint/actions\n\n[Changelog]: https://github.com/nekitdev/entrypoint/blob/main/CHANGELOG.md\n[Code of Conduct]: https://github.com/nekitdev/entrypoint/blob/main/CODE_OF_CONDUCT.md\n[Contributing Guide]: https://github.com/nekitdev/entrypoint/blob/main/CONTRIBUTING.md\n[Security]: https://github.com/nekitdev/entrypoint/blob/main/SECURITY.md\n\n[License]: https://github.com/nekitdev/entrypoint/blob/main/LICENSE\n\n[Package]: https://pypi.org/project/entrypoint\n[Coverage]: https://codecov.io/gh/nekitdev/entrypoint\n[Documentation]: https://nekitdev.github.io/entrypoint\n\n[Discord Badge]: https://img.shields.io/badge/chat-discord-5865f2\n[License Badge]: https://img.shields.io/pypi/l/entrypoint\n[Version Badge]: https://img.shields.io/pypi/v/entrypoint\n[Downloads Badge]: https://img.shields.io/pypi/dm/entrypoint\n\n[Documentation Badge]: https://img.shields.io/badge/docs-material-blue\n\n[Check Badge]: https://github.com/nekitdev/entrypoint/workflows/check/badge.svg\n[Test Badge]: https://github.com/nekitdev/entrypoint/workflows/test/badge.svg\n[Coverage Badge]: https://codecov.io/gh/nekitdev/entrypoint/branch/main/graph/badge.svg\n',
    'author': 'nekitdev',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/nekitdev/entrypoint',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
