#!/usr/bin/env python

import scapy.all as scapy

class NetworkScanner:

	def scan(self,ip):
		arp_request = scapy.ARP(pdst=ip)
		broadcast = scapy.Ether(dst="ff:ff:ff:ff:ff:ff")
		arp_request_broadcadt = broadcast/arp_request
		answered_list = scapy.srp(arp_request_broadcadt, timeout=1, verbose = False)[0]

		clients_list = []
		for element in answered_list:
			client_dict = {"ip":element[1].psrc,"mac":element[1].hwsrc}
			clients_list.append(client_dict)
		self.print_result(clients_list)

	def print_result(self,results_list):
		print("\nIP\t\t\tMAC Address\n-------------------------------------------------------------------------")
		for client in results_list:
			print(client["ip"] + "\t\t" + client["mac"])