"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignalCatalog = exports.SignalCatalogSensor = exports.SignalCatalogBranch = exports.SignalCatalogNode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class SignalCatalogNode {
    constructor() {
        this.node = {};
    }
    toObject() {
        return (this.node);
    }
}
exports.SignalCatalogNode = SignalCatalogNode;
_a = JSII_RTTI_SYMBOL_1;
SignalCatalogNode[_a] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogNode", version: "0.2.2" };
class SignalCatalogBranch extends SignalCatalogNode {
    constructor(name, fullyQualifiedName, description) {
        super();
        this.node = {
            type: 'Branch',
            branch: {
                name: name,
                fullyQualifiedName: fullyQualifiedName,
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogBranch = SignalCatalogBranch;
_b = JSII_RTTI_SYMBOL_1;
SignalCatalogBranch[_b] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogBranch", version: "0.2.2" };
class SignalCatalogSensor extends SignalCatalogNode {
    constructor(name, fullyQualifiedName, dataType, unit, min, max, description) {
        super();
        this.node = {
            type: 'Sensor',
            sensor: {
                name,
                fullyQualifiedName,
                dataType,
                ...unit && { unit },
                ...min && { min },
                ...max && { max },
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogSensor = SignalCatalogSensor;
_c = JSII_RTTI_SYMBOL_1;
SignalCatalogSensor[_c] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogSensor", version: "0.2.2" };
/**
 * The Signal Catalog represents the list of all signals that you want to collect from all
 * the vehicles.
 *
 *
 * The AWS IoT Fleetwise preview can only support a single Signal Catalog per account.
 *
 */
class SignalCatalog extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name || 'default';
        this.description = props.description;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:signal-catalog/${this.name}`;
        this.lambdaRole = new aws_cdk_lib_1.aws_iam.Role(this, 'Role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AdministratorAccess'),
            ],
        });
        this.lambdaLayer = new aws_cdk_lib_1.aws_lambda.LayerVersion(this, 'Boto3', {
            description: 'Boto3 Library with Iot Fleetwise Support',
            compatibleRuntimes: [aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9],
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../layer.zip')),
        });
        const code = aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers'));
        const onEventHandlerService = new aws_cdk_lib_1.aws_lambda.Function(this, 'Service', {
            code,
            handler: 'servicehandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.lambdaLayer],
            role: this.lambdaRole,
        });
        const isCompleteHandlerService = new aws_cdk_lib_1.aws_lambda.Function(this, 'ServiceComplete', {
            code,
            handler: 'servicehandler.is_complete',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.lambdaLayer],
            role: this.lambdaRole,
        });
        const providerService = new aws_cdk_lib_1.custom_resources.Provider(this, 'ServiceProvider', {
            onEventHandler: onEventHandlerService,
            isCompleteHandler: isCompleteHandlerService,
        });
        const serviceResource = new cdk.CustomResource(this, 'ServiceResource', {
            serviceToken: providerService.serviceToken,
            properties: {
                role_arn: props.role.roleArn,
                database_name: props.database.databaseName,
                table_name: props.table.tableName,
            },
        });
        const onEventHandlerCatalog = new aws_cdk_lib_1.aws_lambda.Function(this, 'Catalog', {
            code,
            handler: 'signalcataloghandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.lambdaLayer],
            role: this.lambdaRole,
        });
        const providerCatalog = new aws_cdk_lib_1.custom_resources.Provider(this, 'CatalogProvider', {
            onEventHandler: onEventHandlerCatalog,
        });
        const resourceCatalog = new cdk.CustomResource(this, 'CatalogResource', {
            serviceToken: providerCatalog.serviceToken,
            properties: {
                name: this.name,
                description: this.description,
                nodes: JSON.stringify(props.nodes.map(node => node.toObject())),
            },
        });
        resourceCatalog.node.addDependency(serviceResource);
    }
}
exports.SignalCatalog = SignalCatalog;
_d = JSII_RTTI_SYMBOL_1;
SignalCatalog[_d] = { fqn: "cdk-aws-iotfleetwise.SignalCatalog", version: "0.2.2" };
//# sourceMappingURL=data:application/json;base64,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