"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Fleet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * The fleet of vehicles
 */
class Fleet extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.fleetId = '';
        this.signalCatalog = {};
        this.vehicles = undefined;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:fleet/${props.fleetId}`;
        this.signalCatalog = props.signalCatalog;
        this.fleetId = props.fleetId;
        this.vehicles = props.vehicles || [];
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Lambda', {
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: 'fleethandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.signalCatalog.lambdaLayer],
            role: this.signalCatalog.lambdaRole,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: onEventHandler,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                fleet_id: this.fleetId,
                signal_catalog_arn: this.signalCatalog.arn,
                description: props.description,
                vehicle_ids: this.vehicles.map(v => v.vehicleId),
            },
        });
        resource.node.addDependency(this.signalCatalog);
    }
}
exports.Fleet = Fleet;
_a = JSII_RTTI_SYMBOL_1;
Fleet[_a] = { fqn: "cdk-aws-iotfleetwise.Fleet", version: "0.2.2" };
//# sourceMappingURL=data:application/json;base64,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