# coding: utf-8

"""
    aind-smartsheet-service

     ## aind-smartsheet-service  Service to pull data from SmartSheet.  

    The version of the OpenAPI document: 0.1.3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PerfusionsModel(BaseModel):
    """
    Expected model for the Perfusions SmartSheet
    """ # noqa: E501
    subject_id: Optional[StrictStr] = Field(default=None, alias="subject id")
    var_date: Optional[date] = Field(default=None, alias="date")
    experimenter: Optional[StrictStr] = None
    iacuc_protocol: Optional[StrictStr] = Field(default=None, alias="iacuc protocol")
    animal_weight_prior__g: Optional[StrictStr] = Field(default=None, alias="animal weight prior (g)")
    output_specimen_id_s: Optional[StrictStr] = Field(default=None, alias="Output specimen id(s)")
    postfix_solution: Optional[StrictStr] = Field(default=None, alias="Postfix solution")
    notes: Optional[StrictStr] = Field(default=None, alias="Notes")
    __properties: ClassVar[List[str]] = ["subject id", "date", "experimenter", "iacuc protocol", "animal weight prior (g)", "Output specimen id(s)", "Postfix solution", "Notes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PerfusionsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if subject_id (nullable) is None
        # and model_fields_set contains the field
        if self.subject_id is None and "subject_id" in self.model_fields_set:
            _dict['subject id'] = None

        # set to None if var_date (nullable) is None
        # and model_fields_set contains the field
        if self.var_date is None and "var_date" in self.model_fields_set:
            _dict['date'] = None

        # set to None if experimenter (nullable) is None
        # and model_fields_set contains the field
        if self.experimenter is None and "experimenter" in self.model_fields_set:
            _dict['experimenter'] = None

        # set to None if iacuc_protocol (nullable) is None
        # and model_fields_set contains the field
        if self.iacuc_protocol is None and "iacuc_protocol" in self.model_fields_set:
            _dict['iacuc protocol'] = None

        # set to None if animal_weight_prior__g (nullable) is None
        # and model_fields_set contains the field
        if self.animal_weight_prior__g is None and "animal_weight_prior__g" in self.model_fields_set:
            _dict['animal weight prior (g)'] = None

        # set to None if output_specimen_id_s (nullable) is None
        # and model_fields_set contains the field
        if self.output_specimen_id_s is None and "output_specimen_id_s" in self.model_fields_set:
            _dict['Output specimen id(s)'] = None

        # set to None if postfix_solution (nullable) is None
        # and model_fields_set contains the field
        if self.postfix_solution is None and "postfix_solution" in self.model_fields_set:
            _dict['Postfix solution'] = None

        # set to None if notes (nullable) is None
        # and model_fields_set contains the field
        if self.notes is None and "notes" in self.model_fields_set:
            _dict['Notes'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PerfusionsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subject id": obj.get("subject id"),
            "date": obj.get("date"),
            "experimenter": obj.get("experimenter"),
            "iacuc protocol": obj.get("iacuc protocol"),
            "animal weight prior (g)": obj.get("animal weight prior (g)"),
            "Output specimen id(s)": obj.get("Output specimen id(s)"),
            "Postfix solution": obj.get("Postfix solution"),
            "Notes": obj.get("Notes")
        })
        return _obj


