# coding: utf-8

"""
    aind-smartsheet-service

     ## aind-smartsheet-service  Service to pull data from SmartSheet.  

    The version of the OpenAPI document: 0.1.3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FundingModel(BaseModel):
    """
    Expected model for the Funding Sheet
    """ # noqa: E501
    project_name: Optional[StrictStr] = Field(default=None, alias="Project Name")
    subproject: Optional[StrictStr] = Field(default=None, alias="Subproject")
    project_code: Optional[StrictStr] = Field(default=None, alias="Project Code")
    funding_institution: Optional[StrictStr] = Field(default=None, alias="Funding Institution")
    grant_number: Optional[StrictStr] = Field(default=None, alias="Grant Number")
    fundees: Optional[StrictStr] = Field(default=None, alias="Fundees")
    investigators: Optional[StrictStr] = Field(default=None, alias="Investigators")
    __properties: ClassVar[List[str]] = ["Project Name", "Subproject", "Project Code", "Funding Institution", "Grant Number", "Fundees", "Investigators"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FundingModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if project_name (nullable) is None
        # and model_fields_set contains the field
        if self.project_name is None and "project_name" in self.model_fields_set:
            _dict['Project Name'] = None

        # set to None if subproject (nullable) is None
        # and model_fields_set contains the field
        if self.subproject is None and "subproject" in self.model_fields_set:
            _dict['Subproject'] = None

        # set to None if project_code (nullable) is None
        # and model_fields_set contains the field
        if self.project_code is None and "project_code" in self.model_fields_set:
            _dict['Project Code'] = None

        # set to None if funding_institution (nullable) is None
        # and model_fields_set contains the field
        if self.funding_institution is None and "funding_institution" in self.model_fields_set:
            _dict['Funding Institution'] = None

        # set to None if grant_number (nullable) is None
        # and model_fields_set contains the field
        if self.grant_number is None and "grant_number" in self.model_fields_set:
            _dict['Grant Number'] = None

        # set to None if fundees (nullable) is None
        # and model_fields_set contains the field
        if self.fundees is None and "fundees" in self.model_fields_set:
            _dict['Fundees'] = None

        # set to None if investigators (nullable) is None
        # and model_fields_set contains the field
        if self.investigators is None and "investigators" in self.model_fields_set:
            _dict['Investigators'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FundingModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Project Name": obj.get("Project Name"),
            "Subproject": obj.get("Subproject"),
            "Project Code": obj.get("Project Code"),
            "Funding Institution": obj.get("Funding Institution"),
            "Grant Number": obj.get("Grant Number"),
            "Fundees": obj.get("Fundees"),
            "Investigators": obj.get("Investigators")
        })
        return _obj


