from apps.reporting import variants
from apps.findings.models import Vulnerability, Template


class Report(variants.PentestReport):
    SEVERITY_COLOR_CRITICAL = "#9c1720"
    SEVERITY_COLOR_HIGH = "#d13c0f"
    SEVERITY_COLOR_MEDIUM = "#e8971e"
    SEVERITY_COLOR_LOW = "#2075f5"
    SEVERITY_COLOR_INFORMATIONAL = "#059D1D"

    SEVERITY_COLORS = {
        Vulnerability.SEVERITY_CRITICAL: SEVERITY_COLOR_CRITICAL,
        Vulnerability.SEVERITY_HIGH: SEVERITY_COLOR_HIGH,
        Vulnerability.SEVERITY_MEDIUM: SEVERITY_COLOR_MEDIUM,
        Vulnerability.SEVERITY_LOW: SEVERITY_COLOR_LOW,
        Vulnerability.SEVERITY_INFORMATIONAL: SEVERITY_COLOR_INFORMATIONAL
    }
    CSS = ["css/fontawesome.min.css", "css/codehilite.css"]

    def get_context(self):
        # update the context data to allow access to unique template queryset
        context = super().get_context()
        context["templates"] = Template.objects.unique_and_ordered_for_project(self.project)
        return context
