PyIT2FLS
========
NumPy based toolkit for Interval Type 2 Fuzzy Logic Systems (IT2FLS) simulation.

## Licence
PyIT2FLS is published under MIT License. If you are using the developed toolkit, please cite the paper [PyIT2FLS: A New Python Toolkit for Interval Type 2 Fuzzy Logic Systems](https://arxiv.org/abs/1909.10051).

    @misc{haghrah2019pyit2fls,
        title={PyIT2FLS: A New Python Toolkit for Interval Type 2 Fuzzy Logic Systems},
        author={Amir Arslan Haghrah and Sehraneh Ghaemi},
        year={2019},
        eprint={1909.10051},
        archivePrefix={arXiv},
        primaryClass={eess.SY}
    }

## Installation
PyIT2FLS can be installed by unzipping the source code in one directory and using this command:

    (sudo) python3 setup.py install

Or you can use pip3:

    (sudo) pip3 install --upgrade pyit2fls

## Examples
There are five examples provided over github page along with the toolkit, which are listed as below:

* Ex1: Defining an Interval Type 2 Fuzzy Set (IT2FS)

* Ex2: Application of join and meet operators and plotting the outputs

* Ex3: Defining a simple (MIMO) IT2FLS

* Ex4: Prediction of the Mackey-Glass chaotic time series with PSO-based parameter tuning

* Ex5: Designing Interval Type 2 Fuzzy PID (IT2FPID) controller for a time-delay linear system

* Ex6: Creating and plotting ten types of interval type two fuzzy sets.

* Ex7: Similar to Ex3 but implemented using the new Mamdani class. The new Mamadani class is 3 times faster compared to the IT2FLS class.

* Ex8: Defining a simple multi-input multi-output IT2 TSK FLS.

* Ex9: Defining a multi-input multi-output IT2 TSK FLS and plotting the 3D resulting output planes.

* Ex10: Defining a multi-input multi-output IT2FLS with different domains for each of input and output variables, and plotting the output surfaces of the system.


