from setuptools import setup

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

extrafiles =['MonoTools/data/tables/GKSPCPapTable1_Final.txt',
             'MonoTools/data/tables/BolMag_interpolations.models',
             'MonoTools/data/tables/Cheops_Quad_LDs.txt',
             'MonoTools/data/tables/KeplerLDlaws.txt',
             'MonoTools/data/tables/tess_lc_locations.csv',
             'MonoTools/data/tables/GKSPCPapTable2_Final.txt',
             'MonoTools/data/tables/logprob_array_kip.txt',
             'MonoTools/data/tables/logprob_array_flat.txt',
             'MonoTools/data/tables/logprob_array_apo.txt',
             'MonoTools/data/tables/emarg_array_flat.txt',
             'MonoTools/data/tables/tessLDs.txt',
             'MonoTools/data/tables/emarg_array_vve.txt',
             'MonoTools/data/tables/emarg_array_kip.txt',
             'MonoTools/data/tables/interpolated_functions_for_vcirc.pkl',
             'MonoTools/data/tables/tces_per_cadence.txt',
             'MonoTools/data/tables/emarg_array_apo.txt',
             'MonoTools/data/tables/logprob_array_vve.txt',
             'MonoTools/data/tables/LogMePriorFromRe.txt',
             'MonoTools/data/tables/Cheops_Quad_LDs_AllFeHs.txt',
             'MonoTools/tests/test_fit.py',
             'MonoTools/stellar/Densities_as_found_by_starpars.csv',
             'MonoTools/stellar/__init__.py',
             'MonoTools/stellar/LAMOST_5_res_all.numbers',
             'MonoTools/stellar/apjaa8b0ft3_mrt.txt',
             'MonoTools/stellar/cks_gaia_bright_xmatch.txt',
             'MonoTools/stellar/KepASstars.txt',
             'MonoTools/stellar/BolMag',
             'MonoTools/stellar/isoclassify/LICENSE',
             'MonoTools/stellar/isoclassify/requirements.txt',
             'MonoTools/stellar/isoclassify/__init__.py',
             'MonoTools/stellar/isoclassify/README.md',
             'MonoTools/stellar/isoclassify/huber17scripts/tgas_combined_obs.txt',
             'MonoTools/stellar/isoclassify/huber17scripts/ini',
             'MonoTools/stellar/isoclassify/huber17scripts/apokasc_direct.py',
             'MonoTools/stellar/isoclassify/huber17scripts/apokasc_grid.py',
             'MonoTools/stellar/isoclassify/bin/isoclassify',
             'MonoTools/stellar/isoclassify/isoclassify/__init__.py',
             'MonoTools/stellar/isoclassify/isoclassify/pipeline.py',
             'MonoTools/stellar/isoclassify/isoclassify/direct/getmesabc.py',
             'MonoTools/stellar/isoclassify/isoclassify/direct/classify.py',
             'MonoTools/stellar/isoclassify/isoclassify/direct/__init__.py',
             'MonoTools/stellar/isoclassify/isoclassify/direct/asfgrid.py',
             'MonoTools/stellar/isoclassify/isoclassify/grid/temp',
             'MonoTools/stellar/isoclassify/isoclassify/grid/plot.py',
             'MonoTools/stellar/isoclassify/isoclassify/grid/classify.py',
             'MonoTools/stellar/isoclassify/isoclassify/grid/__init__.py',
             'MonoTools/stellar/isoclassify/isoclassify/grid/example-bc.ipynb',
             'MonoTools/stellar/isoclassify/isoclassify/grid/pdf.py',
             'MonoTools/stellar/isoclassify/isoclassify/grid/priors.py',
             'MonoTools/stellar/isoclassify/isoclassify/grid/match.py',
             'MonoTools/stellar/isoclassify/examples/example.csv',
             'MonoTools/stellar/isoclassify/examples/grid.ipynb',
             'MonoTools/stellar/isoclassify/examples/direct.ipynb']

setup(
    name='MonoTools',
    version='0.1.2',
    description='A package for detecting, vetting and modelling transiting exoplanets on uncertain periods',
    url='https://github.com/hposborn/MonoTools',
    author='Hugh P. Osborn',
    author_email='hugh.osborn@space.unibe.ch',
    long_description=long_description,
    long_description_content_type="text/markdown",
    license='BSD 2-clause',
    project_urls={
        "Bug Tracker": "https://github.com/hposborn/MonoTools/issues",
    },
    packages=['MonoTools'],
    package_data={'MonoTools': extrafiles},
    install_requires=['matplotlib',
                      'numpy',
                      'pandas',
                      'scipy',
                      'astropy',
                      'astroquery',
                      'batman-package==2.4.7',
                      'lightkurve==1.11.0',
                      'arviz==0.11',
                      'Theano==1.0.4',
                      'pymc3==3.8',
                      'exoplanet==0.3.2',
                      'celerite',
                      'requests',
                      'urllib3',
                      'lxml',
                      'httplib2',
                      'h5py',
                      'ipython',
                      'bokeh',
                      'corner',
                      'transitleastsquares',
                      'eleanor',
                      'seaborn',
                      'iteround',
                      ],
    classifiers=[
        'Development Status :: 1 - Planning',
        'Intended Audience :: Science/Research',
    ],
)
