from dataclasses import dataclass, field
from enum import Enum
from typing import Optional
from xsdata.models.datatype import XmlDateTime
from ukrdc_xsdata.ukrdc.types.cf_snomed import CfSnomed
from ukrdc_xsdata.ukrdc.types.clinician import Clinician
from ukrdc_xsdata.ukrdc.types.location import Location

__NAMESPACE__ = "http://www.rixg.org.uk/"


class DiagnosisVerificationStatus(Enum):
    """
    :cvar UNCONFIRMED: Unconfirmed
    :cvar PROVISIONAL: Provisional
    :cvar DIFFERENTIAL: Differential
    :cvar CONFIRMED: Confirmed
    :cvar REFUTED: Refuted
    :cvar ENTERED_IN_ERROR: Entered in Error
    """
    UNCONFIRMED = "unconfirmed"
    PROVISIONAL = "provisional"
    DIFFERENTIAL = "differential"
    CONFIRMED = "confirmed"
    REFUTED = "refuted"
    ENTERED_IN_ERROR = "entered-in-error"


@dataclass
class Diagnosis:
    """
    :ivar diagnosis_type:
    :ivar diagnosing_clinician: National Clinicial code where possible
        or other local code if not.
    :ivar diagnosis: SNOMED CT coded diagnoses. This should also include
        any diagnosis that has been submitted elsewhere as a Primary
        Renal Diagnosis.
    :ivar comments: Free text about the Diagnosis
    :ivar identification_time: Date of initial diagnosis
    :ivar onset_time: Date condition began.
    :ivar verification_status: The verification status to support or
        decline the clinical status of the condition or diagnosis.
    :ivar entered_on: The date the diagnosis was recorded in the medical
        record.
    :ivar encounter_number: This is used to associate a Diagnosis with
        the activity in a particular Encounter record. This element
        should not be submitted without prior discussion with the UKRR.
    :ivar entered_at: National code for the hospital providing care -
        e.g. RXF01
    :ivar updated_on: Last Modified Date
    :ivar external_id: Unique Identifier
    """
    diagnosis_type: Optional[str] = field(
        default=None,
        metadata={
            "name": "DiagnosisType",
            "type": "Element",
            "namespace": "",
        }
    )
    diagnosing_clinician: Optional[Clinician] = field(
        default=None,
        metadata={
            "name": "DiagnosingClinician",
            "type": "Element",
            "namespace": "",
        }
    )
    diagnosis: Optional[CfSnomed] = field(
        default=None,
        metadata={
            "name": "Diagnosis",
            "type": "Element",
            "namespace": "",
        }
    )
    comments: Optional[str] = field(
        default=None,
        metadata={
            "name": "Comments",
            "type": "Element",
            "namespace": "",
        }
    )
    identification_time: Optional[XmlDateTime] = field(
        default=None,
        metadata={
            "name": "IdentificationTime",
            "type": "Element",
            "namespace": "",
        }
    )
    onset_time: Optional[XmlDateTime] = field(
        default=None,
        metadata={
            "name": "OnsetTime",
            "type": "Element",
            "namespace": "",
        }
    )
    verification_status: Optional[DiagnosisVerificationStatus] = field(
        default=None,
        metadata={
            "name": "VerificationStatus",
            "type": "Element",
            "namespace": "",
        }
    )
    entered_on: Optional[XmlDateTime] = field(
        default=None,
        metadata={
            "name": "EnteredOn",
            "type": "Element",
            "namespace": "",
        }
    )
    encounter_number: Optional[str] = field(
        default=None,
        metadata={
            "name": "EncounterNumber",
            "type": "Element",
            "namespace": "",
        }
    )
    entered_at: Optional[Location] = field(
        default=None,
        metadata={
            "name": "EnteredAt",
            "type": "Element",
            "namespace": "",
        }
    )
    updated_on: Optional[XmlDateTime] = field(
        default=None,
        metadata={
            "name": "UpdatedOn",
            "type": "Element",
            "namespace": "",
        }
    )
    external_id: Optional[str] = field(
        default=None,
        metadata={
            "name": "ExternalId",
            "type": "Element",
            "namespace": "",
            "max_length": 100,
        }
    )
