# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceMetadataPipeline.json
#   timestamp: 2022-10-26T20:09:57+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field, SecretStr

from ..security.credentials import awsCredentials, gcsCredentials
from ..type import filterPattern


class DatabaseMetadataConfigType(Enum):
    DatabaseMetadata = 'DatabaseMetadata'


class DbtBucketDetails(BaseModel):
    class Config:
        extra = Extra.forbid

    dbtBucketName: Optional[str] = Field(
        None,
        description='Name of the bucket where the dbt files are stored',
        title='DBT Bucket Name',
    )
    dbtObjectPrefix: Optional[str] = Field(
        None,
        description='Path of the folder where the dbt files are stored',
        title='DBT Object Prefix',
    )


class DbtCloudConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    dbtCloudAuthToken: SecretStr = Field(
        ...,
        description='DBT cloud account authentication token',
        title='DBT Cloud Authentication Token',
    )
    dbtCloudAccountId: str = Field(
        ..., description='DBT cloud account Id', title='DBT Cloud Account Id'
    )
    dbtCloudProjectId: Optional[str] = Field(
        None,
        description="In case of multiple projects in a DBT cloud account, specify the project's id from which you want to extract the DBT run artifacts",
        title='DBT Cloud Project Id',
    )
    dbtUpdateDescriptions: Optional[bool] = Field(
        False,
        description='Optional configuration to update the description from DBT or not',
    )


class DbtLocalConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    dbtCatalogFilePath: str = Field(
        ...,
        description='DBT catalog file path to extract dbt models with their column schemas.',
        title='DBT Catalog File Path',
    )
    dbtManifestFilePath: str = Field(
        ...,
        description='DBT manifest file path to extract dbt models and associate with tables.',
        title='DBT Manifest File Path',
    )
    dbtRunResultsFilePath: Optional[str] = Field(
        None,
        description='DBT run results file path to extract the test results information.',
        title='DBT Run Results File Path',
    )
    dbtUpdateDescriptions: Optional[bool] = Field(
        False,
        description='Optional configuration to update the description from DBT or not',
    )


class DbtHttpConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    dbtCatalogHttpPath: str = Field(
        ...,
        description='DBT catalog http file path to extract dbt models with their column schemas.',
        title='DBT Catalog HTTP File Path',
    )
    dbtManifestHttpPath: str = Field(
        ...,
        description='DBT manifest http file path to extract dbt models and associate with tables.',
        title='DBT Manifest HTTP File Path',
    )
    dbtRunResultsHttpPath: Optional[str] = Field(
        None,
        description='DBT run results http file path to extract the test results information.',
        title='DBT Run Results HTTP File Path',
    )
    dbtUpdateDescriptions: Optional[bool] = Field(
        False,
        description='Optional configuration to update the description from DBT or not',
    )


class DbtS3Config(BaseModel):
    dbtSecurityConfig: Optional[awsCredentials.AWSCredentials] = Field(
        None, title='DBT S3 Security Config'
    )
    dbtPrefixConfig: Optional[DbtBucketDetails] = Field(None, title='DBT Prefix Config')
    dbtUpdateDescriptions: Optional[bool] = Field(
        False,
        description='Optional configuration to update the description from DBT or not',
    )


class DbtGCSConfig(BaseModel):
    dbtSecurityConfig: Optional[gcsCredentials.GCSCredentials] = Field(
        None, title='DBT GCS Security Config'
    )
    dbtPrefixConfig: Optional[DbtBucketDetails] = Field(None, title='DBT Prefix Config')
    dbtUpdateDescriptions: Optional[bool] = Field(
        False,
        description='Optional configuration to update the description from DBT or not',
    )


class DatabaseServiceMetadataPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DatabaseMetadataConfigType] = Field(
        DatabaseMetadataConfigType.DatabaseMetadata, description='Pipeline type'
    )
    markDeletedTables: Optional[bool] = Field(
        True,
        description='Optional configuration to soft delete tables in OpenMetadata if the source tables are deleted.',
    )
    markDeletedTablesFromFilterOnly: Optional[bool] = Field(
        False,
        description='Optional configuration to mark deleted tables only to the filtered schema',
    )
    includeTables: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for tables.',
    )
    includeViews: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for views.',
    )
    includeTags: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for tags.',
    )
    useFqnForFiltering: Optional[bool] = Field(
        False,
        description='Regex will be applied on fully qualified name (e.g service_name.db_name.schema_name.table_name) instead of raw name (e.g. table_name)',
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex exclude tables or databases that matches the pattern.'
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex to only fetch databases that matches the pattern.'
    )
    dbtConfigSource: Optional[
        Union[DbtCloudConfig, DbtLocalConfig, DbtHttpConfig, DbtS3Config, DbtGCSConfig]
    ] = Field(
        None,
        description='Available sources to fetch DBT catalog and manifest files.',
        title='DBT Configuration Source',
    )
