# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/hiveConnection.json
#   timestamp: 2022-10-26T20:09:57+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class HiveType(Enum):
    Hive = 'Hive'


class HiveScheme(Enum):
    hive = 'hive'
    hive_http = 'hive+http'
    hive_https = 'hive+https'


class HiveConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[HiveType] = Field(
        HiveType.Hive, description='Service Type', title='Service Type'
    )
    scheme: Optional[HiveScheme] = Field(
        HiveScheme.hive,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: Optional[str] = Field(
        None,
        description='Username to connect to Hive. This user should have privileges to read all the metadata in Hive.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='Password to connect to Hive.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the Hive service.', title='Host and Port'
    )
    databaseSchema: Optional[str] = Field(
        None,
        description='databaseSchema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single databaseSchema. When left blank, OpenMetadata Ingestion attempts to scan all the databaseSchema.',
        title='databaseSchema',
    )
    authOptions: Optional[str] = Field(
        None,
        description='Authentication options to pass to Hive connector. These options are based on SQLAlchemy.',
        title='URL Authentication Options',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
