# generated by datamodel-codegen:
#   filename:  entity/data/location.json
#   timestamp: 2022-10-26T20:09:57+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference, storage, tagLabel


class LocationType(Enum):
    Bucket = 'Bucket'
    Prefix = 'Prefix'
    Database = 'Database'
    Table = 'Table'
    Iceberg = 'Iceberg'


class Location(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of this location instance.'
    )
    name: basic.EntityName = Field(..., description='Name of a location')
    path: Optional[str] = Field(None, description='Location full path')
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this table. It could be title or label from the source services.',
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description='Fully qualified name of a location in the form `serviceName.locationName`.',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of a location.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to this location resource.'
    )
    locationType: Optional[LocationType] = None
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this location.'
    )
    followers: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Followers of this location.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this location.'
    )
    service: entityReference.EntityReference = Field(
        ...,
        description='Link to the database cluster/service where this database is hosted in.',
    )
    serviceType: Optional[storage.StorageServiceType] = Field(
        None, description='Service type where this storage location is hosted in.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
