import setuptools

with open("README.md") as fp:
    long_description = fp.read()
setuptools.setup(
    name="labs_cdk",
    version="0.0.16",
    author="Vaibhav Bansal",
    author_email="vaibhavbansal@gic.com.sg",
    description="GIC Labs AWS CDK constructs",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/GICLabs/labs-cdk",
    packages=setuptools.find_packages(),
    install_requires=[
        "attrs==20.2.0",
        "aws-cdk.assets==1.62.0",
        "aws-cdk.aws-apigateway==1.62.0",
        "aws-cdk.aws-applicationautoscaling==1.62.0",
        "aws-cdk.aws-autoscaling==1.62.0",
        "aws-cdk.aws-autoscaling-common==1.62.0",
        "aws-cdk.aws-autoscaling-hooktargets==1.62.0",
        "aws-cdk.aws-batch==1.62.0",
        "aws-cdk.aws-certificatemanager==1.62.0",
        "aws-cdk.aws-cloudformation==1.62.0",
        "aws-cdk.aws-cloudfront==1.62.0",
        "aws-cdk.aws-cloudwatch==1.62.0",
        "aws-cdk.aws-codebuild==1.62.0",
        "aws-cdk.aws-codecommit==1.62.0",
        "aws-cdk.aws-codeguruprofiler==1.62.0",
        "aws-cdk.aws-codepipeline==1.62.0",
        "aws-cdk.aws-cognito==1.62.0",
        "aws-cdk.aws-ec2==1.62.0",
        "aws-cdk.aws-ecr==1.62.0",
        "aws-cdk.aws-ecr-assets==1.62.0",
        "aws-cdk.aws-ecs==1.62.0",
        "aws-cdk.aws-ecs-patterns==1.62.0",
        "aws-cdk.aws-efs==1.62.0",
        "aws-cdk.aws-elasticache==1.62.0",
        "aws-cdk.aws-elasticloadbalancing==1.62.0",
        "aws-cdk.aws-elasticloadbalancingv2==1.62.0",
        "aws-cdk.aws-events==1.62.0",
        "aws-cdk.aws-events-targets==1.62.0",
        "aws-cdk.aws-iam==1.62.0",
        "aws-cdk.aws-kinesis==1.62.0",
        "aws-cdk.aws-kms==1.62.0",
        "aws-cdk.aws-lambda==1.62.0",
        "aws-cdk.aws-logs==1.62.0",
        "aws-cdk.aws-rds==1.62.0",
        "aws-cdk.aws-route53==1.62.0",
        "aws-cdk.aws-route53-targets==1.62.0",
        "aws-cdk.aws-s3==1.62.0",
        "aws-cdk.aws-s3-assets==1.62.0",
        "aws-cdk.aws-sam==1.62.0",
        "aws-cdk.aws-secretsmanager==1.62.0",
        "aws-cdk.aws-servicediscovery==1.62.0",
        "aws-cdk.aws-sns==1.62.0",
        "aws-cdk.aws-sns-subscriptions==1.62.0",
        "aws-cdk.aws-sqs==1.62.0",
        "aws-cdk.aws-ssm==1.62.0",
        "aws-cdk.aws-stepfunctions==1.62.0",
        "aws-cdk.cdk-assets-schema==1.41.0",
        "aws-cdk.cloud-assembly-schema==1.62.0",
        "aws-cdk.core==1.62.0",
        "aws-cdk.custom-resources==1.62.0",
        "aws-cdk.cx-api==1.62.0",
        "aws-cdk.region-info==1.62.0",
        "cattrs==1.0.0",
        "constructs==3.0.4",
        "jsii==1.12.0",
        "publication==0.0.3",
        "python-dateutil==2.8.1",
        "six==1.15.0",
        "typing-extensions==3.7.4.2"
    ],
    python_requires=">=3.6",
    classifiers=[
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
    ],
)
