![HERON Logo](./logos/HERON_logo_full.png)
HERON (Holistic Energy Resource Optimization Network) is a project to construct
workflows solving complex resource allocation problems to meet target economic
goals.

It leverages probabalistic analysis tool [raven](https://github.com/idaholab/raven)
to run constructed workflows. HERON is a plugin for RAVEN.

Instructions for
installing RAVEN plugins (including HERON) can be found [on RAVEN's website](https://github.com/idaholab/raven/wiki/Plugins).

See more on the [HERON wiki](https://github.com/idaholab/HERON/wiki)

## Publications
The following are a selection of technical reports, conference proceedings, and journal articles that may be of interest to users and developers of HERON, loosely in order of work performed.

### Technoeconomic Assessments
- [A Technical and Economic Assessment of LWR Flexible Operation for Generation and Demand Balancing to Optimize Plant Revenue](https://www.osti.gov/biblio/1844211-technical-economic-assessment-lwr-flexible-operation-generation-demand-balancing-optimize-plant-revenue)
- [Evaluation of Hybrid FPOG Applications in Regulated and Deregulated Markets Using HERON](https://www.osti.gov/biblio/1755894-evaluation-hybrid-fpog-applications-regulated-deregulated-markets-using-heron)
- [HERON as a Tool for LWR Market Interaction in a Deregulated Market](https://www.osti.gov/biblio/1581179-heron-tool-lwr-market-interaction-deregulated-market) 
- [Evaluation of Hydrogen Production Feasibility for a Light Water Reactor in the Midwest](https://www.osti.gov/biblio/1569271-evaluation-hydrogen-production-feasibility-light-water-reactor-midwest) 
- [Economic Assessment of Nuclear Hybrid Energy Systems: Nuclear-Renewable-Water Integration in Arizona](https://www.osti.gov/biblio/1634115-economic-assessment-nuclear-hybrid-energy-systems-nuclear-renewable-water-integration-arizona) 
- [Economic analysis of a nuclear hybrid energy system in a stochastic environment including wind turbines in an electricity grid](https://www.osti.gov/biblio/1593858-economic-analysis-nuclear-hybrid-energy-system-stochastic-environment-including-wind-turbines-electricity-grid) 

### Synthetic History Generation
- [Correlated synthetic time series generation for energy system simulations using Fourier and ARMA signal processing](https://www.osti.gov/biblio/1603186-correlated-synthetic-time-series-generation-energy-system-simulations-using-fourier-arma-signal-processing) 
- [Synthetic wind speed scenarios generation for probabilistic analysis of hybrid energy systems](https://www.osti.gov/biblio/1361550-synthetic-wind-speed-scenarios-generation-probabilistic-analysis-hybrid-energy-systems) 

### See More
- [Integrated Energy Systems](https://ies.inl.gov/SitePages/Home.aspx)
