/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.core;

import io.qameta.allure.Aggregator;
import io.qameta.allure.context.MarkdownContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public class MarkdownDescriptionsPlugin
implements Aggregator {
    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) {
        configuration.getContext(MarkdownContext.class).ifPresent(markdownContext -> this.processDescriptions(launchesResults, (MarkdownContext)markdownContext));
    }

    private void processDescriptions(List<LaunchResults> launches, MarkdownContext context) {
        launches.stream().flatMap(launch -> launch.getResults().stream()).filter(result -> MarkdownDescriptionsPlugin.isEmpty(result.getDescriptionHtml()) && !MarkdownDescriptionsPlugin.isEmpty(result.getDescription())).forEach(result -> {
            String html = (String)context.getValue().apply(result.getDescription());
            result.setDescriptionHtml(html);
        });
    }

    private static boolean isEmpty(String string) {
        return Objects.isNull(string) || string.isEmpty();
    }
}

