# Code generated by dagger. DO NOT EDIT.

from collections.abc import Sequence
from typing import Optional

from dagger.api.base import Arg, Enum, Input, Root, Scalar, Type, typecheck


class CacheID(Scalar):
    """A global cache volume identifier."""


class ContainerID(Scalar):
    """A unique container identifier. Null designates an empty container
    (scratch)."""


class DirectoryID(Scalar):
    """A content-addressed directory identifier."""


class FileID(Scalar):
    """A file identifier."""


class Platform(Scalar):
    """The platform config OS and architecture in a Container.  The format
    is [os]/[platform]/[version] (e.g., "darwin/arm64/v7",
    "windows/amd64", "linux/arm64")."""


class SecretID(Scalar):
    """A unique identifier for a secret."""


class SocketID(Scalar):
    """A content-addressed socket identifier."""


class CacheSharingMode(Enum):
    """Sharing mode of the cache volume."""

    LOCKED = "LOCKED"
    """Shares the cache volume amongst many build pipelines,
    but will serialize the writes
    """

    PRIVATE = "PRIVATE"
    """Keeps a cache volume for a single build pipeline"""

    SHARED = "SHARED"
    """Shares the cache volume amongst many build pipelines"""


class NetworkProtocol(Enum):
    """Transport layer network protocol associated to a port."""

    TCP = "TCP"
    """TCP (Transmission Control Protocol)"""

    UDP = "UDP"
    """UDP (User Datagram Protocol)"""


class BuildArg(Input):
    """Key value object that represents a build argument."""

    name: str
    """The build argument name."""

    value: str
    """The build argument value."""


class CacheVolume(Type):
    """A directory whose contents persist across runs."""

    @typecheck
    def id(self) -> CacheID:
        """Note
        ----
        This is lazyly evaluated, no operation is actually run.

        Returns
        -------
        CacheID
            A global cache volume identifier.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("id", _args)
        return _ctx.execute_sync(CacheID)


class Container(Type):
    """An OCI-compatible container, also known as a docker container."""

    @typecheck
    def build(
        self,
        context: "Directory",
        dockerfile: Optional[str] = None,
        build_args: Optional[Sequence[BuildArg]] = None,
        target: Optional[str] = None,
    ) -> "Container":
        """Initializes this container from a Dockerfile build.

        Parameters
        ----------
        context:
            Directory context used by the Dockerfile.
        dockerfile:
            Path to the Dockerfile to use.
            Default: './Dockerfile'.
        build_args:
            Additional build arguments.
        target:
            Target build stage to build.
        """
        _args = [
            Arg("context", context),
            Arg("dockerfile", dockerfile, None),
            Arg("buildArgs", build_args, None),
            Arg("target", target, None),
        ]
        _ctx = self._select("build", _args)
        return Container(_ctx)

    @typecheck
    def default_args(self) -> Optional[list[str]]:
        """Retrieves default arguments for future commands.

        Returns
        -------
        Optional[list[str]]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("defaultArgs", _args)
        return _ctx.execute_sync(Optional[list[str]])

    @typecheck
    def directory(self, path: str) -> "Directory":
        """Retrieves a directory at the given path.



        Mounts are included.

        Parameters
        ----------
        path:
            The path of the directory to retrieve (e.g., "./src").
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("directory", _args)
        return Directory(_ctx)

    @typecheck
    def endpoint(
        self,
        port: Optional[int] = None,
        scheme: Optional[str] = None,
    ) -> str:
        """Retrieves an endpoint that clients can use to reach this container.



        If no port is specified, the first exposed port is used. If none exist
        an error is returned.



        If a scheme is specified, a URL is returned. Otherwise, a host:port
        pair is returned.

        Parameters
        ----------
        port:
            The exposed port number for the endpoint
        scheme:
            Return a URL with the given scheme, eg. http for http://

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args = [
            Arg("port", port, None),
            Arg("scheme", scheme, None),
        ]
        _ctx = self._select("endpoint", _args)
        return _ctx.execute_sync(str)

    @typecheck
    def entrypoint(self) -> Optional[list[str]]:
        """Retrieves entrypoint to be prepended to the arguments of all commands.

        Returns
        -------
        Optional[list[str]]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("entrypoint", _args)
        return _ctx.execute_sync(Optional[list[str]])

    @typecheck
    def env_variable(self, name: str) -> Optional[str]:
        """Retrieves the value of the specified environment variable.

        Parameters
        ----------
        name:
            The name of the environment variable to retrieve (e.g., "PATH").

        Returns
        -------
        Optional[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args = [
            Arg("name", name),
        ]
        _ctx = self._select("envVariable", _args)
        return _ctx.execute_sync(Optional[str])

    @typecheck
    def env_variables(self) -> "EnvVariable":
        """Retrieves the list of environment variables passed to commands."""
        _args: list[Arg] = []
        _ctx = self._select("envVariables", _args)
        return EnvVariable(_ctx)

    @typecheck
    def exec(
        self,
        args: Optional[Sequence[str]] = None,
        stdin: Optional[str] = None,
        redirect_stdout: Optional[str] = None,
        redirect_stderr: Optional[str] = None,
        experimental_privileged_nesting: Optional[bool] = None,
    ) -> "Container":
        """Retrieves this container after executing the specified command inside
        it.

        .. deprecated::
            Replaced by :py:meth:`with_exec`.

        Parameters
        ----------
        args:
            Command to run instead of the container's default command (e.g.,
            ["run", "main.go"]).
        stdin:
            Content to write to the command's standard input before closing
            (e.g., "Hello world").
        redirect_stdout:
            Redirect the command's standard output to a file in the container
            (e.g., "/tmp/stdout").
        redirect_stderr:
            Redirect the command's standard error to a file in the container
            (e.g., "/tmp/stderr").
        experimental_privileged_nesting:
            Provide dagger access to the executed command.
            Do not use this option unless you trust the command being
            executed.
            The command being executed WILL BE GRANTED FULL ACCESS TO YOUR
            HOST FILESYSTEM.
        """
        _args = [
            Arg("args", args, None),
            Arg("stdin", stdin, None),
            Arg("redirectStdout", redirect_stdout, None),
            Arg("redirectStderr", redirect_stderr, None),
            Arg("experimentalPrivilegedNesting", experimental_privileged_nesting, None),
        ]
        _ctx = self._select("exec", _args)
        return Container(_ctx)

    @typecheck
    def exit_code(self) -> Optional[int]:
        """Exit code of the last executed command. Zero means success.

        Null if no command has been executed.

        Returns
        -------
        Optional[int]
            The `Int` scalar type represents non-fractional signed whole
            numeric values. Int can represent values between -(2^31) and 2^31
            - 1.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("exitCode", _args)
        return _ctx.execute_sync(Optional[int])

    @typecheck
    def export(
        self,
        path: str,
        platform_variants: Optional[Sequence["Container"]] = None,
    ) -> bool:
        """Writes the container as an OCI tarball to the destination file path on
        the host for the specified platform variants.



        Return true on success.

        It can also publishes platform variants.

        Parameters
        ----------
        path:
            Host's destination path (e.g., "./tarball").
            Path can be relative to the engine's workdir or absolute.
        platform_variants:
            Identifiers for other platform specific containers.
            Used for multi-platform image.

        Returns
        -------
        bool
            The `Boolean` scalar type represents `true` or `false`.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args = [
            Arg("path", path),
            Arg("platformVariants", platform_variants, None),
        ]
        _ctx = self._select("export", _args)
        return _ctx.execute_sync(bool)

    @typecheck
    def exposed_ports(self) -> "Port":
        """Retrieves the list of exposed ports"""
        _args: list[Arg] = []
        _ctx = self._select("exposedPorts", _args)
        return Port(_ctx)

    @typecheck
    def file(self, path: str) -> "File":
        """Retrieves a file at the given path.



        Mounts are included.

        Parameters
        ----------
        path:
            The path of the file to retrieve (e.g., "./README.md").
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("file", _args)
        return File(_ctx)

    @typecheck
    def from_(self, address: str) -> "Container":
        """Initializes this container from a pulled base image.

        Parameters
        ----------
        address:
            Image's address from its registry.
            Formatted as [host]/[user]/[repo]:[tag] (e.g.,
            "docker.io/dagger/dagger:main").
        """
        _args = [
            Arg("address", address),
        ]
        _ctx = self._select("from", _args)
        return Container(_ctx)

    @typecheck
    def fs(self) -> "Directory":
        """Retrieves this container's root filesystem. Mounts are not included.

        .. deprecated::
            Replaced by :py:meth:`rootfs`.
        """
        _args: list[Arg] = []
        _ctx = self._select("fs", _args)
        return Directory(_ctx)

    @typecheck
    def hostname(self) -> str:
        """Retrieves a hostname which can be used by clients to reach this
        container.

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("hostname", _args)
        return _ctx.execute_sync(str)

    @typecheck
    def id(self) -> ContainerID:
        """A unique identifier for this container.

        Note
        ----
        This is lazyly evaluated, no operation is actually run.

        Returns
        -------
        ContainerID
            A unique container identifier. Null designates an empty container
            (scratch).

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("id", _args)
        return _ctx.execute_sync(ContainerID)

    @typecheck
    def image_ref(self) -> Optional[str]:
        """The unique image reference which can only be retrieved immediately
        after the 'Container.From' call.

        Returns
        -------
        Optional[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("imageRef", _args)
        return _ctx.execute_sync(Optional[str])

    @typecheck
    def label(self, name: str) -> Optional[str]:
        """Retrieves the value of the specified label.

        Returns
        -------
        Optional[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args = [
            Arg("name", name),
        ]
        _ctx = self._select("label", _args)
        return _ctx.execute_sync(Optional[str])

    @typecheck
    def labels(self) -> "Label":
        """Retrieves the list of labels passed to container."""
        _args: list[Arg] = []
        _ctx = self._select("labels", _args)
        return Label(_ctx)

    @typecheck
    def mounts(self) -> list[str]:
        """Retrieves the list of paths where a directory is mounted.

        Returns
        -------
        list[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("mounts", _args)
        return _ctx.execute_sync(list[str])

    @typecheck
    def pipeline(
        self,
        name: str,
        description: Optional[str] = None,
    ) -> "Container":
        """Creates a named sub-pipeline"""
        _args = [
            Arg("name", name),
            Arg("description", description, None),
        ]
        _ctx = self._select("pipeline", _args)
        return Container(_ctx)

    @typecheck
    def platform(self) -> Platform:
        """The platform this container executes and publishes as.

        Returns
        -------
        Platform
            The platform config OS and architecture in a Container.  The
            format is [os]/[platform]/[version] (e.g., "darwin/arm64/v7",
            "windows/amd64", "linux/arm64").

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("platform", _args)
        return _ctx.execute_sync(Platform)

    @typecheck
    def publish(
        self,
        address: str,
        platform_variants: Optional[Sequence["Container"]] = None,
    ) -> str:
        """Publishes this container as a new image to the specified address.



        Publish returns a fully qualified ref.

        It can also publish platform variants.

        Parameters
        ----------
        address:
            Registry's address to publish the image to.
            Formatted as [host]/[user]/[repo]:[tag] (e.g.
            "docker.io/dagger/dagger:main").
        platform_variants:
            Identifiers for other platform specific containers.
            Used for multi-platform image.

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args = [
            Arg("address", address),
            Arg("platformVariants", platform_variants, None),
        ]
        _ctx = self._select("publish", _args)
        return _ctx.execute_sync(str)

    @typecheck
    def rootfs(self) -> "Directory":
        """Retrieves this container's root filesystem. Mounts are not included."""
        _args: list[Arg] = []
        _ctx = self._select("rootfs", _args)
        return Directory(_ctx)

    @typecheck
    def stderr(self) -> Optional[str]:
        """The error stream of the last executed command.

        Null if no command has been executed.

        Returns
        -------
        Optional[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("stderr", _args)
        return _ctx.execute_sync(Optional[str])

    @typecheck
    def stdout(self) -> Optional[str]:
        """The output stream of the last executed command.

        Null if no command has been executed.

        Returns
        -------
        Optional[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("stdout", _args)
        return _ctx.execute_sync(Optional[str])

    @typecheck
    def user(self) -> Optional[str]:
        """Retrieves the user to be set for all commands.

        Returns
        -------
        Optional[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("user", _args)
        return _ctx.execute_sync(Optional[str])

    @typecheck
    def with_default_args(
        self,
        args: Optional[Sequence[str]] = None,
    ) -> "Container":
        """Configures default arguments for future commands.

        Parameters
        ----------
        args:
            Arguments to prepend to future executions (e.g., ["-v", "--no-
            cache"]).
        """
        _args = [
            Arg("args", args, None),
        ]
        _ctx = self._select("withDefaultArgs", _args)
        return Container(_ctx)

    @typecheck
    def with_directory(
        self,
        path: str,
        directory: "Directory",
        exclude: Optional[Sequence[str]] = None,
        include: Optional[Sequence[str]] = None,
    ) -> "Container":
        """Retrieves this container plus a directory written at the given path.

        Parameters
        ----------
        path:
            Location of the written directory (e.g., "/tmp/directory").
        directory:
            Identifier of the directory to write
        exclude:
            Patterns to exclude in the written directory (e.g.,
            ["node_modules/**", ".gitignore", ".git/"]).
        include:
            Patterns to include in the written directory (e.g., ["*.go",
            "go.mod", "go.sum"]).
        """
        _args = [
            Arg("path", path),
            Arg("directory", directory),
            Arg("exclude", exclude, None),
            Arg("include", include, None),
        ]
        _ctx = self._select("withDirectory", _args)
        return Container(_ctx)

    @typecheck
    def with_entrypoint(self, args: Sequence[str]) -> "Container":
        """Retrieves this container but with a different command entrypoint.

        Parameters
        ----------
        args:
            Entrypoint to use for future executions (e.g., ["go", "run"]).
        """
        _args = [
            Arg("args", args),
        ]
        _ctx = self._select("withEntrypoint", _args)
        return Container(_ctx)

    @typecheck
    def with_env_variable(self, name: str, value: str) -> "Container":
        """Retrieves this container plus the given environment variable.

        Parameters
        ----------
        name:
            The name of the environment variable (e.g., "HOST").
        value:
            The value of the environment variable. (e.g., "localhost").
        """
        _args = [
            Arg("name", name),
            Arg("value", value),
        ]
        _ctx = self._select("withEnvVariable", _args)
        return Container(_ctx)

    @typecheck
    def with_exec(
        self,
        args: Sequence[str],
        stdin: Optional[str] = None,
        redirect_stdout: Optional[str] = None,
        redirect_stderr: Optional[str] = None,
        experimental_privileged_nesting: Optional[bool] = None,
    ) -> "Container":
        """Retrieves this container after executing the specified command inside
        it.

        Parameters
        ----------
        args:
            Command to run instead of the container's default command (e.g.,
            ["run", "main.go"]).
        stdin:
            Content to write to the command's standard input before closing
            (e.g., "Hello world").
        redirect_stdout:
            Redirect the command's standard output to a file in the container
            (e.g., "/tmp/stdout").
        redirect_stderr:
            Redirect the command's standard error to a file in the container
            (e.g., "/tmp/stderr").
        experimental_privileged_nesting:
            Provides dagger access to the executed command.
            Do not use this option unless you trust the command being
            executed.
            The command being executed WILL BE GRANTED FULL ACCESS TO YOUR
            HOST FILESYSTEM.
        """
        _args = [
            Arg("args", args),
            Arg("stdin", stdin, None),
            Arg("redirectStdout", redirect_stdout, None),
            Arg("redirectStderr", redirect_stderr, None),
            Arg("experimentalPrivilegedNesting", experimental_privileged_nesting, None),
        ]
        _ctx = self._select("withExec", _args)
        return Container(_ctx)

    @typecheck
    def with_exposed_port(
        self,
        port: int,
        protocol: Optional[NetworkProtocol] = None,
        description: Optional[str] = None,
    ) -> "Container":
        """Expose a network port.

        Exposed ports serve two purposes:

          - For health checks and introspection, when running services

          - For setting the EXPOSE OCI field when publishing the container

        Parameters
        ----------
        port:
            Port number to expose
        protocol:
            Transport layer network protocol
        description:
            Optional port description
        """
        _args = [
            Arg("port", port),
            Arg("protocol", protocol, None),
            Arg("description", description, None),
        ]
        _ctx = self._select("withExposedPort", _args)
        return Container(_ctx)

    @typecheck
    def with_fs(self, id: "Directory") -> "Container":
        """Initializes this container from this DirectoryID.

        .. deprecated::
            Replaced by :py:meth:`with_rootfs`.
        """
        _args = [
            Arg("id", id),
        ]
        _ctx = self._select("withFS", _args)
        return Container(_ctx)

    @typecheck
    def with_file(
        self,
        path: str,
        source: "File",
        permissions: Optional[int] = None,
    ) -> "Container":
        """Retrieves this container plus the contents of the given file copied to
        the given path.

        Parameters
        ----------
        path:
            Location of the copied file (e.g., "/tmp/file.txt").
        source:
            Identifier of the file to copy.
        permissions:
            Permission given to the copied file (e.g., 0600).
            Default: 0644.
        """
        _args = [
            Arg("path", path),
            Arg("source", source),
            Arg("permissions", permissions, None),
        ]
        _ctx = self._select("withFile", _args)
        return Container(_ctx)

    @typecheck
    def with_label(self, name: str, value: str) -> "Container":
        """Retrieves this container plus the given label.

        Parameters
        ----------
        name:
            The name of the label (e.g.,
            "org.opencontainers.artifact.created").
        value:
            The value of the label (e.g., "2023-01-01T00:00:00Z").
        """
        _args = [
            Arg("name", name),
            Arg("value", value),
        ]
        _ctx = self._select("withLabel", _args)
        return Container(_ctx)

    @typecheck
    def with_mounted_cache(
        self,
        path: str,
        cache: CacheVolume,
        source: Optional["Directory"] = None,
        sharing: Optional[CacheSharingMode] = None,
    ) -> "Container":
        """Retrieves this container plus a cache volume mounted at the given
        path.

        Parameters
        ----------
        path:
            Location of the cache directory (e.g., "/cache/node_modules").
        cache:
            Identifier of the cache volume to mount.
        source:
            Identifier of the directory to use as the cache volume's root.
        sharing:
            Sharing mode of the cache volume.
        """
        _args = [
            Arg("path", path),
            Arg("cache", cache),
            Arg("source", source, None),
            Arg("sharing", sharing, None),
        ]
        _ctx = self._select("withMountedCache", _args)
        return Container(_ctx)

    @typecheck
    def with_mounted_directory(self, path: str, source: "Directory") -> "Container":
        """Retrieves this container plus a directory mounted at the given path.

        Parameters
        ----------
        path:
            Location of the mounted directory (e.g., "/mnt/directory").
        source:
            Identifier of the mounted directory.
        """
        _args = [
            Arg("path", path),
            Arg("source", source),
        ]
        _ctx = self._select("withMountedDirectory", _args)
        return Container(_ctx)

    @typecheck
    def with_mounted_file(self, path: str, source: "File") -> "Container":
        """Retrieves this container plus a file mounted at the given path.

        Parameters
        ----------
        path:
            Location of the mounted file (e.g., "/tmp/file.txt").
        source:
            Identifier of the mounted file.
        """
        _args = [
            Arg("path", path),
            Arg("source", source),
        ]
        _ctx = self._select("withMountedFile", _args)
        return Container(_ctx)

    @typecheck
    def with_mounted_secret(self, path: str, source: "Secret") -> "Container":
        """Retrieves this container plus a secret mounted into a file at the
        given path.

        Parameters
        ----------
        path:
            Location of the secret file (e.g., "/tmp/secret.txt").
        source:
            Identifier of the secret to mount.
        """
        _args = [
            Arg("path", path),
            Arg("source", source),
        ]
        _ctx = self._select("withMountedSecret", _args)
        return Container(_ctx)

    @typecheck
    def with_mounted_temp(self, path: str) -> "Container":
        """Retrieves this container plus a temporary directory mounted at the
        given path.

        Parameters
        ----------
        path:
            Location of the temporary directory (e.g., "/tmp/temp_dir").
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("withMountedTemp", _args)
        return Container(_ctx)

    @typecheck
    def with_new_file(
        self,
        path: str,
        contents: Optional[str] = None,
        permissions: Optional[int] = None,
    ) -> "Container":
        """Retrieves this container plus a new file written at the given path.

        Parameters
        ----------
        path:
            Location of the written file (e.g., "/tmp/file.txt").
        contents:
            Content of the file to write (e.g., "Hello world!").
        permissions:
            Permission given to the written file (e.g., 0600).
            Default: 0644.
        """
        _args = [
            Arg("path", path),
            Arg("contents", contents, None),
            Arg("permissions", permissions, None),
        ]
        _ctx = self._select("withNewFile", _args)
        return Container(_ctx)

    @typecheck
    def with_registry_auth(
        self,
        address: str,
        username: str,
        secret: "Secret",
    ) -> "Container":
        """Retrieves this container with a registry authentication for a given
        address.

        Parameters
        ----------
        address:
            Registry's address to bind the authentication to.
            Formatted as [host]/[user]/[repo]:[tag] (e.g.
            docker.io/dagger/dagger:main).
        username:
            The username of the registry's account (e.g., "Dagger").
        secret:
            The API key, password or token to authenticate to this registry.
        """
        _args = [
            Arg("address", address),
            Arg("username", username),
            Arg("secret", secret),
        ]
        _ctx = self._select("withRegistryAuth", _args)
        return Container(_ctx)

    @typecheck
    def with_rootfs(self, id: "Directory") -> "Container":
        """Initializes this container from this DirectoryID."""
        _args = [
            Arg("id", id),
        ]
        _ctx = self._select("withRootfs", _args)
        return Container(_ctx)

    @typecheck
    def with_secret_variable(self, name: str, secret: "Secret") -> "Container":
        """Retrieves this container plus an env variable containing the given
        secret.

        Parameters
        ----------
        name:
            The name of the secret variable (e.g., "API_SECRET").
        secret:
            The identifier of the secret value.
        """
        _args = [
            Arg("name", name),
            Arg("secret", secret),
        ]
        _ctx = self._select("withSecretVariable", _args)
        return Container(_ctx)

    @typecheck
    def with_service_binding(self, alias: str, service: "Container") -> "Container":
        """Establish a runtime dependency on a service. The service will be
        started automatically when needed and detached when it is no longer
        needed.



        The service will be reachable from the container via the provided
        hostname alias.



        The service dependency will also convey to any files or directories
        produced by the container.

        Parameters
        ----------
        alias:
            A name that can be used to reach the service from the container
        service:
            Identifier of the service container
        """
        _args = [
            Arg("alias", alias),
            Arg("service", service),
        ]
        _ctx = self._select("withServiceBinding", _args)
        return Container(_ctx)

    @typecheck
    def with_unix_socket(self, path: str, source: "Socket") -> "Container":
        """Retrieves this container plus a socket forwarded to the given Unix
        socket path.

        Parameters
        ----------
        path:
            Location of the forwarded Unix socket (e.g., "/tmp/socket").
        source:
            Identifier of the socket to forward.
        """
        _args = [
            Arg("path", path),
            Arg("source", source),
        ]
        _ctx = self._select("withUnixSocket", _args)
        return Container(_ctx)

    @typecheck
    def with_user(self, name: str) -> "Container":
        """Retrieves this container with a different command user.

        Parameters
        ----------
        name:
            The user to set (e.g., "root").
        """
        _args = [
            Arg("name", name),
        ]
        _ctx = self._select("withUser", _args)
        return Container(_ctx)

    @typecheck
    def with_workdir(self, path: str) -> "Container":
        """Retrieves this container with a different working directory.

        Parameters
        ----------
        path:
            The path to set as the working directory (e.g., "/app").
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("withWorkdir", _args)
        return Container(_ctx)

    @typecheck
    def without_env_variable(self, name: str) -> "Container":
        """Retrieves this container minus the given environment variable.

        Parameters
        ----------
        name:
            The name of the environment variable (e.g., "HOST").
        """
        _args = [
            Arg("name", name),
        ]
        _ctx = self._select("withoutEnvVariable", _args)
        return Container(_ctx)

    @typecheck
    def without_exposed_port(
        self,
        port: int,
        protocol: Optional[NetworkProtocol] = None,
    ) -> "Container":
        """Unexpose a previously exposed port.

        Parameters
        ----------
        port:
            Port number to unexpose
        protocol:
            Port protocol to unexpose
        """
        _args = [
            Arg("port", port),
            Arg("protocol", protocol, None),
        ]
        _ctx = self._select("withoutExposedPort", _args)
        return Container(_ctx)

    @typecheck
    def without_label(self, name: str) -> "Container":
        """Retrieves this container minus the given environment label.

        Parameters
        ----------
        name:
            The name of the label to remove (e.g.,
            "org.opencontainers.artifact.created").
        """
        _args = [
            Arg("name", name),
        ]
        _ctx = self._select("withoutLabel", _args)
        return Container(_ctx)

    @typecheck
    def without_mount(self, path: str) -> "Container":
        """Retrieves this container after unmounting everything at the given
        path.

        Parameters
        ----------
        path:
            Location of the cache directory (e.g., "/cache/node_modules").
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("withoutMount", _args)
        return Container(_ctx)

    @typecheck
    def without_registry_auth(self, address: str) -> "Container":
        """Retrieves this container without the registry authentication of a
        given address.

        Parameters
        ----------
        address:
            Registry's address to remove the authentication from.
            Formatted as [host]/[user]/[repo]:[tag] (e.g.
            docker.io/dagger/dagger:main).
        """
        _args = [
            Arg("address", address),
        ]
        _ctx = self._select("withoutRegistryAuth", _args)
        return Container(_ctx)

    @typecheck
    def without_unix_socket(self, path: str) -> "Container":
        """Retrieves this container with a previously added Unix socket removed.

        Parameters
        ----------
        path:
            Location of the socket to remove (e.g., "/tmp/socket").
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("withoutUnixSocket", _args)
        return Container(_ctx)

    @typecheck
    def workdir(self) -> Optional[str]:
        """Retrieves the working directory for all commands.

        Returns
        -------
        Optional[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("workdir", _args)
        return _ctx.execute_sync(Optional[str])


class Directory(Type):
    """A directory."""

    @typecheck
    def diff(self, other: "Directory") -> "Directory":
        """Gets the difference between this directory and an another directory.

        Parameters
        ----------
        other:
            Identifier of the directory to compare.
        """
        _args = [
            Arg("other", other),
        ]
        _ctx = self._select("diff", _args)
        return Directory(_ctx)

    @typecheck
    def directory(self, path: str) -> "Directory":
        """Retrieves a directory at the given path.

        Parameters
        ----------
        path:
            Location of the directory to retrieve (e.g., "/src").
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("directory", _args)
        return Directory(_ctx)

    @typecheck
    def docker_build(
        self,
        dockerfile: Optional[str] = None,
        platform: Optional[Platform] = None,
        build_args: Optional[Sequence[BuildArg]] = None,
        target: Optional[str] = None,
    ) -> Container:
        """Builds a new Docker container from this directory.

        Parameters
        ----------
        dockerfile:
            Path to the Dockerfile to use (e.g., "frontend.Dockerfile").
            Defaults: './Dockerfile'.
        platform:
            The platform to build.
        build_args:
            Build arguments to use in the build.
        target:
            Target build stage to build.
        """
        _args = [
            Arg("dockerfile", dockerfile, None),
            Arg("platform", platform, None),
            Arg("buildArgs", build_args, None),
            Arg("target", target, None),
        ]
        _ctx = self._select("dockerBuild", _args)
        return Container(_ctx)

    @typecheck
    def entries(self, path: Optional[str] = None) -> list[str]:
        """Returns a list of files and directories at the given path.

        Parameters
        ----------
        path:
            Location of the directory to look at (e.g., "/src").

        Returns
        -------
        list[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args = [
            Arg("path", path, None),
        ]
        _ctx = self._select("entries", _args)
        return _ctx.execute_sync(list[str])

    @typecheck
    def export(self, path: str) -> bool:
        """Writes the contents of the directory to a path on the host.

        Parameters
        ----------
        path:
            Location of the copied directory (e.g., "logs/").

        Returns
        -------
        bool
            The `Boolean` scalar type represents `true` or `false`.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("export", _args)
        return _ctx.execute_sync(bool)

    @typecheck
    def file(self, path: str) -> "File":
        """Retrieves a file at the given path.

        Parameters
        ----------
        path:
            Location of the file to retrieve (e.g., "README.md").
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("file", _args)
        return File(_ctx)

    @typecheck
    def id(self) -> DirectoryID:
        """The content-addressed identifier of the directory.

        Note
        ----
        This is lazyly evaluated, no operation is actually run.

        Returns
        -------
        DirectoryID
            A content-addressed directory identifier.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("id", _args)
        return _ctx.execute_sync(DirectoryID)

    @typecheck
    def load_project(self, config_path: str) -> "Project":
        """load a project's metadata"""
        _args = [
            Arg("configPath", config_path),
        ]
        _ctx = self._select("loadProject", _args)
        return Project(_ctx)

    @typecheck
    def pipeline(
        self,
        name: str,
        description: Optional[str] = None,
    ) -> "Directory":
        """Creates a named sub-pipeline."""
        _args = [
            Arg("name", name),
            Arg("description", description, None),
        ]
        _ctx = self._select("pipeline", _args)
        return Directory(_ctx)

    @typecheck
    def with_directory(
        self,
        path: str,
        directory: "Directory",
        exclude: Optional[Sequence[str]] = None,
        include: Optional[Sequence[str]] = None,
    ) -> "Directory":
        """Retrieves this directory plus a directory written at the given path.

        Parameters
        ----------
        path:
            Location of the written directory (e.g., "/src/").
        directory:
            Identifier of the directory to copy.
        exclude:
            Exclude artifacts that match the given pattern (e.g.,
            ["node_modules/", ".git*"]).
        include:
            Include only artifacts that match the given pattern (e.g.,
            ["app/", "package.*"]).
        """
        _args = [
            Arg("path", path),
            Arg("directory", directory),
            Arg("exclude", exclude, None),
            Arg("include", include, None),
        ]
        _ctx = self._select("withDirectory", _args)
        return Directory(_ctx)

    @typecheck
    def with_file(
        self,
        path: str,
        source: "File",
        permissions: Optional[int] = None,
    ) -> "Directory":
        """Retrieves this directory plus the contents of the given file copied to
        the given path.

        Parameters
        ----------
        path:
            Location of the copied file (e.g., "/file.txt").
        source:
            Identifier of the file to copy.
        permissions:
            Permission given to the copied file (e.g., 0600).
            Default: 0644.
        """
        _args = [
            Arg("path", path),
            Arg("source", source),
            Arg("permissions", permissions, None),
        ]
        _ctx = self._select("withFile", _args)
        return Directory(_ctx)

    @typecheck
    def with_new_directory(
        self,
        path: str,
        permissions: Optional[int] = None,
    ) -> "Directory":
        """Retrieves this directory plus a new directory created at the given
        path.

        Parameters
        ----------
        path:
            Location of the directory created (e.g., "/logs").
        permissions:
            Permission granted to the created directory (e.g., 0777).
            Default: 0755.
        """
        _args = [
            Arg("path", path),
            Arg("permissions", permissions, None),
        ]
        _ctx = self._select("withNewDirectory", _args)
        return Directory(_ctx)

    @typecheck
    def with_new_file(
        self,
        path: str,
        contents: str,
        permissions: Optional[int] = None,
    ) -> "Directory":
        """Retrieves this directory plus a new file written at the given path.

        Parameters
        ----------
        path:
            Location of the written file (e.g., "/file.txt").
        contents:
            Content of the written file (e.g., "Hello world!").
        permissions:
            Permission given to the copied file (e.g., 0600).
            Default: 0644.
        """
        _args = [
            Arg("path", path),
            Arg("contents", contents),
            Arg("permissions", permissions, None),
        ]
        _ctx = self._select("withNewFile", _args)
        return Directory(_ctx)

    @typecheck
    def with_timestamps(self, timestamp: int) -> "Directory":
        """Retrieves this directory with all file/dir timestamps set to the given
        time.

        Parameters
        ----------
        timestamp:
            Timestamp to set dir/files in.
            Formatted in seconds following Unix epoch (e.g., 1672531199).
        """
        _args = [
            Arg("timestamp", timestamp),
        ]
        _ctx = self._select("withTimestamps", _args)
        return Directory(_ctx)

    @typecheck
    def without_directory(self, path: str) -> "Directory":
        """Retrieves this directory with the directory at the given path removed.

        Parameters
        ----------
        path:
            Location of the directory to remove (e.g., ".github/").
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("withoutDirectory", _args)
        return Directory(_ctx)

    @typecheck
    def without_file(self, path: str) -> "Directory":
        """Retrieves this directory with the file at the given path removed.

        Parameters
        ----------
        path:
            Location of the file to remove (e.g., "/file.txt").
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("withoutFile", _args)
        return Directory(_ctx)


class EnvVariable(Type):
    """A simple key value object that represents an environment
    variable."""

    @typecheck
    def name(self) -> str:
        """The environment variable name.

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("name", _args)
        return _ctx.execute_sync(str)

    @typecheck
    def value(self) -> str:
        """The environment variable value.

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("value", _args)
        return _ctx.execute_sync(str)


class File(Type):
    """A file."""

    @typecheck
    def contents(self) -> str:
        """Retrieves the contents of the file.

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("contents", _args)
        return _ctx.execute_sync(str)

    @typecheck
    def export(self, path: str) -> bool:
        """Writes the file to a file path on the host.

        Parameters
        ----------
        path:
            Location of the written directory (e.g., "output.txt").

        Returns
        -------
        bool
            The `Boolean` scalar type represents `true` or `false`.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("export", _args)
        return _ctx.execute_sync(bool)

    @typecheck
    def id(self) -> FileID:
        """Retrieves the content-addressed identifier of the file.

        Note
        ----
        This is lazyly evaluated, no operation is actually run.

        Returns
        -------
        FileID
            A file identifier.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("id", _args)
        return _ctx.execute_sync(FileID)

    @typecheck
    def secret(self) -> "Secret":
        """Retrieves a secret referencing the contents of this file."""
        _args: list[Arg] = []
        _ctx = self._select("secret", _args)
        return Secret(_ctx)

    @typecheck
    def size(self) -> int:
        """Gets the size of the file, in bytes.

        Returns
        -------
        int
            The `Int` scalar type represents non-fractional signed whole
            numeric values. Int can represent values between -(2^31) and 2^31
            - 1.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("size", _args)
        return _ctx.execute_sync(int)

    @typecheck
    def with_timestamps(self, timestamp: int) -> "File":
        """Retrieves this file with its created/modified timestamps set to the
        given time.

        Parameters
        ----------
        timestamp:
            Timestamp to set dir/files in.
            Formatted in seconds following Unix epoch (e.g., 1672531199).
        """
        _args = [
            Arg("timestamp", timestamp),
        ]
        _ctx = self._select("withTimestamps", _args)
        return File(_ctx)


class GitRef(Type):
    """A git ref (tag, branch or commit)."""

    @typecheck
    def digest(self) -> str:
        """The digest of the current value of this ref.

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("digest", _args)
        return _ctx.execute_sync(str)

    @typecheck
    def tree(
        self,
        ssh_known_hosts: Optional[str] = None,
        ssh_auth_socket: Optional["Socket"] = None,
    ) -> Directory:
        """The filesystem tree at this ref."""
        _args = [
            Arg("sshKnownHosts", ssh_known_hosts, None),
            Arg("sshAuthSocket", ssh_auth_socket, None),
        ]
        _ctx = self._select("tree", _args)
        return Directory(_ctx)


class GitRepository(Type):
    """A git repository."""

    @typecheck
    def branch(self, name: str) -> GitRef:
        """Returns details on one branch.

        Parameters
        ----------
        name:
            Branch's name (e.g., "main").
        """
        _args = [
            Arg("name", name),
        ]
        _ctx = self._select("branch", _args)
        return GitRef(_ctx)

    @typecheck
    def branches(self) -> list[str]:
        """Lists of branches on the repository.

        Returns
        -------
        list[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("branches", _args)
        return _ctx.execute_sync(list[str])

    @typecheck
    def commit(self, id: str) -> GitRef:
        """Returns details on one commit.

        Parameters
        ----------
        id:
            Identifier of the commit (e.g.,
            "b6315d8f2810962c601af73f86831f6866ea798b").
        """
        _args = [
            Arg("id", id),
        ]
        _ctx = self._select("commit", _args)
        return GitRef(_ctx)

    @typecheck
    def tag(self, name: str) -> GitRef:
        """Returns details on one tag.

        Parameters
        ----------
        name:
            Tag's name (e.g., "v0.3.9").
        """
        _args = [
            Arg("name", name),
        ]
        _ctx = self._select("tag", _args)
        return GitRef(_ctx)

    @typecheck
    def tags(self) -> list[str]:
        """Lists of tags on the repository.

        Returns
        -------
        list[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("tags", _args)
        return _ctx.execute_sync(list[str])


class Host(Type):
    """Information about the host execution environment."""

    @typecheck
    def directory(
        self,
        path: str,
        exclude: Optional[Sequence[str]] = None,
        include: Optional[Sequence[str]] = None,
    ) -> Directory:
        """Accesses a directory on the host.

        Parameters
        ----------
        path:
            Location of the directory to access (e.g., ".").
        exclude:
            Exclude artifacts that match the given pattern (e.g.,
            ["node_modules/", ".git*"]).
        include:
            Include only artifacts that match the given pattern (e.g.,
            ["app/", "package.*"]).
        """
        _args = [
            Arg("path", path),
            Arg("exclude", exclude, None),
            Arg("include", include, None),
        ]
        _ctx = self._select("directory", _args)
        return Directory(_ctx)

    @typecheck
    def env_variable(self, name: str) -> "HostVariable":
        """Accesses an environment variable on the host.

        Parameters
        ----------
        name:
            Name of the environment variable (e.g., "PATH").
        """
        _args = [
            Arg("name", name),
        ]
        _ctx = self._select("envVariable", _args)
        return HostVariable(_ctx)

    @typecheck
    def unix_socket(self, path: str) -> "Socket":
        """Accesses a Unix socket on the host.

        Parameters
        ----------
        path:
            Location of the Unix socket (e.g., "/var/run/docker.sock").
        """
        _args = [
            Arg("path", path),
        ]
        _ctx = self._select("unixSocket", _args)
        return Socket(_ctx)

    @typecheck
    def workdir(
        self,
        exclude: Optional[Sequence[str]] = None,
        include: Optional[Sequence[str]] = None,
    ) -> Directory:
        """Retrieves the current working directory on the host.

        .. deprecated::
            Use :py:meth:`directory` with path set to '.' instead.

        Parameters
        ----------
        exclude:
            Exclude artifacts that match the given pattern (e.g.,
            ["node_modules/", ".git*"]).
        include:
            Include only artifacts that match the given pattern (e.g.,
            ["app/", "package.*"]).
        """
        _args = [
            Arg("exclude", exclude, None),
            Arg("include", include, None),
        ]
        _ctx = self._select("workdir", _args)
        return Directory(_ctx)


class HostVariable(Type):
    """An environment variable on the host environment."""

    @typecheck
    def secret(self) -> "Secret":
        """A secret referencing the value of this variable."""
        _args: list[Arg] = []
        _ctx = self._select("secret", _args)
        return Secret(_ctx)

    @typecheck
    def value(self) -> str:
        """The value of this variable.

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("value", _args)
        return _ctx.execute_sync(str)


class Label(Type):
    """A simple key value object that represents a label."""

    @typecheck
    def name(self) -> str:
        """The label name.

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("name", _args)
        return _ctx.execute_sync(str)

    @typecheck
    def value(self) -> str:
        """The label value.

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("value", _args)
        return _ctx.execute_sync(str)


class Port(Type):
    """A port exposed by a container."""

    @typecheck
    def description(self) -> Optional[str]:
        """The port description.

        Returns
        -------
        Optional[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("description", _args)
        return _ctx.execute_sync(Optional[str])

    @typecheck
    def port(self) -> int:
        """The port number.

        Returns
        -------
        int
            The `Int` scalar type represents non-fractional signed whole
            numeric values. Int can represent values between -(2^31) and 2^31
            - 1.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("port", _args)
        return _ctx.execute_sync(int)

    @typecheck
    def protocol(self) -> NetworkProtocol:
        """The transport layer network protocol.

        Returns
        -------
        NetworkProtocol
            Transport layer network protocol associated to a port.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("protocol", _args)
        return _ctx.execute_sync(NetworkProtocol)


class Project(Type):
    """A set of scripts and/or extensions"""

    @typecheck
    def extensions(self) -> "Project":
        """extensions in this project"""
        _args: list[Arg] = []
        _ctx = self._select("extensions", _args)
        return Project(_ctx)

    @typecheck
    def generated_code(self) -> Directory:
        """Code files generated by the SDKs in the project"""
        _args: list[Arg] = []
        _ctx = self._select("generatedCode", _args)
        return Directory(_ctx)

    @typecheck
    def install(self) -> bool:
        """install the project's schema

        Returns
        -------
        bool
            The `Boolean` scalar type represents `true` or `false`.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("install", _args)
        return _ctx.execute_sync(bool)

    @typecheck
    def name(self) -> str:
        """name of the project

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("name", _args)
        return _ctx.execute_sync(str)

    @typecheck
    def schema(self) -> Optional[str]:
        """schema provided by the project

        Returns
        -------
        Optional[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("schema", _args)
        return _ctx.execute_sync(Optional[str])

    @typecheck
    def sdk(self) -> Optional[str]:
        """sdk used to generate code for and/or execute this project

        Returns
        -------
        Optional[str]
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("sdk", _args)
        return _ctx.execute_sync(Optional[str])


class Client(Root):
    @typecheck
    def cache_volume(self, key: str) -> CacheVolume:
        """Constructs a cache volume for a given cache key.

        Parameters
        ----------
        key:
            A string identifier to target this cache volume (e.g., "modules-
            cache").
        """
        _args = [
            Arg("key", key),
        ]
        _ctx = self._select("cacheVolume", _args)
        return CacheVolume(_ctx)

    @typecheck
    def container(
        self,
        id: Optional[ContainerID] = None,
        platform: Optional[Platform] = None,
    ) -> Container:
        """Loads a container from ID.



        Null ID returns an empty container (scratch).

        Optional platform argument initializes new containers to execute and
        publish as that platform.

        Platform defaults to that of the builder's host.
        """
        _args = [
            Arg("id", id, None),
            Arg("platform", platform, None),
        ]
        _ctx = self._select("container", _args)
        return Container(_ctx)

    @typecheck
    def default_platform(self) -> Platform:
        """The default platform of the builder.

        Returns
        -------
        Platform
            The platform config OS and architecture in a Container.  The
            format is [os]/[platform]/[version] (e.g., "darwin/arm64/v7",
            "windows/amd64", "linux/arm64").

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("defaultPlatform", _args)
        return _ctx.execute_sync(Platform)

    @typecheck
    def directory(self, id: Optional[DirectoryID] = None) -> Directory:
        """Load a directory by ID. No argument produces an empty directory."""
        _args = [
            Arg("id", id, None),
        ]
        _ctx = self._select("directory", _args)
        return Directory(_ctx)

    @typecheck
    def file(self, id: FileID) -> File:
        """Loads a file by ID."""
        _args = [
            Arg("id", id),
        ]
        _ctx = self._select("file", _args)
        return File(_ctx)

    @typecheck
    def git(
        self,
        url: str,
        keep_git_dir: Optional[bool] = None,
        experimental_service_host: Optional[Container] = None,
    ) -> GitRepository:
        """Queries a git repository.

        Parameters
        ----------
        url:
            Url of the git repository.
            Can be formatted as https://{host}/{owner}/{repo},
            git@{host}/{owner}/{repo}
            Suffix ".git" is optional.
        keep_git_dir:
            Set to true to keep .git directory.
        experimental_service_host:
            A service which must be started before the repo is fetched.
        """
        _args = [
            Arg("url", url),
            Arg("keepGitDir", keep_git_dir, None),
            Arg("experimentalServiceHost", experimental_service_host, None),
        ]
        _ctx = self._select("git", _args)
        return GitRepository(_ctx)

    @typecheck
    def host(self) -> Host:
        """Queries the host environment."""
        _args: list[Arg] = []
        _ctx = self._select("host", _args)
        return Host(_ctx)

    @typecheck
    def http(
        self,
        url: str,
        experimental_service_host: Optional[Container] = None,
    ) -> File:
        """Returns a file containing an http remote url content.

        Parameters
        ----------
        url:
            HTTP url to get the content from (e.g., "https://docs.dagger.io").
        experimental_service_host:
            A service which must be started before the URL is fetched.
        """
        _args = [
            Arg("url", url),
            Arg("experimentalServiceHost", experimental_service_host, None),
        ]
        _ctx = self._select("http", _args)
        return File(_ctx)

    @typecheck
    def pipeline(
        self,
        name: str,
        description: Optional[str] = None,
    ) -> "Client":
        """Creates a named sub-pipeline"""
        _args = [
            Arg("name", name),
            Arg("description", description, None),
        ]
        _ctx = self._select("pipeline", _args)
        return Client(_ctx)

    @typecheck
    def project(self, name: str) -> Project:
        """Look up a project by name"""
        _args = [
            Arg("name", name),
        ]
        _ctx = self._select("project", _args)
        return Project(_ctx)

    @typecheck
    def secret(self, id: SecretID) -> "Secret":
        """Loads a secret from its ID."""
        _args = [
            Arg("id", id),
        ]
        _ctx = self._select("secret", _args)
        return Secret(_ctx)

    @typecheck
    def socket(self, id: Optional[SocketID] = None) -> "Socket":
        """Loads a socket by its ID."""
        _args = [
            Arg("id", id, None),
        ]
        _ctx = self._select("socket", _args)
        return Socket(_ctx)


class Secret(Type):
    """A reference to a secret value, which can be handled more safely
    than the value itself."""

    @typecheck
    def id(self) -> SecretID:
        """The identifier for this secret.

        Note
        ----
        This is lazyly evaluated, no operation is actually run.

        Returns
        -------
        SecretID
            A unique identifier for a secret.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("id", _args)
        return _ctx.execute_sync(SecretID)

    @typecheck
    def plaintext(self) -> str:
        """The value of this secret.

        Returns
        -------
        str
            The `String` scalar type represents textual data, represented as
            UTF-8 character sequences. The String type is most often used by
            GraphQL to represent free-form human-readable text.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("plaintext", _args)
        return _ctx.execute_sync(str)


class Socket(Type):
    @typecheck
    def id(self) -> SocketID:
        """The content-addressed identifier of the socket.

        Note
        ----
        This is lazyly evaluated, no operation is actually run.

        Returns
        -------
        SocketID
            A content-addressed socket identifier.

        Raises
        ------
        ExecuteTimeoutError
            If the time to execute the query exceeds the configured timeout.
        QueryError
            If the API returns an error.
        """
        _args: list[Arg] = []
        _ctx = self._select("id", _args)
        return _ctx.execute_sync(SocketID)


__all__ = [
    "CacheID",
    "ContainerID",
    "DirectoryID",
    "FileID",
    "Platform",
    "SecretID",
    "SocketID",
    "CacheSharingMode",
    "NetworkProtocol",
    "BuildArg",
    "CacheVolume",
    "Container",
    "Directory",
    "EnvVariable",
    "File",
    "GitRef",
    "GitRepository",
    "Host",
    "HostVariable",
    "Label",
    "Port",
    "Project",
    "Client",
    "Secret",
    "Socket",
]
