#!/usr/bin/env python3

"""Document this method."""

from pygwin import Window, Frame, TextBoard


TITLE = 'text boards'.title()


def get_window(win_sys):
    """text boards window"""
    board = TextBoard(style={'size': (400, None)})
    board.push_text(
        """Text boards can be used to draw long texts that should
not exceed a specific width. Here the text board width has been set to 400
and the board has been put inside a 150-height frame."""
    )
    board.push_text(
        """Text boards and labels can contain
<color rgb="200,50,50">colored text</color>. You can do this by putting color
tags in your text.  For instance, this has been generated by the following
code:"""
    )
    board.push_text(
        """&lt;color rgb="200,50,50"&gt;colored
text&lt;/color&gt;."""
    )
    frame = Frame(board, style={'expand': True, 'size': (None, 150)})
    return Window(win_sys, frame, title=TITLE)
