from enum import Enum, auto


class DataLevel(Enum):
    """Enum of the different Data Levels"""

    #: Raw data in camera or simulation format
    R0 = auto()
    #: Raw data in common format, with preliminary calibration
    R1 = auto()
    #: raw archived data in common format, with optional zero suppression
    DL0 = auto()
    #: processed data
    DL1 = auto()
    #: processed data up to camera images
    DL1_IMAGES = auto()
    #: parameters derived from camera images
    DL1_PARAMETERS = auto()

    #: reconstructed data
    DL2 = auto()
    #: reduced reconstructed data with IRFs
    DL3 = auto()

    # the rest are not generated by ctapipe, but are listed here in case this
    # code is used elsewhere:
    #: binned  datasets
    DL4 = auto()
    #: science datasets (fluxes)
    DL5 = auto()
    #: derived science data (catalogs, etc.)
    DL6 = auto()

    #: muon-related image parameters
    DL1_MUON = auto()
