# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertChannelArgs', 'AlertChannel']

@pulumi.input_type
class AlertChannelArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input['AlertChannelEmailArgs']] = None,
                 opsgenie: Optional[pulumi.Input['AlertChannelOpsgenieArgs']] = None,
                 pagerduty: Optional[pulumi.Input['AlertChannelPagerdutyArgs']] = None,
                 send_degraded: Optional[pulumi.Input[bool]] = None,
                 send_failure: Optional[pulumi.Input[bool]] = None,
                 send_recovery: Optional[pulumi.Input[bool]] = None,
                 slack: Optional[pulumi.Input['AlertChannelSlackArgs']] = None,
                 sms: Optional[pulumi.Input['AlertChannelSmsArgs']] = None,
                 ssl_expiry: Optional[pulumi.Input[bool]] = None,
                 ssl_expiry_threshold: Optional[pulumi.Input[int]] = None,
                 webhook: Optional[pulumi.Input['AlertChannelWebhookArgs']] = None):
        """
        The set of arguments for constructing a AlertChannel resource.
        :param pulumi.Input[bool] send_degraded: (Default `false`)
        :param pulumi.Input[bool] send_failure: (Default `true`)
        :param pulumi.Input[bool] send_recovery: (Default `true`)
        :param pulumi.Input[bool] ssl_expiry: (Default `false`)
        :param pulumi.Input[int] ssl_expiry_threshold: Value must be between 1 and 30 (Default `30`)
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if opsgenie is not None:
            pulumi.set(__self__, "opsgenie", opsgenie)
        if pagerduty is not None:
            pulumi.set(__self__, "pagerduty", pagerduty)
        if send_degraded is not None:
            pulumi.set(__self__, "send_degraded", send_degraded)
        if send_failure is not None:
            pulumi.set(__self__, "send_failure", send_failure)
        if send_recovery is not None:
            pulumi.set(__self__, "send_recovery", send_recovery)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if sms is not None:
            pulumi.set(__self__, "sms", sms)
        if ssl_expiry is not None:
            pulumi.set(__self__, "ssl_expiry", ssl_expiry)
        if ssl_expiry_threshold is not None:
            pulumi.set(__self__, "ssl_expiry_threshold", ssl_expiry_threshold)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input['AlertChannelEmailArgs']]:
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input['AlertChannelEmailArgs']]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def opsgenie(self) -> Optional[pulumi.Input['AlertChannelOpsgenieArgs']]:
        return pulumi.get(self, "opsgenie")

    @opsgenie.setter
    def opsgenie(self, value: Optional[pulumi.Input['AlertChannelOpsgenieArgs']]):
        pulumi.set(self, "opsgenie", value)

    @property
    @pulumi.getter
    def pagerduty(self) -> Optional[pulumi.Input['AlertChannelPagerdutyArgs']]:
        return pulumi.get(self, "pagerduty")

    @pagerduty.setter
    def pagerduty(self, value: Optional[pulumi.Input['AlertChannelPagerdutyArgs']]):
        pulumi.set(self, "pagerduty", value)

    @property
    @pulumi.getter(name="sendDegraded")
    def send_degraded(self) -> Optional[pulumi.Input[bool]]:
        """
        (Default `false`)
        """
        return pulumi.get(self, "send_degraded")

    @send_degraded.setter
    def send_degraded(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_degraded", value)

    @property
    @pulumi.getter(name="sendFailure")
    def send_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        (Default `true`)
        """
        return pulumi.get(self, "send_failure")

    @send_failure.setter
    def send_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_failure", value)

    @property
    @pulumi.getter(name="sendRecovery")
    def send_recovery(self) -> Optional[pulumi.Input[bool]]:
        """
        (Default `true`)
        """
        return pulumi.get(self, "send_recovery")

    @send_recovery.setter
    def send_recovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_recovery", value)

    @property
    @pulumi.getter
    def slack(self) -> Optional[pulumi.Input['AlertChannelSlackArgs']]:
        return pulumi.get(self, "slack")

    @slack.setter
    def slack(self, value: Optional[pulumi.Input['AlertChannelSlackArgs']]):
        pulumi.set(self, "slack", value)

    @property
    @pulumi.getter
    def sms(self) -> Optional[pulumi.Input['AlertChannelSmsArgs']]:
        return pulumi.get(self, "sms")

    @sms.setter
    def sms(self, value: Optional[pulumi.Input['AlertChannelSmsArgs']]):
        pulumi.set(self, "sms", value)

    @property
    @pulumi.getter(name="sslExpiry")
    def ssl_expiry(self) -> Optional[pulumi.Input[bool]]:
        """
        (Default `false`)
        """
        return pulumi.get(self, "ssl_expiry")

    @ssl_expiry.setter
    def ssl_expiry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_expiry", value)

    @property
    @pulumi.getter(name="sslExpiryThreshold")
    def ssl_expiry_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Value must be between 1 and 30 (Default `30`)
        """
        return pulumi.get(self, "ssl_expiry_threshold")

    @ssl_expiry_threshold.setter
    def ssl_expiry_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssl_expiry_threshold", value)

    @property
    @pulumi.getter
    def webhook(self) -> Optional[pulumi.Input['AlertChannelWebhookArgs']]:
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: Optional[pulumi.Input['AlertChannelWebhookArgs']]):
        pulumi.set(self, "webhook", value)


@pulumi.input_type
class _AlertChannelState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input['AlertChannelEmailArgs']] = None,
                 opsgenie: Optional[pulumi.Input['AlertChannelOpsgenieArgs']] = None,
                 pagerduty: Optional[pulumi.Input['AlertChannelPagerdutyArgs']] = None,
                 send_degraded: Optional[pulumi.Input[bool]] = None,
                 send_failure: Optional[pulumi.Input[bool]] = None,
                 send_recovery: Optional[pulumi.Input[bool]] = None,
                 slack: Optional[pulumi.Input['AlertChannelSlackArgs']] = None,
                 sms: Optional[pulumi.Input['AlertChannelSmsArgs']] = None,
                 ssl_expiry: Optional[pulumi.Input[bool]] = None,
                 ssl_expiry_threshold: Optional[pulumi.Input[int]] = None,
                 webhook: Optional[pulumi.Input['AlertChannelWebhookArgs']] = None):
        """
        Input properties used for looking up and filtering AlertChannel resources.
        :param pulumi.Input[bool] send_degraded: (Default `false`)
        :param pulumi.Input[bool] send_failure: (Default `true`)
        :param pulumi.Input[bool] send_recovery: (Default `true`)
        :param pulumi.Input[bool] ssl_expiry: (Default `false`)
        :param pulumi.Input[int] ssl_expiry_threshold: Value must be between 1 and 30 (Default `30`)
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if opsgenie is not None:
            pulumi.set(__self__, "opsgenie", opsgenie)
        if pagerduty is not None:
            pulumi.set(__self__, "pagerduty", pagerduty)
        if send_degraded is not None:
            pulumi.set(__self__, "send_degraded", send_degraded)
        if send_failure is not None:
            pulumi.set(__self__, "send_failure", send_failure)
        if send_recovery is not None:
            pulumi.set(__self__, "send_recovery", send_recovery)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if sms is not None:
            pulumi.set(__self__, "sms", sms)
        if ssl_expiry is not None:
            pulumi.set(__self__, "ssl_expiry", ssl_expiry)
        if ssl_expiry_threshold is not None:
            pulumi.set(__self__, "ssl_expiry_threshold", ssl_expiry_threshold)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input['AlertChannelEmailArgs']]:
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input['AlertChannelEmailArgs']]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def opsgenie(self) -> Optional[pulumi.Input['AlertChannelOpsgenieArgs']]:
        return pulumi.get(self, "opsgenie")

    @opsgenie.setter
    def opsgenie(self, value: Optional[pulumi.Input['AlertChannelOpsgenieArgs']]):
        pulumi.set(self, "opsgenie", value)

    @property
    @pulumi.getter
    def pagerduty(self) -> Optional[pulumi.Input['AlertChannelPagerdutyArgs']]:
        return pulumi.get(self, "pagerduty")

    @pagerduty.setter
    def pagerduty(self, value: Optional[pulumi.Input['AlertChannelPagerdutyArgs']]):
        pulumi.set(self, "pagerduty", value)

    @property
    @pulumi.getter(name="sendDegraded")
    def send_degraded(self) -> Optional[pulumi.Input[bool]]:
        """
        (Default `false`)
        """
        return pulumi.get(self, "send_degraded")

    @send_degraded.setter
    def send_degraded(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_degraded", value)

    @property
    @pulumi.getter(name="sendFailure")
    def send_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        (Default `true`)
        """
        return pulumi.get(self, "send_failure")

    @send_failure.setter
    def send_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_failure", value)

    @property
    @pulumi.getter(name="sendRecovery")
    def send_recovery(self) -> Optional[pulumi.Input[bool]]:
        """
        (Default `true`)
        """
        return pulumi.get(self, "send_recovery")

    @send_recovery.setter
    def send_recovery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_recovery", value)

    @property
    @pulumi.getter
    def slack(self) -> Optional[pulumi.Input['AlertChannelSlackArgs']]:
        return pulumi.get(self, "slack")

    @slack.setter
    def slack(self, value: Optional[pulumi.Input['AlertChannelSlackArgs']]):
        pulumi.set(self, "slack", value)

    @property
    @pulumi.getter
    def sms(self) -> Optional[pulumi.Input['AlertChannelSmsArgs']]:
        return pulumi.get(self, "sms")

    @sms.setter
    def sms(self, value: Optional[pulumi.Input['AlertChannelSmsArgs']]):
        pulumi.set(self, "sms", value)

    @property
    @pulumi.getter(name="sslExpiry")
    def ssl_expiry(self) -> Optional[pulumi.Input[bool]]:
        """
        (Default `false`)
        """
        return pulumi.get(self, "ssl_expiry")

    @ssl_expiry.setter
    def ssl_expiry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_expiry", value)

    @property
    @pulumi.getter(name="sslExpiryThreshold")
    def ssl_expiry_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Value must be between 1 and 30 (Default `30`)
        """
        return pulumi.get(self, "ssl_expiry_threshold")

    @ssl_expiry_threshold.setter
    def ssl_expiry_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssl_expiry_threshold", value)

    @property
    @pulumi.getter
    def webhook(self) -> Optional[pulumi.Input['AlertChannelWebhookArgs']]:
        return pulumi.get(self, "webhook")

    @webhook.setter
    def webhook(self, value: Optional[pulumi.Input['AlertChannelWebhookArgs']]):
        pulumi.set(self, "webhook", value)


class AlertChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[pulumi.InputType['AlertChannelEmailArgs']]] = None,
                 opsgenie: Optional[pulumi.Input[pulumi.InputType['AlertChannelOpsgenieArgs']]] = None,
                 pagerduty: Optional[pulumi.Input[pulumi.InputType['AlertChannelPagerdutyArgs']]] = None,
                 send_degraded: Optional[pulumi.Input[bool]] = None,
                 send_failure: Optional[pulumi.Input[bool]] = None,
                 send_recovery: Optional[pulumi.Input[bool]] = None,
                 slack: Optional[pulumi.Input[pulumi.InputType['AlertChannelSlackArgs']]] = None,
                 sms: Optional[pulumi.Input[pulumi.InputType['AlertChannelSmsArgs']]] = None,
                 ssl_expiry: Optional[pulumi.Input[bool]] = None,
                 ssl_expiry_threshold: Optional[pulumi.Input[int]] = None,
                 webhook: Optional[pulumi.Input[pulumi.InputType['AlertChannelWebhookArgs']]] = None,
                 __props__=None):
        """
        Allows you to define alerting channels for the checks and groups in your account

        ## Example Usage

        ```python
        import pulumi
        import pulumi_checkly as checkly

        # An Email alert channel
        email_ac = checkly.AlertChannel("emailAc",
            email=checkly.AlertChannelEmailArgs(
                address="john@example.com",
            ),
            send_recovery=True,
            send_failure=False,
            send_degraded=True,
            ssl_expiry=True,
            ssl_expiry_threshold=22)
        # A SMS alert channel
        sms_ac = checkly.AlertChannel("smsAc",
            sms=checkly.AlertChannelSmsArgs(
                name="john",
                number="+5491100001111",
            ),
            send_recovery=True,
            send_failure=True)
        # A Slack alert channel
        slack_ac = checkly.AlertChannel("slackAc", slack=checkly.AlertChannelSlackArgs(
            channel="#checkly-notifications",
            url="https://hooks.slack.com/services/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",
        ))
        # An Opsgenie alert channel
        opsgenie_ac = checkly.AlertChannel("opsgenieAc", opsgenie=checkly.AlertChannelOpsgenieArgs(
            name="opsalerts",
            api_key="fookey",
            region="fooregion",
            priority="foopriority",
        ))
        # An Pagerduty alert channel
        pagerduty_ac = checkly.AlertChannel("pagerdutyAc", pagerduty=checkly.AlertChannelPagerdutyArgs(
            account="checkly",
            service_key="key1",
            service_name="pdalert",
        ))
        # An Webhook alert channel
        webhook_ac = checkly.AlertChannel("webhookAc", webhook=checkly.AlertChannelWebhookArgs(
            name="foo",
            method="get",
            template="footemplate",
            url="https://example.com/foo",
            webhook_secret="foosecret",
        ))
        # Connecting the alert channel to a check
        example_check = checkly.Check("exampleCheck", alert_channel_subscriptions=[
            checkly.CheckAlertChannelSubscriptionArgs(
                channel_id=email_ac.id,
                activated=True,
            ),
            checkly.CheckAlertChannelSubscriptionArgs(
                channel_id=sms_ac.id,
                activated=True,
            ),
        ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] send_degraded: (Default `false`)
        :param pulumi.Input[bool] send_failure: (Default `true`)
        :param pulumi.Input[bool] send_recovery: (Default `true`)
        :param pulumi.Input[bool] ssl_expiry: (Default `false`)
        :param pulumi.Input[int] ssl_expiry_threshold: Value must be between 1 and 30 (Default `30`)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AlertChannelArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows you to define alerting channels for the checks and groups in your account

        ## Example Usage

        ```python
        import pulumi
        import pulumi_checkly as checkly

        # An Email alert channel
        email_ac = checkly.AlertChannel("emailAc",
            email=checkly.AlertChannelEmailArgs(
                address="john@example.com",
            ),
            send_recovery=True,
            send_failure=False,
            send_degraded=True,
            ssl_expiry=True,
            ssl_expiry_threshold=22)
        # A SMS alert channel
        sms_ac = checkly.AlertChannel("smsAc",
            sms=checkly.AlertChannelSmsArgs(
                name="john",
                number="+5491100001111",
            ),
            send_recovery=True,
            send_failure=True)
        # A Slack alert channel
        slack_ac = checkly.AlertChannel("slackAc", slack=checkly.AlertChannelSlackArgs(
            channel="#checkly-notifications",
            url="https://hooks.slack.com/services/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",
        ))
        # An Opsgenie alert channel
        opsgenie_ac = checkly.AlertChannel("opsgenieAc", opsgenie=checkly.AlertChannelOpsgenieArgs(
            name="opsalerts",
            api_key="fookey",
            region="fooregion",
            priority="foopriority",
        ))
        # An Pagerduty alert channel
        pagerduty_ac = checkly.AlertChannel("pagerdutyAc", pagerduty=checkly.AlertChannelPagerdutyArgs(
            account="checkly",
            service_key="key1",
            service_name="pdalert",
        ))
        # An Webhook alert channel
        webhook_ac = checkly.AlertChannel("webhookAc", webhook=checkly.AlertChannelWebhookArgs(
            name="foo",
            method="get",
            template="footemplate",
            url="https://example.com/foo",
            webhook_secret="foosecret",
        ))
        # Connecting the alert channel to a check
        example_check = checkly.Check("exampleCheck", alert_channel_subscriptions=[
            checkly.CheckAlertChannelSubscriptionArgs(
                channel_id=email_ac.id,
                activated=True,
            ),
            checkly.CheckAlertChannelSubscriptionArgs(
                channel_id=sms_ac.id,
                activated=True,
            ),
        ])
        ```

        :param str resource_name: The name of the resource.
        :param AlertChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[pulumi.InputType['AlertChannelEmailArgs']]] = None,
                 opsgenie: Optional[pulumi.Input[pulumi.InputType['AlertChannelOpsgenieArgs']]] = None,
                 pagerduty: Optional[pulumi.Input[pulumi.InputType['AlertChannelPagerdutyArgs']]] = None,
                 send_degraded: Optional[pulumi.Input[bool]] = None,
                 send_failure: Optional[pulumi.Input[bool]] = None,
                 send_recovery: Optional[pulumi.Input[bool]] = None,
                 slack: Optional[pulumi.Input[pulumi.InputType['AlertChannelSlackArgs']]] = None,
                 sms: Optional[pulumi.Input[pulumi.InputType['AlertChannelSmsArgs']]] = None,
                 ssl_expiry: Optional[pulumi.Input[bool]] = None,
                 ssl_expiry_threshold: Optional[pulumi.Input[int]] = None,
                 webhook: Optional[pulumi.Input[pulumi.InputType['AlertChannelWebhookArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertChannelArgs.__new__(AlertChannelArgs)

            __props__.__dict__["email"] = email
            __props__.__dict__["opsgenie"] = opsgenie
            __props__.__dict__["pagerduty"] = pagerduty
            __props__.__dict__["send_degraded"] = send_degraded
            __props__.__dict__["send_failure"] = send_failure
            __props__.__dict__["send_recovery"] = send_recovery
            __props__.__dict__["slack"] = slack
            __props__.__dict__["sms"] = sms
            __props__.__dict__["ssl_expiry"] = ssl_expiry
            __props__.__dict__["ssl_expiry_threshold"] = ssl_expiry_threshold
            __props__.__dict__["webhook"] = webhook
        super(AlertChannel, __self__).__init__(
            'checkly:index/alertChannel:AlertChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[pulumi.InputType['AlertChannelEmailArgs']]] = None,
            opsgenie: Optional[pulumi.Input[pulumi.InputType['AlertChannelOpsgenieArgs']]] = None,
            pagerduty: Optional[pulumi.Input[pulumi.InputType['AlertChannelPagerdutyArgs']]] = None,
            send_degraded: Optional[pulumi.Input[bool]] = None,
            send_failure: Optional[pulumi.Input[bool]] = None,
            send_recovery: Optional[pulumi.Input[bool]] = None,
            slack: Optional[pulumi.Input[pulumi.InputType['AlertChannelSlackArgs']]] = None,
            sms: Optional[pulumi.Input[pulumi.InputType['AlertChannelSmsArgs']]] = None,
            ssl_expiry: Optional[pulumi.Input[bool]] = None,
            ssl_expiry_threshold: Optional[pulumi.Input[int]] = None,
            webhook: Optional[pulumi.Input[pulumi.InputType['AlertChannelWebhookArgs']]] = None) -> 'AlertChannel':
        """
        Get an existing AlertChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] send_degraded: (Default `false`)
        :param pulumi.Input[bool] send_failure: (Default `true`)
        :param pulumi.Input[bool] send_recovery: (Default `true`)
        :param pulumi.Input[bool] ssl_expiry: (Default `false`)
        :param pulumi.Input[int] ssl_expiry_threshold: Value must be between 1 and 30 (Default `30`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertChannelState.__new__(_AlertChannelState)

        __props__.__dict__["email"] = email
        __props__.__dict__["opsgenie"] = opsgenie
        __props__.__dict__["pagerduty"] = pagerduty
        __props__.__dict__["send_degraded"] = send_degraded
        __props__.__dict__["send_failure"] = send_failure
        __props__.__dict__["send_recovery"] = send_recovery
        __props__.__dict__["slack"] = slack
        __props__.__dict__["sms"] = sms
        __props__.__dict__["ssl_expiry"] = ssl_expiry
        __props__.__dict__["ssl_expiry_threshold"] = ssl_expiry_threshold
        __props__.__dict__["webhook"] = webhook
        return AlertChannel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional['outputs.AlertChannelEmail']]:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def opsgenie(self) -> pulumi.Output[Optional['outputs.AlertChannelOpsgenie']]:
        return pulumi.get(self, "opsgenie")

    @property
    @pulumi.getter
    def pagerduty(self) -> pulumi.Output[Optional['outputs.AlertChannelPagerduty']]:
        return pulumi.get(self, "pagerduty")

    @property
    @pulumi.getter(name="sendDegraded")
    def send_degraded(self) -> pulumi.Output[Optional[bool]]:
        """
        (Default `false`)
        """
        return pulumi.get(self, "send_degraded")

    @property
    @pulumi.getter(name="sendFailure")
    def send_failure(self) -> pulumi.Output[Optional[bool]]:
        """
        (Default `true`)
        """
        return pulumi.get(self, "send_failure")

    @property
    @pulumi.getter(name="sendRecovery")
    def send_recovery(self) -> pulumi.Output[Optional[bool]]:
        """
        (Default `true`)
        """
        return pulumi.get(self, "send_recovery")

    @property
    @pulumi.getter
    def slack(self) -> pulumi.Output[Optional['outputs.AlertChannelSlack']]:
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def sms(self) -> pulumi.Output[Optional['outputs.AlertChannelSms']]:
        return pulumi.get(self, "sms")

    @property
    @pulumi.getter(name="sslExpiry")
    def ssl_expiry(self) -> pulumi.Output[Optional[bool]]:
        """
        (Default `false`)
        """
        return pulumi.get(self, "ssl_expiry")

    @property
    @pulumi.getter(name="sslExpiryThreshold")
    def ssl_expiry_threshold(self) -> pulumi.Output[Optional[int]]:
        """
        Value must be between 1 and 30 (Default `30`)
        """
        return pulumi.get(self, "ssl_expiry_threshold")

    @property
    @pulumi.getter
    def webhook(self) -> pulumi.Output[Optional['outputs.AlertChannelWebhook']]:
        return pulumi.get(self, "webhook")

