# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['evernote_backup']

package_data = \
{'': ['*']}

install_requires = \
['click-option-group>=0.5.3,<0.6.0',
 'click>=8.0.1,<9.0.0',
 'evernote3>=1.25.14,<2.0.0',
 'oauth2>=1.9.0,<2.0.0',
 'xmltodict>=0.12.0,<0.13.0']

entry_points = \
{'console_scripts': ['evernote-backup = evernote_backup.cli:main']}

setup_kwargs = {
    'name': 'evernote-backup',
    'version': '1.6.2',
    'description': 'Backup & export all Evernote notes and notebooks.',
    'long_description': '# evernote-backup\n\n[![PyPI version](https://img.shields.io/pypi/v/evernote-backup?label=version)](https://pypi.python.org/pypi/evernote-backup)\n[![Python Version](https://img.shields.io/pypi/pyversions/evernote-backup.svg)](https://pypi.org/project/evernote-backup/)\n[![tests](https://github.com/vzhd1701/evernote-backup/actions/workflows/test.yml/badge.svg)](https://github.com/vzhd1701/evernote-backup/actions/workflows/test.yml)\n[![codecov](https://codecov.io/gh/vzhd1701/evernote-backup/branch/master/graph/badge.svg)](https://codecov.io/gh/vzhd1701/evernote-backup)\n\nBackup your notes & notebooks from Evernote locally and export them at any time!\n\n## Features\n\n- Quickly sync all your notes into the SQLite database for backup.\n- Export all backed up notes in `*.enex` format, as **notebooks** or **single notes**.\n- Support for both [Evernote](https://evernote.com/) and [Yinxiang (印象笔记)](https://yinxiang.com/).\n\n## Installation\n\n[**Download the latest release**](https://github.com/vzhd1701/evernote-backup/releases/latest) for your OS.\n\n### With PIP\n\n```bash\n$ pip install evernote-backup\n```\n\nOr, since **evernote-backup** is a standalone tool, it might be more convenient to install it using [**pipx**](https://github.com/pipxproject/pipx):\n\n```bash\n$ pipx install evernote-backup\n```\n\n### With Docker\n\n```bash\n$ docker run --rm -t -v "$PWD":/tmp ghcr.io/vzhd1701/evernote-backup:latest\n```\n\nTo log in to Evernote using OAuth with Docker, you\'ll have to forward port 10500 for a callback:\n\n```bash\n$ docker run --rm -t -v "$PWD":/tmp -p 10500:10500 ghcr.io/vzhd1701/evernote-backup:latest init-db --oauth\n```\n\n## Usage\n\n### Step 1. Database initialization\n\nTo start you need to initialize your database.\n\n```console\n$ evernote-backup init-db\nUsername or Email: user@example.com\nPassword:\nLogging in to Evernote...\nEnter one-time code: 120917\nAuthorizing auth token, evernote backend...\nSuccessfully authenticated as user!\nCurrent login will expire at 2022-03-10 10:22:00.\nInitializing database en_backup.db...\nReading database en_backup.db...\nSuccessfully initialized database for user!\n```\n\nBy default, it will prompt you to enter your account credentials. You can provide them beforehand with `--user` and `--password` options.\n\nIf you log in to Evernote with Google or Apple accounts, you must use the `--oauth` option.\n\nTo connect to **Yinxiang** instead of Evernote, use `--backend china` option. Unfortunately, OAuth is not supported for **Yinxiang** yet.\n\n### Step 2. Downloading Evernote data\n\nThen you will be able to sync your account data.\n\n```console\n$ evernote-backup sync\nReading database en_backup.db...\nAuthorizing auth token, evernote backend...\nSuccessfully authenticated as user!\nCurrent login will expire at 2022-03-10 10:22:00.\nSyncing latest changes...\n  [####################################]  6763/6763\n566 notes to download...\n  [####################################]  566/566\nUpdated or added notebooks: 23\nUpdated or added notes: 566\nExpunged notebooks: 0\nExpunged notes: 0\nSynchronization completed!\n```\n\nYou can interrupt this process at any point. It will continue from where it\'s left off when you will rerun `evernote-backup sync`.\n\n**evernote-backup** keeps track of the sync state and downloads only new changes that have been made since the last run. So every sync will go pretty fast, but you\'ll have to wait for a bit on the first run if you have a lot of notes in your account.\n\n### Step 3. Exporting `*.enex` files\n\nFinally, you can export your data into specified **output directory**\n\n```console\n$ evernote-backup export output_dir/\nReading database en_backup.db...\nExporting notes...\n  [####################################]  23/23\nAll notes have been exported!\n```\n\nBy default, **evernote-backup** will export notes by packing them into notebooks, one `*.enex` file each. If you want to extract notes as **separate files**, use the `--single-notes` flag.\n\nTo also include **trashed** notes in export, use the `--include-trash` flag.\n\nThat\'s it! So to export all your Evernote data, you will have to run three commands:\n\n```console\n$ evernote-backup init-db\n$ evernote-backup sync\n$ evernote-backup export output_dir/\n```\n\nAfter first initialization, you can schedule `evernote-backup sync` command to keep your local database always up-to-date.\n\n### How to refresh expired token\n\nIn case your auth token that you initialized your database with expires, you have an option to re-authorize it by running the `evernote-backup reauth` command. It has the same options as the `init-db` command.\n\n## Dependencies\n\n- [evernote3](https://github.com/evernote/evernote-sdk-python3) - to access Evernote API\n- [oauth2](https://github.com/joestump/python-oauth2) - to perform OAuth authentication\n- [xmltodict](https://github.com/martinblech/xmltodict) - to convert Evernote internal representation of notes into XML\n- [click](https://github.com/pallets/click) - to create a CLI interface\n- [click-option-group](https://github.com/click-contrib/click-option-group) - to add mutually exclusive options in сlick\n\n## Alternative tools\n\n**evernote-backup** is basically a clone of Evernote\'s original **ENScript** but simplified and stripped of its other functions. If you prefer to export your notes using Evernote\'s original tool, then you will need to take hold of [Evernote\'s legacy client](https://help.evernote.com/hc/en-us/articles/360052560314-Install-an-older-version-of-Evernote) and run the following commands:\n\n```console\nENScript.exe syncDatabase /d backup.ebx /u your@email.com /p your_password\nENScript.exe exportDatabase /d backup.ebx /f output_dir\n```\n\n### Further reading\n\n- [How to export Notebooks in new Evernote client](https://help.evernote.com/hc/en-us/articles/360053159414-Export-notebooks)\n- [Backing up and restoring Evernote data (Reference article) (requires registration)](https://discussion.evernote.com/forums/topic/86152-backing-up-and-restoring-evernote-data-reference-article/?tab=comments#comment-367110)\n- [Migrating Your Notes from Evernote to Obsidian](https://www.dmuth.org/migrating-from-evernote-to-obisidian/)\n- https://github.com/davidedc/A-thousand-notes\n\n## Similar projects\n\nI\'ve also combined a [bigger list](https://github.com/vzhd1701/evernote-backup/blob/master/SIMILAR_PROJECTS.md) where I included all adjacent projects that I could find.\n\n### Export\n\nProject                                                                |  Description                                                                                                      |  Language    |  Stars  |  Last commit\n-----------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|--------------|---------|-------------\n[ExportAllEverNote](https://github.com/dong-s/ExportAllEverNote)       |  Export notes in ENEX format driectly from your account                                                           |  Python      |  13     |  2020\n[evernote2](https://github.com/JackonYang/evernote2)                   |  Improved version of standard Evernote SDK. Also provides a tool for exporting notes driectly from your account  |  Python      |  1      |  2020\n[evernote-to-sqlite](https://github.com/dogsheep/evernote-to-sqlite)   |  Converts ENEX files into SQLite database                                                                         |  Python      |  20     |  2021\n[enote](https://github.com/tkjacobsen/enote)                           |  Utility that can backup Evernote notes and notebooks                                                             |  Python      |  12     |  2017\n[evernote-exporter](https://github.com/shawndaniel/evernote-exporter)  |  Export notes from old Evernote local database .exb format                                                        |  Python      |  28     |  2016\n\n### Export / Sync\n\nProject                                                                |  Description                                                                                                      |  Language    |  Stars  |  Last commit\n-----------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|--------------|---------|-------------\n[SyncToGit](https://github.com/KostyaEsmukov/SyncToGit)                |  Syncs your notes with their resources to the git repository in HTML format                                       |  Python      |  3      |  2020\n[evermark](https://github.com/akuma/evermark)                          |  A command line tool for syncing markdown notes to Evernote                                                       |  JavaScript  |  72     |  2018\n[eversync](https://github.com/yejianye/eversync)                       |  Sync your local directories with evernote notebooks                                                              |  Python      |  44     |  2017\n[EverMark](https://github.com/liuwons/EverMark)                        |  A tool that can sync local markdown/text notes to Evernote                                                       |  Python      |  50     |  2016\n[LocalEvernote](https://github.com/lwabish/LocalEvernote)              |  Syncs local directory containing notes in Markdown format with Evernote                                          |  Python      |  0      |  2021\n',
    'author': 'vzhd1701',
    'author_email': 'vzhd1701@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/vzhd1701/evernote-backup',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
