"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    "does not create a parameter group if it wasn't bound to a cluster or instance"(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new lib_1.ParameterGroup(stack, 'Params', {
            engine: lib_1.DatabaseClusterEngine.AURORA,
            description: 'desc',
            parameters: {
                key: 'value',
            },
        });
        // THEN
        assert_1.expect(stack).to(assert_1.countResources('AWS::RDS::DBParameterGroup', 0));
        assert_1.expect(stack).to(assert_1.countResources('AWS::RDS::DBClusterParameterGroup', 0));
        test.done();
    },
    'create a parameter group when bound to an instance'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const parameterGroup = new lib_1.ParameterGroup(stack, 'Params', {
            engine: lib_1.DatabaseClusterEngine.AURORA,
            description: 'desc',
            parameters: {
                key: 'value',
            },
        });
        parameterGroup.bindToInstance({});
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::RDS::DBParameterGroup', {
            Description: 'desc',
            Family: 'aurora5.6',
            Parameters: {
                key: 'value',
            },
        }));
        test.done();
    },
    'create a parameter group when bound to a cluster'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const parameterGroup = new lib_1.ParameterGroup(stack, 'Params', {
            engine: lib_1.DatabaseClusterEngine.AURORA,
            description: 'desc',
            parameters: {
                key: 'value',
            },
        });
        parameterGroup.bindToCluster({});
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::RDS::DBClusterParameterGroup', {
            Description: 'desc',
            Family: 'aurora5.6',
            Parameters: {
                key: 'value',
            },
        }));
        test.done();
    },
    'creates 2 parameter groups when bound to a cluster and an instance'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const parameterGroup = new lib_1.ParameterGroup(stack, 'Params', {
            engine: lib_1.DatabaseClusterEngine.AURORA,
            description: 'desc',
            parameters: {
                key: 'value',
            },
        });
        parameterGroup.bindToCluster({});
        parameterGroup.bindToInstance({});
        // THEN
        assert_1.expect(stack).to(assert_1.countResources('AWS::RDS::DBParameterGroup', 1));
        assert_1.expect(stack).to(assert_1.countResources('AWS::RDS::DBClusterParameterGroup', 1));
        test.done();
    },
    'Add an additional parameter to an existing parameter group'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const clusterParameterGroup = new lib_1.ParameterGroup(stack, 'Params', {
            engine: lib_1.DatabaseClusterEngine.AURORA,
            description: 'desc',
            parameters: {
                key1: 'value1',
            },
        });
        clusterParameterGroup.bindToCluster({});
        clusterParameterGroup.addParameter('key2', 'value2');
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::RDS::DBClusterParameterGroup', {
            Description: 'desc',
            Family: 'aurora5.6',
            Parameters: {
                key1: 'value1',
                key2: 'value2',
            },
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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