"use strict";
const rds = require("../lib");
module.exports = {
    'default parameterGroupFamily for versionless MariaDB instance engine is not defined'(test) {
        const engine = rds.DatabaseInstanceEngine.MARIADB;
        const family = engine.parameterGroupFamily;
        test.equals(family, undefined);
        test.done();
    },
    'default parameterGroupFamily for versionless MySQL instance engine is not defined'(test) {
        const engine = rds.DatabaseInstanceEngine.MYSQL;
        const family = engine.parameterGroupFamily;
        test.equals(family, undefined);
        test.done();
    },
    'default parameterGroupFamily for versionless PostgreSQL instance engine is not defined'(test) {
        const engine = rds.DatabaseInstanceEngine.POSTGRES;
        const family = engine.parameterGroupFamily;
        test.equals(family, undefined);
        test.done();
    },
    "default parameterGroupFamily for versionless Oracle SE instance engine is 'oracle-se-11.2'"(test) {
        const engine = rds.DatabaseInstanceEngine.ORACLE_SE;
        const family = engine.parameterGroupFamily;
        test.equals(family, 'oracle-se-11.2');
        test.done();
    },
    "default parameterGroupFamily for versionless Oracle SE 1 instance engine is 'oracle-se1-11.2'"(test) {
        const engine = rds.DatabaseInstanceEngine.ORACLE_SE1;
        const family = engine.parameterGroupFamily;
        test.equals(family, 'oracle-se1-11.2');
        test.done();
    },
    'default parameterGroupFamily for versionless Oracle SE 2 instance engine is not defined'(test) {
        const engine = rds.DatabaseInstanceEngine.ORACLE_SE2;
        const family = engine.parameterGroupFamily;
        test.equals(family, undefined);
        test.done();
    },
    'default parameterGroupFamily for versionless Oracle EE instance engine is not defined'(test) {
        const engine = rds.DatabaseInstanceEngine.ORACLE_EE;
        const family = engine.parameterGroupFamily;
        test.equals(family, undefined);
        test.done();
    },
    'default parameterGroupFamily for versionless SQL Server SE instance engine is not defined'(test) {
        const engine = rds.DatabaseInstanceEngine.SQL_SERVER_SE;
        const family = engine.parameterGroupFamily;
        test.equals(family, undefined);
        test.done();
    },
    'default parameterGroupFamily for versionless SQL Server EX instance engine is not defined'(test) {
        const engine = rds.DatabaseInstanceEngine.SQL_SERVER_EX;
        const family = engine.parameterGroupFamily;
        test.equals(family, undefined);
        test.done();
    },
    'default parameterGroupFamily for versionless SQL Server Web instance engine is not defined'(test) {
        const engine = rds.DatabaseInstanceEngine.SQL_SERVER_WEB;
        const family = engine.parameterGroupFamily;
        test.equals(family, undefined);
        test.done();
    },
    'default parameterGroupFamily for versionless SQL Server EE instance engine is not defined'(test) {
        const engine = rds.DatabaseInstanceEngine.SQL_SERVER_EE;
        const family = engine.parameterGroupFamily;
        test.equals(family, undefined);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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