"use strict";
const assert_1 = require("@aws-cdk/assert");
const core = require("@aws-cdk/core");
const rds = require("../../lib");
module.exports = {
    'SQL Server instance engine': {
        "has ParameterGroup family ending in '11.0' for major version 11"(test) {
            const stack = new core.Stack();
            new rds.ParameterGroup(stack, 'ParameterGroup', {
                engine: rds.DatabaseInstanceEngine.sqlServerWeb({
                    version: rds.SqlServerEngineVersion.VER_11,
                }),
            }).bindToInstance({});
            assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::RDS::DBParameterGroup', {
                Family: 'sqlserver-web-11.0',
            }));
            test.done();
        },
        "has MajorEngineVersion ending in '11.00' for major version 11"(test) {
            const stack = new core.Stack();
            new rds.OptionGroup(stack, 'OptionGroup', {
                engine: rds.DatabaseInstanceEngine.sqlServerWeb({
                    version: rds.SqlServerEngineVersion.VER_11,
                }),
                configurations: [
                    {
                        name: 'SQLSERVER_BACKUP_RESTORE',
                        settings: {
                            IAM_ROLE_ARN: 'some-role-arn',
                        },
                    },
                ],
            });
            assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::RDS::OptionGroup', {
                MajorEngineVersion: '11.00',
            }));
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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