"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const rds = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-rds-proxy');
const vpc = new ec2.Vpc(stack, 'vpc', { maxAzs: 2 });
const dbInstance = new rds.DatabaseInstance(stack, 'dbInstance', {
    engine: rds.DatabaseInstanceEngine.POSTGRES,
    instanceType: ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE3, ec2.InstanceSize.MEDIUM),
    masterUsername: 'master',
    vpc,
});
new rds.DatabaseProxy(stack, 'dbProxy', {
    borrowTimeout: cdk.Duration.seconds(30),
    maxConnectionsPercent: 50,
    secrets: [dbInstance.secret],
    proxyTarget: rds.ProxyTarget.fromInstance(dbInstance),
    vpc,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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