"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const kms = require("@aws-cdk/aws-kms");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-rds-integ');
const vpc = new ec2.Vpc(stack, 'VPC', { maxAzs: 2 });
const params = new lib_1.ParameterGroup(stack, 'Params', {
    engine: lib_1.DatabaseClusterEngine.AURORA,
    description: 'A nice parameter group',
    parameters: {
        character_set_database: 'utf8mb4',
    },
});
const kmsKey = new kms.Key(stack, 'DbSecurity');
const cluster = new lib_1.DatabaseCluster(stack, 'Database', {
    engine: lib_1.DatabaseClusterEngine.AURORA,
    masterUser: {
        username: 'admin',
        password: cdk.SecretValue.plainText('7959866cacc02c2d243ecfe177464fe6'),
    },
    instanceProps: {
        instanceType: ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE3, ec2.InstanceSize.SMALL),
        vpcSubnets: { subnetType: ec2.SubnetType.PUBLIC },
        vpc,
    },
    parameterGroup: params,
    storageEncryptionKey: kmsKey,
});
cluster.connections.allowDefaultPortFromAnyIpv4('Open to the world');
app.synth();
//# sourceMappingURL=data:application/json;base64,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