class RestEnumerations:
    '''
    this class contains enumeration/dicts for the rest API
    '''

    '''
    used when creating a unit point on map
    '''
    teams = {
        "Cyan": "Cyan",
        'Red': 'Red',
        'Yellow': 'Yellow',
        'Green': 'Green',
        'Blue': 'Blue'
    }

    SquadTypes = {
        "Gnd Combat Infantry Rifleman": "a-.-G-U-C-I",
        "Gnd Combat Infantry grenadier": "a-.-G-E-W-Z",
        "Gnd Combat Infantry Mortar": "a-.-G-E-W-O",
        "Gnd Combat Infantry MachineGunner (LMG)": "a-.-G-E-W-R",
        "Gnd Combat Infantry Medic": "a-.-G-U-i-m-etf",
        "Gnd Combat Infantry Sniper": "a-.-G-U-C-I-d",
        "Gnd Combat Infantry Recon": "a-.-G-U-C-R",
        "Gnd Combat Infantry anti Tank": "a-.-G-U-C-A-A",
        "Gnd Combat Infantry air defense": "a-.-G-U-C-D",
        "Gnd Combat Infantry Engineer": "a-.-G-U-C-E"
    }

    '''
    used when creating a shape
    '''
    otherTypes = {
        "Ground": "a-.-G"
    }

    supportedTypeEnumerations = {}
    
    supportedTypeEnumerations.update(otherTypes)
    supportedTypeEnumerations.update(SquadTypes)

    """
    used when creating an emergency
    """
    emergencyTypes = {
        "911 Alert": "b-a-o-tbl",
        "Ring The Bell": "b-a-o-pan",
        "Geo-fence Breached": "b-a-g",
        "In Contact": "b-a-o-opn",
    }

    """
    used to define how the message is sent
    """
    how = {
        "mensurated": "m-i",
        "human": "h-t",
        "retyped": "h-t",
        "machine": "m-",
        "gps": "m-g",
        "nonCoT": "h-g-i-g-o",
        "gigo": "h-g-i-g-o",
        "mayday": "a-f-G-E-V-9-1-1",
        "estimated": "h-e",
        "calculated": "h-c",
        "transcribed": "h-t",
        "pasted": "h-p",
        "magnetic": "m-m",
        "ins": "m-n",
        "simulated": "m-s",
        "configured": "m-c",
        "radio": "m-r",
        "passed": "m-p",
        "propagated": "m-p",
        "fused": "m-f",
        "tracker": "m-a",
        "ins+gps": "m-g-n",
        "dgps": "m-g-d",
        "eplrs": "m-r-e",
        "plrs": "m-r-p",
        "doppler": "m-r-d",
        "vhf": "m-r-v",
        "tadil": "m-r-t",
        "tadila": "m-r-t-a",
        "tadilb": "m-r-t-b",
        "tadilj": "m-r-t-j"}

    '''
    inserted into COTTYPE
    '''
    attitude = {
        "friend": "a-f-",
        "friendly": "a-f-",
        "hostile": "a-h-",
        "unknown": "a-u-",
        "pending": "a-p-",
        "assumed": "a-a-",
        "neutral": "a-n-",
        "suspect": "a-s-",
        "joker": "a-j-",
        "faker": "a-k-",
        "atoms": "a-"}

    '''
    the base types without an ID
    '''
    geoObject = {
        "Air Air Track": "a-.-A",
        "Air Civ": "a-.-A-C",
        "Air Civ fixed": "a-.-A-C-F",
        "Air Civ fixed RPV, drone, UAV": "a-.-A-C-F-q",
        "Air Civ rotary": "a-.-A-C-H",
        "Air Civ Blimp": "a-.-A-C-L",
        "Air Mil": "a-.-A-M",
        "Air Mil Fixed": "a-.-A-M-F",
        "Air Mil Fixed Gunship": "a-.-A-M-F-g",
        "Air Mil Fixed Attack Strike": "a-.-A-M-F-A",
        "Air Mil Fixed Bomber": "a-.-A-M-F-B",
        "Air Mil Fixed Transport": "a-.-A-M-F-C",
        "Air Mil Fixed Transport Heavy": "a-.-A-M-F-C-H",
        "Air Mil Fixed Transport Light": "a-.-A-M-F-C-L",
        "Air Mil Fixed Transport Medium": "a-.-A-M-F-C-M",
        "Air Mil Fixed C2": "a-.-A-M-F-D",
        "Air Mil Fixed Fighter": "a-.-A-M-F-F",
        "Air Mil Fixed Interceptor": "a-.-A-M-F-F-I",
        "Air Mil Fixed CSAR": "a-.-A-M-F-H",
        "Air Mil Fixed ECM Jammer": "a-.-A-M-F-J",
        "Air Mil Fixed Tanker": "a-.-A-M-F-K",
        "Air Mil Fixed VSTOL": "a-.-A-M-F-L",
        "Air Mil Fixed SOF": "a-.-A-M-F-M",
        "Air Mil Fixed medevac": "a-.-A-M-F-O",
        "Air Mil Fixed Patrol": "a-.-A-M-F-P",
        "Air Mil Fixed Mine Countermeasures": "a-.-A-M-F-P-M",
        "Air Mil Fixed ASUW": "a-.-A-M-F-P-N",
        "Air Mil Fixed Drone,RPV,UAV": "a-.-A-M-F-Q",
        "Air Mil Fixed reconn": "a-.-A-M-F-R",
        "Air Mil Fixed AEW": "a-.-A-M-F-R-W",
        "Air Mil Fixed Photo": "a-.-A-M-F-R-X",
        "Air Mil Fixed esm": "a-.-A-M-F-R-Z",
        "Air Mil Fixed ASW Carrier Based": "a-.-A-M-F-S",
        "Air Mil Fixed Trainer": "a-.-A-M-F-T",
        "Air Mil Fixed Utility": "a-.-A-M-F-U",
        "Air Mil Fixed Utility Heavy": "a-.-A-M-F-U-H",
        "Air Mil Fixed Utility Light": "a-.-A-M-F-U-L",
        "Air Mil Fixed Utility Medium": "a-.-A-M-F-U-M",
        "Air Mil Fixed C3I": "a-.-A-M-F-Y",
        "Air Mil Rotor": "a-.-A-M-H",
        "Air Mil Rotor Transport": "a-.-A-M-H-C",
        "Air Mil Rotor Transport Heavy": "a-.-A-M-H-C-H",
        "Air Mil Rotor Transport Light": "a-.-A-M-H-C-L",
        "Air Mil Rotor Transport Medium": "a-.-A-M-H-C-M",
        "Air Mil Rotor C2": "a-.-A-M-H-D",
        "Air Mil Rotor CSAR": "a-.-A-M-H-H",
        "Air Mil Rotor Mine Countermeasures": "a-.-A-M-H-I",
        "Air Mil Rotor ECM Jammer": "a-.-A-M-H-J",
        "Air Mil Rotor Tanker": "a-.-A-M-H-K",
        "Air Mil Rotor SOF": "a-.-A-M-H-M",
        "Air Mil Rotor medevac": "a-.-A-M-H-O",
        "Air Mil Rotor Drone,RPV,UAV": "a-.-A-M-H-Q",
        "Air Mil Rotor Reconnaissance": "a-.-A-M-H-R",
        "Air Mil Rotor ASW MPA": "a-.-A-M-H-S",
        "Air Mil Rotor Trainer": "a-.-A-M-H-T",
        "Air Mil Rotor Utility": "a-.-A-M-H-U",
        "Air Mil Rotor Utility Heavy)": "a-.-A-M-H-U-H",
        "Air Mil Rotor Utility Light)": "a-.-A-M-H-U-L",
        "Air Mil Rotor Utility Medium)": "a-.-A-M-H-U-M",
        "Air Mil Blimp": "a-.-A-M-L",
        "Air Weapon": "a-.-A-W",
        "Air Weapon Decoy": "a-.-A-W-D",
        "Air Weapon Missile In Flight": "a-.-A-W-M",
        "Air Weapon Missile Air Launched": "a-.-A-W-M-A",
        "Air Weapon Missile Air To Air": "a-.-A-W-M-A-A",
        "Air Weapon Missile Air To Surface": "a-.-A-W-M-A-S",
        "Air Weapon Missile Attack Missile": "a-.-A-W-M-L",
        "Air Weapon Missile Land Launched Missile": "a-.-A-W-M-S",
        "Air Weapon Missile SAM": "a-.-A-W-M-S-A",
        "Air Weapon Missile SAM FixedSite": "a-.-A-W-M-S-A-f",
        "Air Weapon Missile SAM Manpad": "a-.-A-W-M-S-A-i",
        "Air Weapon Missile SAM Mobile": "a-.-A-W-M-S-A-m",
        "Air Weapon Missile Surface To Surface (SSM)": "a-.-A-W-M-S-S",
        "Air Weapon Missile Subsurface To Surface (S SSM)": "a-.-A-W-M-U",
        "Ground": "a-.-G",
        "Gnd Equipment": "a-.-G-E",
        "Gnd Equip Sensor": "a-.-G-E-S",
        "Gnd Equip Sensor Emplaced": "a-.-G-E-S-E",
        "Gnd Equip Sensor Radar": "a-.-G-E-S-R",
        "Gnd Equip Vehicle": "a-.-G-E-V",
        "Gnd Equip Vehic Armor Gun": "a-.-G-E-V-A",
        "Gnd Equip Vehic Armor APC": "a-.-G-E-V-A-A",
        "Gnd Equip Vehic Armor APC Recovery": "a-.-G-E-V-A-A-R",
        "Gnd Equip Vehic Armor C2V ACV": "a-.-G-E-V-A-C",
        "Gnd Equip Vehic Armor Infantry": "a-.-G-E-V-A-I",
        "Gnd Equip Vehic Armor Light": "a-.-G-E-V-A-L",
        "Gnd Equip Vehic Armor Combat Service Support": "a-.-G-E-V-A-S",
        "Gnd Equip Vehic Armor Tank": "a-.-G-E-V-A-T",
        "Gnd Equip Vehic Armor Tank Heavy": "a-.-G-E-V-A-T-H",
        "Gnd Equip Vehic Armor Tank Heavy Recovery": "a-.-G-E-V-A-T-H-R",
        "Gnd Equip Vehic Armor Tank Light": "a-.-G-E-V-A-T-L",
        "Gnd Equip Vehic Armor Tank Light Recovery": "a-.-G-E-V-A-T-L-R",
        "Gnd Equip Vehic Armor Tank Medium": "a-.-G-E-V-A-T-M",
        "Gnd Equip Vehic Civilian": "a-.-G-E-V-C",
        "Gnd Equip Vehic Engineer": "a-.-G-E-V-E",
        "Gnd Equip Vehic Mine Clearing Vehicle": "a-.-G-E-V-E-A",
        "Gnd Equip Vehic Armored Mounted Mine Clearing Vehicle": "a-.-G-E-V-E-A-A",
        "Gnd Equip Vehic Trailer Mounted Mine Clearing Vehicle": "a-.-G-E-V-E-A-T",
        "Gnd Equip Vehic Bridge": "a-.-G-E-V-E-B",
        "Gnd Equip Vehic Construction": "a-.-G-E-V-E-C",
        "Gnd Equip Vehic Dozer": "a-.-G-E-V-E-D",
        "Gnd Equip Vehic Earthmover": "a-.-G-E-V-E-E",
        "Gnd Equip Vehic Mine Laying Vehicle": "a-.-G-E-V-E-M",
        "Gnd Equip Vehic Bus": "a-.-G-E-V-U-B",
        "Gnd Equip Vehic Limited Cross Country Truck": "a-.-G-E-V-U-L",
        "Gnd Equip Vehic Boat": "a-.-G-E-V-U-R",
        "Gnd Equip Vehic Boat Large": "a-.-G-E-V-U-R-l",
        "Gnd Equip Vehic Boat Med": "a-.-G-E-V-U-R-m",
        "Gnd Equip Vehic Boat Small": "a-.-G-E-V-U-R-s",
        "Gnd Equip Vehic Semi": "a-.-G-E-V-U-S",
        "Gnd Equip Vehic Cross Country Truck": "a-.-G-E-V-U-X",
        "Gnd Equip Vehic Ambulance": "a-.-G-E-V-m",
        "Gnd Equip Weapon": "a-.-G-E-W",
        "Gnd Equip Weapon Air Defense Gun": "a-.-G-E-W-A",
        "Gnd Equip Weapon DirectFire ": "a-.-G-E-W-D",
        "Gnd Equip Weapon DirectFire Heavy Self Propelled": "a-.-G-E-W-D-H-S",
        "Gnd Equip Weapon DirectFire Light": "a-.-G-E-W-D-L",
        "Gnd Equip Weapon DirectFire Light Self Propelled": "a-.-G-E-W-D-L-S",
        "Gnd Equip Weapon DirectFire Medium": "a-.-G-E-W-D-M",
        "Gnd Equip Weapon DirectFire Medium Self Propelled": "a-.-G-E-W-D-M-S",
        "Gnd Equip Weapon AntiTankGun": "a-.-G-E-W-G",
        "Gnd Equip Weapon Atg Light": "a-.-G-E-W-G-L",
        "Gnd Equip Weapon Atg Medium": "a-.-G-E-W-G-M",
        "Gnd Equip Weapon Atg Recoilless": "a-.-G-E-W-G-R",
        "Gnd Equip Weapon Howitzer": "a-.-G-E-W-H",
        "Gnd Equip Weapon MissileLauncher": "a-.-G-E-W-M",
        "Gnd Equip Weapon Mortar": "a-.-G-E-W-O",
        "Gnd Equip Weapon Rifle Automatic Weapon": "a-.-G-E-W-R",
        "Gnd Equip Weapon Rifle Rifle": "a-.-G-E-W-R-R",
        "Gnd Equip Weapon RocketLauncher Single ": "a-.-G-E-W-S",
        "Gnd Equip Weapon RocketLauncher AntiTank": "a-.-G-E-W-T",
        "Gnd Equip Weapon Grenade Launcher": "a-.-G-E-W-Z",
        "Gnd Equip Special Equipment": "a-.-G-E-X",
        "Gnd Equip Flame Thrower": "a-.-G-E-X-F",
        "Gnd Equip Laser": "a-.-G-E-X-L",
        "Gnd Equip Land Mines": "a-.-G-E-X-M",
        "Gnd Equip Claymore": "a-.-G-E-X-M-C",
        "Gnd Equip Less Than Lethal": "a-.-G-E-X-M-L",
        "Gnd Equip NBC Equipment": "a-.-G-E-X-N",
        "Gnd Building": "a-.-G-I",
        "Gnd Structure Base Military": "a-.-G-I-B",
        "Gnd Structure Base Airbase": "a-.-G-I-B-A",
        "Gnd Structure Base Naval Base": "a-.-G-I-B-N",
        "Gnd Structure Civilian": "a-.-G-I-c",
        "Gnd Structure Civilian Bridge": "a-.-G-I-c-b",
        "Gnd Structure Civilian Fence or Wall or Barrier": "a-.-G-I-c-bar",
        "Gnd Structure Civilian Canal": "a-.-G-I-c-can",
        "Gnd Structure Civilian Canal Lock": "a-.-G-I-c-can-l",
        "Gnd Structure Civilian Farm": "a-.-G-I-c-frm",
        "Gnd Structure Civilian Monument": "a-.-G-I-c-mon",
        "Gnd Structure Civilian Offices": "a-.-G-I-c-o",
        "Gnd Structure Civilian Residence or Apartment or Hotel": "a-.-G-I-c-rah",
        "Gnd Structure Civilian Retail": "a-.-G-I-c-ret",
        "Gnd Structure Civilian School": "a-.-G-I-c-sch",
        "Gnd Structure Civilian vip": "a-.-G-I-c-vip",
        "Gnd Structure Civilian Warehouse": "a-.-G-I-c-whs",
        "Gnd Structure Factory": "a-.-G-I-E",
        "Gnd Structure Government": "a-.-G-I-G",
        "Gnd Structure IM Facilities": "a-.-G-I-i",
        "Gnd Structure IM Facilities Emergency Management": "a-.-G-I-i-e",
        "Gnd Structure IM Facilities Emergency Management Emergency Operations Center": "a-.-G-I-i-e-EOC",
        "Gnd Structure IM Facilities Emergency Management Incident Commander": "a-.-G-I-i-e-ic",
        "Gnd Structure IM Facilities Emergency Management Incident Communications Center": "a-.-G-I-i-e-icc",
        "Gnd Structure IM Facilities Emergency Management Incident Command Post": "a-.-G-I-i-e-icp",
        "Gnd Structure IM Facilities Emergency Management War Room": "a-.-G-I-i-e-wr",
        "Gnd Structure IM Facilities Fire and Hazmat": "a-.-G-I-i-f",
        "Gnd Structure IM Facilities Fire and Hazmat Fire Department": "a-.-G-I-i-f-fd",
        "Gnd Structure IM Facilities Health and Medical": "a-.-G-I-i-h",
        "Gnd Structure IM Facilities Health and Medical Medical Dispatch": "a-.-G-I-i-h-md",
        "Gnd Structure IM Facilities Law Enforcement": "a-.-G-I-i-l",
        "Gnd Structure IM Facilities Law Enforcement Police Checkpoint": "a-.-G-I-i-l-cp",
        "Gnd Structure IM Facilities Law Enforcement Highway Patrol": "a-.-G-I-i-l-hp",
        "Gnd Structure IM Facilities Law Enforcement Local Police": "a-.-G-I-i-l-lp",
        "Gnd Structure IM Facilities Law Enforcement No Trespassing Zone": "a-.-G-I-i-l-ntz",
        "Gnd Structure IM Facilities Law Enforcement Sheriffs Department": "a-.-G-I-i-l-sd",
        "Gnd Structure IM Facilities Law Enforcement State Police": "a-.-G-I-i-l-SP",
        "Gnd Structure IM Facilities Emergency Medical Services": "a-.-G-I-i-m",
        "Gnd Structure IM Facilities Other": "a-.-G-I-i-o",
        "Gnd Structure IM Facilities Other Agency Dispatch": "a-.-G-I-i-o-AD",
        "Gnd Structure IM Facilities Other Agency Dispatch ems": "a-.-G-I-i-o-AD-ems",
        "Gnd Structure IM Facilities Other Agency Dispatch Fire": "a-.-G-I-i-o-AD-f",
        "Gnd Structure IM Facilities Other Agency Dispatch Highway": "a-.-G-I-i-o-AD-hwy",
        "Gnd Structure IM Facilities Other Agency Dispatch Media": "a-.-G-I-i-o-AD-mda",
        "Gnd Structure IM Facilities Other Agency Dispatch Police Local": "a-.-G-I-i-o-AD-pl",
        "Gnd Structure IM Facilities Other Agency Dispatch Police Station": "a-.-G-I-i-o-AD-ps",
        "Gnd Structure IM Facilities Other Agency Dispatch Tow": "a-.-G-I-i-o-AD-tow",
        "Gnd Structure IM Facilities Other Agency Dispatch Transit": "a-.-G-I-i-o-AD-ts",
        "Gnd Structure IM Facilities Other Border Control Checkpoint": "a-.-G-I-i-o-bcc",
        "Gnd Structure IM Facilities Other dmz": "a-.-G-I-i-o-dmz",
        "Gnd Structure IM Facilities Other Independent Service Provider": "a-.-G-I-i-o-isp",
        "Gnd Structure IM Facilities Other Mobile Center": "a-.-G-I-i-o-mc",
        "Gnd Structure IM Facilities Other Mobile Center Fire": "a-.-G-I-i-o-mc-f",
        "Gnd Structure IM Facilities Other Mobile Center Medical": "a-.-G-I-i-o-mc-h",
        "Gnd Structure IM Facilities Other Mobile Center Law Enforcement": "a-.-G-I-i-o-mc-l",
        "Gnd Structure IM Facilities Other Message Center": "a-.-G-I-i-o-mes",
        "Gnd Structure IM Facilities Other Mobilization Center": "a-.-G-I-i-o-mob",
        "Gnd Structure IM Facilities Other Mobilization Center ems": "a-.-G-I-i-o-mob-ems",
        "Gnd Structure IM Facilities Other Mobilization Center Transit": "a-.-G-I-i-o-mob-es",
        "Gnd Structure IM Facilities Other Mobilization Center Fire": "a-.-G-I-i-o-mob-f",
        "Gnd Structure IM Facilities Other Mobilization Center Highway": "a-.-G-I-i-o-mob-hwy",
        "Gnd Structure IM Facilities Other Mobilization Center Media": "a-.-G-I-i-o-mob-mda",
        "Gnd Structure IM Facilities Other Mobilization Center Police Local": "a-.-G-I-i-o-mob-pl",
        "Gnd Structure IM Facilities Other Mobilization Center Police Station": "a-.-G-I-i-o-mob-ps",
        "Gnd Structure IM Facilities Other Mobilization Center Tow": "a-.-G-I-i-o-mob-tow",
        "Gnd Structure IM Facilities Other Public Safety": "a-.-G-I-i-o-ps",
        "Gnd Structure IM Facilities Other Reporting Locations": "a-.-G-I-i-o-rl",
        "Gnd Structure IM Facilities Other Staging Area": "a-.-G-I-i-o-sa",
        "Gnd Structure IM Facilities Other Staging Area ems": "a-.-G-I-i-o-sa-ems",
        "Gnd Structure IM Facilities Other Staging Area Fire": "a-.-G-I-i-o-sa-f",
        "Gnd Structure IM Facilities Other Staging Area Highway": "a-.-G-I-i-o-sa-hwy",
        "Gnd Structure IM Facilities Other Staging Area Media": "a-.-G-I-i-o-sa-mda",
        "Gnd Structure IM Facilities Other Staging Area Police Local": "a-.-G-I-i-o-sa-pl",
        "Gnd Structure IM Facilities Other Staging Area Police Station": "a-.-G-I-i-o-sa-ps",
        "Gnd Structure IM Facilities Other Staging Area Tow": "a-.-G-I-i-o-sa-tow",
        "Gnd Structure IM Facilities Other Staging Area Transit": "a-.-G-I-i-o-sa-ts",
        "Gnd Structure IM Facilities Other Security Checkpoint": "a-.-G-I-i-o-sc",
        "Gnd Structure IM Facilities Other Segment": "a-.-G-I-i-o-seg",
        "Gnd Structure IM Facilities Other Transportation": "a-.-G-I-i-o-t",
        "Gnd Structure IM Facilities Other Transportation Transit Incident Management Center": "a-.-G-I-i-o-t-IM",
        "Gnd Structure IM Facilities Other Transportation Transit Management Center": "a-.-G-I-i-o-t-tc",
        "Gnd Structure IM Facilities Other Transportation Traffic Inc Service Patrol Dispatch": "a-.-G-I-i-o-t-td",
        "Gnd Structure IM Facilities Other Transportation Traffic Management Center": "a-.-G-I-i-o-t-tm",
        "Gnd Structure IM Facilities Other Temp": "a-.-G-I-i-o-tmp",
        "Gnd Structure IM Facilities Other Temp Fire": "a-.-G-I-i-o-tmp-f",
        "Gnd Structure IM Facilities Other Temp Medical": "a-.-G-I-i-o-tmp-h",
        "Gnd Structure IM Facilities Other Temp Law Enforcement": "a-.-G-I-i-o-tmp-l",
        "Gnd Structure IM Facilities Public Works": "a-.-G-I-i-p",
        "Gnd Structure Mil Military Materiel Facility": "a-.-G-I-M",
        "Gnd Structure Mil Aircraft Production": "a-.-G-I-M-A",
        "Gnd Structure Mil NBC Warfare Production": "a-.-G-I-M-C",
        "Gnd Structure Mil Ammunition Production": "a-.-G-I-M-E",
        "Gnd Structure Mil Nuclear Energy": "a-.-G-I-M-F",
        "Gnd Structure Mil Atomic Energy Reactor": "a-.-G-I-M-F-A",
        "Gnd Structure Mil Nuclear Material Production": "a-.-G-I-M-F-P",
        "Gnd Structure Mil Nuclear Weapons Grade": "a-.-G-I-M-F-P-W",
        "Gnd Structure Mil Nuclear Material Storage": "a-.-G-I-M-F-S",
        "Gnd Structure Mil Armament Production": "a-.-G-I-M-G",
        "Gnd Structure Mil Missile+Space System Production": "a-.-G-I-M-M",
        "Gnd Structure Mil Engineering Equipment Production": "a-.-G-I-M-N",
        "Gnd Structure Mil Bridge": "a-.-G-I-M-N-B",
        "Gnd Structure Mil Bridge Large": "a-.-G-I-M-N-B-l",
        "Gnd Structure Mil Bridge Med": "a-.-G-I-M-N-B-m",
        "Gnd Structure Mil Bridge Small": "a-.-G-I-M-N-B-s",
        "Gnd Structure Mil Canal": "a-.-G-I-M-N-c",
        "Gnd Structure Mil Ship Construction": "a-.-G-I-M-S",
        "Gnd Structure Mil Military Vehicle Production": "a-.-G-I-M-V",
        "Gnd Structure Processing Facility": "a-.-G-I-P",
        "Gnd Structure Decon": "a-.-G-I-P-D",
        "Gnd Structure Raw Material Production Storage": "a-.-G-I-R",
        "Gnd Structure Mine": "a-.-G-I-R-M",
        "Gnd Structure NBC": "a-.-G-I-R-N",
        "Gnd Structure Biological": "a-.-G-I-R-N-B",
        "Gnd Structure Chemical": "a-.-G-I-R-N-C",
        "Gnd Structure Nuclear": "a-.-G-I-R-N-N",
        "Gnd Structure petroleum gas oil": "a-.-G-I-R-P",
        "Gnd Structure petroleum gas oil Refinery": "a-.-G-I-R-P-r",
        "Gnd Structure Transport Facility": "a-.-G-I-T",
        "Gnd Structure Transport Facility Airport": "a-.-G-I-T-a",
        "Gnd Structure Transport Facility Helibase": "a-.-G-I-T-hb",
        "Gnd Structure Transport Facility Helispot": "a-.-G-I-T-hs",
        "Gnd Structure Transport Facility Land Port": "a-.-G-I-T-l",
        "Gnd Structure Transport Facility Parking Garage": "a-.-G-I-T-pg",
        "Gnd Structure Transport Facility Railroad": "a-.-G-I-T-r",
        "Gnd Structure Transport Facility Seaport": "a-.-G-I-T-s",
        "Gnd Structure Utility Service, Research, Utility Facility": "a-.-G-I-U",
        "Gnd Structure Utility Electric Power": "a-.-G-I-U-E",
        "Gnd Structure Utility Electric Power Coal Power Plant": "a-.-G-I-U-E-c",
        "Gnd Structure Utility Electric Power Hydroelectric Power Plant": "a-.-G-I-U-E-h",
        "Gnd Structure Utility Electric Power Other Power": "a-.-G-I-U-E-o",
        "Gnd Structure Utility Electric Power Power Substation": "a-.-G-I-U-E-ps",
        "Gnd Structure Utility Dam": "a-.-G-I-U-E-D",
        "Gnd Structure Utility Fossil Fuel": "a-.-G-I-U-E-F",
        "Gnd Structure Utility Nuclear Plant": "a-.-G-I-U-E-N",
        "Gnd Structure Utility Public Water Services": "a-.-G-I-U-P",
        "Gnd Structure Utility Technological Research": "a-.-G-I-U-R",
        "Gnd Structure Utility Telecommunications": "a-.-G-I-U-T",
        "Gnd Structure Utility Telecommunications Communications": "a-.-G-I-U-T-com",
        "Gnd Structure Utility Telecommunications Communications Antenna Farm": "a-.-G-I-U-T-com-af",
        "Gnd Structure Utility Telecommunications Communications Satellite Communications": "a-.-G-I-U-T-com-sat",
        "Gnd Structure Utility Telecommunications Communications Tower": "a-.-G-I-U-T-com-tow",
        "Gnd Structure Utility Telecommunications Radio": "a-.-G-I-U-T-r",
        "Gnd Structure Utility Telecommunications Radio Station": "a-.-G-I-U-T-r-s",
        "Gnd Structure Utility Telecommunications Telephone": "a-.-G-I-U-T-tp",
        "Gnd Structure Utility Telecommunications Television": "a-.-G-I-U-T-tv",
        "Gnd Structure Utility Telecommunications Television Cable": "a-.-G-I-U-T-tv-c",
        "Gnd Structure Utility Telecommunications Television Station": "a-.-G-I-U-T-tv-s",
        "Gnd Structure Medical Facility": "a-.-G-I-X",
        "Gnd Structure Hospital": "a-.-G-I-X-H",
        "Gnd Structure Medical Facility Hospital Hospital Care Facility": "a-.-G-I-X-hcf",
        "Gnd Structure Road": "a-.-G-I-r",
        "Gnd Structure Road Highway": "a-.-G-I-r-h",
        "Gnd Structure Road Improved": "a-.-G-I-r-i",
        "Gnd Structure Road Rest Area": "a-.-G-I-r-ra",
        "Gnd Structure Road Unimproved": "a-.-G-I-r-u",
        "Gnd Combat armor": "a-.-G-U-C-A",
        "Gnd Combat Armor anti armor": "a-.-G-U-C-A-A",
        "Gnd Combat Armor armor, wheeled": "a-.-G-U-C-A-W",
        "Gnd Combat Armor armor, wheeled amphibious recovery": "a-.-G-U-C-A-W-W-R",
        "Gnd Combat Defense air defense": "a-.-G-U-C-D",
        "Gnd Combat Defense targeting unit": "a-.-G-U-C-D-T",
        "Gnd Combat Engineer engineer": "a-.-G-U-C-E",
        "Gnd Combat Artillery (Fixed)": "a-.-G-U-C-F",
        "Gnd Combat airborne": "a-.-G-U-C-F-S-A",
        "Gnd Combat light": "a-.-G-U-C-F-S-L",
        "Gnd Combat mountain": "a-.-G-U-C-F-S-O",
        "Gnd Combat air assault": "a-.-G-U-C-F-S-S",
        "Gnd Combat Infantry Troops (Open)": "a-.-G-U-C-I",
        "Gnd Combat Infantry Airborne": "a-.-G-U-C-I-A",
        "Gnd Combat Infantry Arctic": "a-.-G-U-C-I-C",
        "Gnd Combat Infantry Fighting Vehicle": "a-.-G-U-C-I-I",
        "Gnd Combat Infantry Air Assault": "a-.-G-U-C-I-S",
        "Gnd Combat Infantry Mechanized": "a-.-G-U-C-I-Z",
        "Gnd Combat Infantry DugIn": "a-.-G-U-C-I-d",
        "Gnd Combat Recon ": "a-.-G-U-C-R",
        "Gnd information warfare unit": "a-.-G-U-U-I",
        "Gnd law enforcement unit": "a-.-G-U-U-L",
        "Gnd civilian law enforcement": "a-.-G-U-U-L-C",
        "Gnd central intelligence division (CID)": "a-.-G-U-U-L-D",
        "Gnd security police (air)": "a-.-G-U-U-L-F",
        "Gnd military police": "a-.-G-U-U-L-M",
        "Gnd counter intelligence": "a-.-G-U-U-M-C",
        "Gnd joint intelligence center": "a-.-G-U-U-M-J",
        "Gnd meteorological": "a-.-G-U-U-M-M-O",
        "Gnd operations": "a-.-G-U-U-M-O",
        "Gnd interrogation": "a-.-G-U-U-M-Q",
        "Gnd surveillance": "a-.-G-U-U-M-R",
        "Gnd IM Resources": "a-.-G-U-i",
        "Gnd IM Resources Animal Health": "a-.-G-U-i-a",
        "Gnd Incident Management Team Animal Protection": "a-.-G-U-i-a-imt",
        "Gnd IM Resources Emergency Management": "a-.-G-U-i-e",
        "Gnd Mobile Feeding Kitchen": "a-.-G-U-i-e-mfk",
        "Gnd Public Assistance Coordinator": "a-.-G-U-i-e-pac",
        "Gnd Rapid Needs Assessment Team": "a-.-G-U-i-e-rna",
        "Gnd Shelter Management Team": "a-.-G-U-i-e-smt",
        "Gnd Volunteer Agency Liaison": "a-.-G-U-i-e-val",
        "Gnd IM Resources Emergency Medical Services": "a-.-G-U-i-m",
        "Gnd Ambulances (Ground)": "a-.-G-U-i-m-ag",
        "Gnd Ambulance Strike Team": "a-.-G-U-i-m-ast",
        "Gnd Ambulance Task Force": "a-.-G-U-i-m-atf",
        "Gnd Emergency Medical Task Force": "a-.-G-U-i-m-etf",
        "Gnd IM Resources Fire hazmat": "a-.-G-U-i-f",
        "Gnd Area Command Team, Firefighting": "a-.-G-U-i-f-act",
        "Gnd Brush Patrol": "a-.-G-U-i-f-bp",
        "Gnd Crew Transport": "a-.-G-U-i-f-ct",
        "Gnd Engine, Fire (Pumper)": "a-.-G-U-i-f-efp",
        "Gnd Fire Boat": "a-.-G-U-i-f-fb",
        "Gnd Fuel Tender": "a-.-G-U-i-f-ft",
        "Gnd Fire Truck": "a-.-G-U-i-f-fta",
        "Gnd Foam Tender": "a-.-G-U-i-f-ftf",
        "Gnd Hand Crew": "a-.-G-U-i-f-hc",
        "Gnd Helicopters Firefighting": "a-.-G-U-i-f-hf",
        "Gnd Helitanker ": "a-.-G-U-i-f-ht",
        "Gnd Mobile Communications Unit": "a-.-G-U-i-f-mcu",
        "Gnd USCG National Strike Force": "a-.-G-U-i-f-nsf",
        "Gnd Portable Pump": "a-.-G-U-i-f-pp",
        "Gnd Strike Team, Engine (Fire)": "a-.-G-U-i-f-st",
        "Gnd Water Tender, Firefighting (Tanker)": "a-.-G-U-i-f-wt",
        "Gnd IM Resources Health and Medical": "a-.-G-U-i-h",
        "Gnd Disaster Medical Assistance Team - Basic": "a-.-G-U-i-h-dmb",
        "Gnd NDMS Management Support Team": "a-.-G-U-i-h-mst",
        "Gnd IM Resources Law Enforcement": "a-.-G-U-i-l",
        "Gnd Bomb Squad Explosives Team": "a-.-G-U-i-l-bs",
        "Gnd Crowd Control Team": "a-.-G-U-i-l-cct",
        "Gnd Public Safety Dive Team": "a-.-G-U-i-l-dt",
        "Gnd Aviation-Helicopters Patrol Surveillance": "a-.-G-U-i-l-hps",
        "Gnd Observation Aircraft": "a-.-G-U-i-l-oa",
        "Gnd SWAT Tactical Team": "a-.-G-U-i-l-tt",
        "Gnd IM Resources Public Works": "a-.-G-U-i-p",
        "Gnd Air Curtain Burners (Above Ground)": "a-.-G-U-i-p-acf",
        "Gnd Air Conditioner Heater": "a-.-G-U-i-p-ach",
        "Gnd Air Curtain Burners (In Ground)": "a-.-G-U-i-p-act",
        "Gnd All Terrain Cranes": "a-.-G-U-i-p-atc",
        "Gnd Backhoe Loader": "a-.-G-U-i-p-bh",
        "Gnd Chillers Air Handlers": "a-.-G-U-i-p-cah",
        "Gnd Crawler Cranes": "a-.-G-U-i-p-cc",
        "Gnd Disaster Assessment Team": "a-.-G-U-i-p-dat",
        "Gnd Debris Management Monitoring Team": "a-.-G-U-i-p-dmm",
        "Gnd Debris Management Site Reduction Team": "a-.-G-U-i-p-dmr",
        "Gnd Debris Management Team": "a-.-G-U-i-p-dmt",
        "Gnd Disaster Recovery Team": "a-.-G-U-i-p-drt",
        "Gnd Dump Trailer": "a-.-G-U-i-p-dt",
        "Gnd Dump Truck Off Road": "a-.-G-U-i-p-dtf",
        "Gnd Dump Truck On Road": "a-.-G-U-i-p-dtn",
        "Gnd Electrical Power Restoration Team": "a-.-G-U-i-p-epr",
        "Gnd Engineering Services": "a-.-G-U-i-p-es",
        "Gnd Flat Bed Trailer Truck": "a-.-G-U-i-p-fbt",
        "Gnd Generators ": "a-.-G-U-i-p-gen",
        "Gnd Hydraulic Excavator (Large)": "a-.-G-U-i-p-hel",
        "Gnd Hydraulic Excavator (Medium)": "a-.-G-U-i-p-hem",
        "Gnd Hydraulic Truck Cranes": "a-.-G-U-i-p-htc",
        "Gnd Lattice Truck Cranes": "a-.-G-U-i-p-ltc",
        "Gnd Tug Boat": "a-.-G-U-i-p-tb",
        "Gnd Track Dozer": "a-.-G-U-i-p-td",
        "Gnd Tub Grinder": "a-.-G-U-i-p-tg",
        "Gnd Tractor Trailer": "a-.-G-U-i-p-tt",
        "Gnd Wheel Dozer": "a-.-G-U-i-p-wd",
        "Gnd Water Purification Team": "a-.-G-U-i-p-wpt",
        "Gnd Water Truck": "a-.-G-U-i-p-wt",
        "Gnd IM Resources Search and Rescue": "a-.-G-U-i-s",
        "Gnd Airborne Reconnaissance": "a-.-G-U-i-s-ar",
        "Gnd Air Search Team": "a-.-G-U-i-s-ast",
        "Gnd Canine SAR Team Avalanche Snow": "a-.-G-U-i-s-cas",
        "Gnd Radio Direction Finding Team": "a-.-G-U-i-s-rdf",
        "Gnd Swiftwater Flood Search and Dive Rescue Team": "a-.-G-U-i-s-sfd",
        "Gnd USAR Incident Support Team": "a-.-G-U-i-s-uis",
        "Gnd USAR Task Force": "a-.-G-U-i-s-utf",
        "Gnd Wilderness SAR Team": "a-.-G-U-i-s-wi",
        "Gnd IM Resources Other": "a-.-G-U-i-o",
        "Surface sea surface track": "a-.-S",
        "Surface combatant": "a-.-S-C",
        "Surface amphibious warfare ship": "a-.-S-C-A",
        "Surface hovercraft": "a-.-S-C-H",
        "Surface line": "a-.-S-C-L",
        "Surface battleship": "a-.-S-C-L-B-B",
        "Surface cruiser": "a-.-S-C-L-C-C",
        "Surface carrier": "a-.-S-C-L-C-V",
        "Surface destroyer": "a-.-S-C-L-D-D",
        "Surface frigate corvette": "a-.-S-C-L-F-F",
        "Surface mine warfare vessel": "a-.-S-C-M",
        "Surface MCM support": "a-.-S-C-M-M-A",
        "Surface MCM drone": "a-.-S-C-M-M-D",
        "Surface minehunter": "a-.-S-C-M-M-H",
        "Surface minelayer": "a-.-S-C-M-M-L",
        "Surface minesweeper": "a-.-S-C-M-M-S",
        "Surface patrol": "a-.-S-C-P",
        "Surface antisubmarine warfare": "a-.-S-C-P-S-B",
        "Surface antisurface warfare": "a-.-S-C-P-S-U",
        "Surface noncombatant": "a-.-S-N",
        "Surface fishing": "a-.-S-X-F",
        "Surface merchant": "a-.-S-X-M",
        "Surface cargo": "a-.-S-X-M-C",
        "Surface ferry": "a-.-S-X-M-F",
        "Surface oiler tanker": "a-.-S-X-M-O",
        "Surface passenger": "a-.-S-X-M-P",
        "Surface tug": "a-.-S-X-M-T-U",
        "Surface leisure craft": "a-.-S-X-R",
        "SubSurf diver": "a-.-U-N-D",
        "SubSurf submarine": "a-.-U-S",
        "Other": "a-.-X",
        "Other incident": "a-.-X-i",
        "Other incident geo": "a-.-X-i-g",
        "Other incident geo avalanche": "a-.-X-i-g-a",
        "Other incident geo earthquake": "a-.-X-i-g-e",
        "Other incident geo landslide": "a-.-X-i-g-l",
        "Other incident geo subsistance": "a-.-X-i-g-s",
        "Other incident geo volcano": "a-.-X-i-g-v",
        "Other incident geo eruption": "a-.-X-i-g-v-e",
        "Other incident met": "a-.-X-i-m",
        "Other incident met drizzle": "a-.-X-i-m-z",
        "Other incident met drought": "a-.-X-i-m-d",
        "Other incident met flood": "a-.-X-i-m-f",
        "Other incident met fog": "a-.-X-i-m-g",
        "Other incident met hail": "a-.-X-i-m-h",
        "Other incident met rain": "a-.-X-i-m-r",
        "Other incident met sandstorm": "a-.-X-i-m-a",
        "Other incident met snow": "a-.-X-i-m-s",
        "Other incident metthunderstorm": "a-.-X-i-m-u",
        "Other incident met tornado": "a-.-X-i-m-t",
        "Other incident met cyclone": "a-.-X-i-m-c",
        "Other incident met tsunami": "a-.-X-i-m-n",
        "Other incident safety": "a-.-X-i-s",
        "Other incident security": "a-.-X-i-l",
        "Other incident security civil disturb": "a-.-X-i-l-c",
        "Other incident security civil disturb demonstration": "a-.-X-i-l-c-d",
        "Other incident security civil disturb displaced": "a-.-X-i-l-c-p",
        "Other incident security civil disturb rioting": "a-.-X-i-l-c-r",
        "Other incident security law enforcement": "a-.-X-i-l-l",
        "Other incident security law enforcement bombing": "a-.-X-i-l-l-b",
        "Other incident security law enforcement bomb explosion": "a-.-X-i-l-l-b-e",
        "Other incident security law enforcementbomb threat": "a-.-X-i-l-l-b-t",
        "Other incident security law enforcement looting": "a-.-X-i-l-l-l",
        "Other incident security law enforcement poisoning": "a-.-X-i-l-l-p",
        "Other incident security law enforcement shooting": "a-.-X-i-l-l-s",
        "Other incident rescue": "a-.-X-i-r",
        "Other incident fire": "a-.-X-i-f",
        "Other incident fire wild": "a-.-X-i-f-w",
        "Other incident fire non residential": "a-.-X-i-f-n",
        "Other incident fire non residential special need": "a-.-X-i-f-n-h",
        "Other incident fire non residential school": "a-.-X-i-f-n-s",
        "Other incident fire residential": "a-.-X-i-f-r",
        "Other incident fire hot spot": "a-.-X-i-f-h",
        "Other incident fire origin": "a-.-X-i-f-o",
        "Other incident fire smoke": "a-.-X-i-f-s",
        "Other incident fire special needs": "a-.-X-i-f-p",
        "Other incident medical public health": "a-.-X-i-h",
        "Other incident pollution environmental": "a-.-X-i-e",
        "Other incident transportation ": "a-.-X-i-t",
        "Other incident transportation air": "a-.-X-i-t-a",
        "Other incident transportation air accident": "a-.-X-i-t-a-a",
        "Other incident transportation air hijacking": "a-.-X-i-t-a-h",
        "Other incident transportation maritime": "a-.-X-i-t-m",
        "Other incident transportation maritime accident": "a-.-X-i-t-m-a",
        "Other incident transportation maritime hijacking": "a-.-X-i-t-m-h",
        "Other incident transportation rail": "a-.-X-i-t-r",
        "Other incident transportation rail accident": "a-.-X-i-t-r-a",
        "Other incident transportation rail hijacking": "a-.-X-i-t-r-h",
        "Other incident transportation vehicle": "a-.-X-i-t-v",
        "Other incident transportation vehicle accident": "a-.-X-i-t-v-a",
        "Other incident transportation vehicle hijacking": "a-.-X-i-t-v-h",
        "Other incident infrastructure": "a-.-X-i-i",
        "Other incident CBRNE": "a-.-X-i-c",
        "Other incident other": "a-.-X-i-o",
        "Space track": "a-.-P",
        "Crewed space vehicle": "a-.-P-V",
        "Satellite": "a-.-P-S",
        "Space station": "a-.-P-T",
        "SOF Unit": "a-.-F",
        "Aviation": "a-.-F-A",
        "Fixed wing": "a-.-F-A-F",
        "Attack": "a-.-F-A-F-A",
        "Ranger": "a-.-F-G-R",
        "Special forces": "a-.-F-G-S",
        "Naval": "a-.-F-N",
        "SEAL": "a-.-F-N-S",
        "Support": "a-.-F-B",
        "Airborne command post": "a-.-A-M-F-Q-D",
        "Attack": "a-.-A-M-F-Q-A",
        "Fighter": "a-.-A-M-F-Q-F",
        "Medevac": "a-.-A-M-F-Q-O",
        "Patrol": "a-.-A-M-F-Q-P",
        "Combat search &amp; rescue (CSAR)": "a-.-A-M-F-Q-H",
        "Special operations forces (SOF)": "a-.-A-M-F-Q-M",
        "Tanker": "a-.-A-M-F-Q-K",
        "Trainer": "a-.-A-M-F-Q-T",
        "Utility": "a-.-A-M-F-Q-U",
        "Bomb": "a-.-A-W-B",
        "Ballistic missile": "a-.-A-W-M-B",
        "Automobile": "a-.-G-E-V-C-A",
        "Jeep type vehicle": "a-.-G-E-V-C-J",
        "Multi-passenger vehicle": "a-.-G-E-V-C-M",
        "Open-bed truck": "a-.-G-E-V-C-O",
        "Tractor trailer truck with box trailer": "a-.-G-E-V-C-T",
        "Tractor trailer truck with flatbed trailer": "a-.-G-E-V-C-F",
        "Utility vehicle": "a-.-G-E-V-C-U",
        "Armored assault": "a-.-G-E-V-E-S",
        "Armored engineer recon vehicle (AERV)": "a-.-G-E-V-E-R",
        "Backhoe": "a-.-G-E-V-E-H",
        "Ferry transporter": "a-.-G-E-V-E-F",
        "Crane loading device": "a-.-G-E-V-S-C",
        "Ambulance": "a-.-G-E-V-U-A",
        "Tow truck": "a-.-G-E-V-U-T",
        "Medium": "a-.-S-C-A-L-S-M",
        "Tank": "a-.-S-C-A-L-S-T",
        "Antisubmarine warfare mission package": "a-.-S-C-L-L-L-A-S",
        "Mine warfare mission package": "a-.-S-C-L-L-L-M-I",
        "Surface warfare (SUW) mission package": "a-.-S-C-L-L-L-S-U",
        "Anti-ship missile": "a-.-S-C-P-S-U-M",
        "Gun": "a-.-S-C-P-S-U-G",
        "Torpedo": "a-.-S-C-P-S-U-T",
        "Electronic surveillance measures": "a-.-A-M-F-Q-R-Z",
        "Photographic": "a-.-A-M-F-Q-R-X",
        "Compact": "a-.-G-E-V-C-A-L",
        "Midsize": "a-.-G-E-V-C-A-M",
        "Sedan": "a-.-G-E-V-C-A-H",
        "Large heavy": "a-.-G-E-V-C-J-H",
        "Medium": "a-.-G-E-V-C-J-M",
        "Small light": "a-.-G-E-V-C-J-L",
        "Large bus": "a-.-G-E-V-C-M-H",
        "Small bus": "a-.-G-E-V-C-M-M",
        "Van": "a-.-G-E-V-C-M-L",
        "Large open-bed truck": "a-.-G-E-V-C-O-H",
        "Pickup truck": "a-.-G-E-V-C-O-L",
        "Small open-bed truck": "a-.-G-E-V-C-O-M",
        "Large heavy box trailer": "a-.-G-E-V-C-T-H",
        "Medium box trailer": "a-.-G-E-V-C-T-M",
        "Small light box trailer": "a-.-G-E-V-C-T-L",
        "Large heavy flatbed trailer": "a-.-G-E-V-C-F-H",
        "Medium flatbed trailer": "a-.-G-E-V-C-F-M",
        "Small light flatbed trailer": "a-.-G-E-V-C-F-L",
        "Large box truck": "a-.-G-E-V-C-U-H",
        "Small box truck": "a-.-G-E-V-C-U-M",
        "Sport utility vehicle (SUV)": "a-.-G-E-V-C-U-L",
        "Armored dozer": "a-.-G-E-V-E-D-A",
        "Armored utility vehicle": "a-.-G-E-V-U-A-A",
        "Heavy semi": "a-.-G-E-V-U-S-H",
        "Light semi": "a-.-G-E-V-U-S-L",
        "Medium semi": "a-.-G-E-V-U-S-M",
        "Heavy tow truck": "a-.-G-E-V-U-T-H",
        "Light tow truck": "a-.-G-E-V-U-T-L",
        "Chaparral": "a-.-G-U-C-D-S-C",
        "C2": "a-.-G-U-C-V-R-C",
        "Medevac": "a-.-G-U-C-V-R-E",
        "Meteorological": "a-.-G-U-U-M-R-O",
        "Int. range AD missile launcher TELAR": "a-.-G-E-W-M-A-I-E",
        "Int. range AD missile launcher TLAR": "a-.-G-E-W-M-A-I-R",
        "Long range AD missile launcher TELAR": "a-.-G-E-W-M-A-L-E",
        "Long range AD missile launcher TLAR": "a-.-G-E-W-M-A-L-R",
        "Short range AD missile launcher TELAR": "a-.-G-E-W-M-A-S-E",
        "Short range AD missile launcher TLAR": "a-.-G-E-W-M-A-S-R",
        "AD missile launcher theater TELAR": "a-.-G-E-W-M-A-T-E",
        "AD missile launcher theater TLAR": "a-.-G-E-W-M-A-T-R",
        "Mayday message": "a-.-.*-9-1-1",
        "sensor point": "b-m-p-s-p-loc",
        "observation point": "b-m-p-s-p-op",
        "grid": "b-m-g-o",
        "Alarm": "b-l",
        "Alarm/CBRNE": "b-l-c",
        "Alarm/CBRNE/BioChem": "b-l-c-b",
        "Alarm/CBRNE/BioChem/Biological": "b-l-c-b-b",
        "Alarm/CBRNE/BioChem/Chemical": "b-l-c-b-c",
        "Alarm/CBRNE/Explosive": "b-l-c-e",
        "Alarm/CBRNE/Explosive/Device": "b-l-c-e-d",
        "Alarm/CBRNE/NuclearRadiological": "b-l-c-n",
        "Alarm/CBRNE/NuclearRadiological/Nuclear": "b-l-c-n-n",
        "Alarm/CBRNE/NuclearRadiological/Nuclear/Bomb": "b-l-c-n-n-b",
        "Alarm/CBRNE/NuclearRadiological/Nuclear/Special Nuclear Material": "b-l-c-n-n-sm",
        "Alarm/CBRNE/NuclearRadiological/Radiological": "b-l-c-n-r",
        "Alarm/CBRNE/Radiological/Dispersal Device (Dirty Bomb)": "b-l-c-n-r-dd",
        "Alarm/Environmental": "b-l-e",
        "Alarm/Environmental/Hazmat": "b-l-e-h",
        "Alarm/Fire": "b-l-f",
        "Alarm/Fire/Audible": "b-l-f-a",
        "Alarm/Fire/Audible/Pump Activated": "b-l-f-a-a",
        "Alarm/Fire/Audible/Combustion": "b-l-f-a-c",
        "Alarm/Fire/Audible/Duct Detector": "b-l-f-a-d",
        "Alarm/Fire/Audible/Flame Detector": "b-l-f-a-f",
        "Alarm/Fire/Audible/Heat": "b-l-f-a-h",
        "Alarm/Fire/Audible/Pull Station": "b-l-f-a-p",
        "Alarm/Fire/Audible/Smoke": "b-l-f-a-s",
        "Alarm/Fire/Audible/Waterflow": "b-l-f-a-w",
        "Alarm/Geophysical": "b-l-g",
        "Alarm/Medical and Public Health": "b-l-h",
        "Alarm/Medical and Public Health/Audible": "b-l-h-a",
        "Alarm/Medical and Public Health/Ambulance": "b-l-h-am",
        "Alarm/Medical and Public Health/Ambulance/Silent": "b-l-h-am-s",
        "Alarm/Infrastructure": "b-l-i",
        "Alarm/Security": "b-l-l",
        "Alarm/Security/Law Enforcement": "b-l-l-l",
        "Alarm/Security/Law Enforcement/Armed and Dangerous": "b-l-l-l-ad",
        "Alarm/Security/Law Enforcement/Animal": "b-l-l-l-an",
        "Alarm/Security/Law Enforcement/Animal/On Roadway": "b-l-l-l-an-or",
        "Alarm/Security/Law Enforcement/Assualt": "b-l-l-l-as",
        "Alarm/Security/Law Enforcement/Abandoned Vehicle": "b-l-l-l-av",
        "Alarm/Security/Law Enforcement/Battery": "b-l-l-l-ba",
        "Alarm/Security/Law Enforcement/Bomb Threat": "b-l-l-l-bt",
        "Alarm/Security/Law Enforcement/Burglary": "b-l-l-l-bur",
        "Alarm/Security/Law Enforcement/Burglary/Audible": "b-l-l-l-bur-a",
        "Alarm/Security/Law Enforcement/Burglary/Audible/Day/Night Zone": "b-l-l-l-bur-a-d",
        "Alarm/Security/Law Enforcement/Burglary/Audible/Entry/Exit": "b-l-l-l-bur-a-e",
        "Alarm/Security/Law Enforcement/Burglary/Audible/Interior": "b-l-l-l-bur-a-i",
        "Alarm/Security/Law Enforcement/Burglary/Audible/Outdoor": "b-l-l-l-bur-a-o",
        "Alarm/Security/Law Enforcement/Burglary/Audible/Perimeter": "b-l-l-l-bur-a-p",
        "Alarm/Security/Law Enforcement/Burglary/Audible/24 Hour Zone": "b-l-l-l-bur-a-t",
        "Alarm/Security/Law Enforcement/Burglary/Audible/Exit Error": "b-l-l-l-bur-a-x",
        "Alarm/Security/Law Enforcement/Burglary/Silent": "b-l-l-l-bur-s",
        "Alarm/Security/Law Enforcement/Burglary/Silent/Recent Close": "b-l-l-l-bur-s-c",
        "Alarm/Security/Law Enforcement/Crash": "b-l-l-l-c",
        "Alarm/Security/Law Enforcement/Crash/Aircraft": "b-l-l-l-c-a",
        "Alarm/Security/Law Enforcement/Crash/With Fatalities": "b-l-l-l-c-wf",
        "Alarm/Security/Law Enforcement/Crash/With injuries": "b-l-l-l-c-wi",
        "Alarm/Security/Law Enforcement/Crash/With Roadblock": "b-l-l-l-c-wr",
        "Alarm/Security/Law Enforcement/Crash/Patrol Car": "b-l-l-l-c-pc",
        "Alarm/Security/Law Enforcement/Child Abuse": "b-l-l-l-ca",
        "Alarm/Security/Law Enforcement/Civil Disturbance or Disorder": "b-l-l-l-cd",
        "Alarm/Security/Law Enforcement/Callbox Request": "b-l-l-l-cr",
        "Alarm/Security/Law Enforcement/Drug or Contraband": "b-l-l-l-dc",
        "Alarm/Security/Law Enforcement/Domestic Violence": "b-l-l-l-dov",
        "Alarm/Security/Law Enforcement/Dead Person": "b-l-l-l-dp",
        "Alarm/Security/Law Enforcement/Drunk Pedestrian": "b-l-l-l-drp",
        "Alarm/Security/Law Enforcement/DUI/Juvenile": "b-l-l-l-dui-j",
        "Alarm/Security/Law Enforcement/Disabled Vehicle": "b-l-l-l-dv",
        "Alarm/Security/Law Enforcement/Escaped Prisoner": "b-l-l-l-ep",
        "Alarm/Security/Law Enforcement/Hit and Run": "b-l-l-l-hr",
        "Alarm/Security/Law Enforcement/Hit and Run/With Injuries": "b-l-l-l-hr-wi",
        "Alarm/Security/Law Enforcement/Hit and Run/With Roadblock": "b-l-l-l-hr-wr",
        "Alarm/Security/Law Enforcement/Hold Up": "b-l-l-l-hup",
        "Alarm/Security/Law Enforcement/Hold Up/Audible": "b-l-l-l-hup-a",
        "Alarm/Security/Law Enforcement/Hold Up/Silent": "b-l-l-l-hup-s",
        "Alarm/Security/Law Enforcement/Information or Intelligence - calls to take witness info": "b-l-l-l-ii",
        "Alarm/Security/Law Enforcement/Impersonating an Officer": "b-l-l-l-io",
        "Alarm/Security/Law Enforcement/Juvenile Offense": "b-l-l-l-jo",
        "Alarm/Security/Law Enforcement/Kidnapping": "b-l-l-l-k",
        "Alarm/Security/Law Enforcement/Larceny": "b-l-l-l-l",
        "Alarm/Security/Law Enforcement/Murder": "b-l-l-l-m",
        "Alarm/Security/Law Enforcement/Mentally Ill Person": "b-l-l-l-mi",
        "Alarm/Security/Law Enforcement/Malacious Mischief": "b-l-l-l-mm",
        "Alarm/Security/Law Enforcement/Missing Person": "b-l-l-l-mp",
        "Alarm/Security/Law Enforcement/Officer Down": "b-l-l-l-od",
        "Alarm/Security/Law Enforcement/Pedestrian or Hitchhiker": "b-l-l-l-ph",
        "Alarm/Security/Law Enforcement/Robbery": "b-l-l-l-r",
        "Alarm/Security/Law Enforcement/Robbery/Strongarm": "b-l-l-l-r-sa",
        "Alarm/Security/Law Enforcement/Reckless Driving": "b-l-l-l-rd",
        "Alarm/Security/Law Enforcement/Rock Throwing": "b-l-l-l-rt",
        "Alarm/Security/Law Enforcement/Shooting": "b-l-l-l-s",
        "Alarm/Security/Law Enforcement/Suspicious Circumstances": "b-l-l-l-sc",
        "Alarm/Security/Law Enforcement/Special Detail": "b-l-l-l-sd",
        "Alarm/Security/Law Enforcement/Smuggling": "b-l-l-l-sg",
        "Alarm/Security/Law Enforcement/Sick or Injured Person": "b-l-l-l-si",
        "Alarm/Security/Law Enforcement/Sex Offense": "b-l-l-l-so",
        "Alarm/Security/Law Enforcement/Suspicious Person": "b-l-l-l-sp",
        "Alarm/Security/Law Enforcement/Suicide": "b-l-l-l-su",
        "Alarm/Security/Law Enforcement/Suspicious Vehcle": "b-l-l-l-sv",
        "Alarm/Security/Law Enforcement/Toll Evasion": "b-l-l-l-te",
        "Alarm/Security/Law Enforcement/Lost or Stolen Vehicle Tag": "b-l-l-l-vt",
        "Alarm/Meteorological": "b-l-m",
        "Alarm/Other": "b-l-o",
        "Alarm/Other/Cancel": "b-l-o-can",
        "Alarm/Other/Close": "b-l-o-clo",
        "Alarm/Other/Close/Silent": "b-l-o-clo-s",
        "Alarm/Other/Close/Silent/Stay Mode": "b-l-o-clo-s-sm",
        "Alarm/Other/Forced Arming": "b-l-o-far",
        "Alarm/Other/Forced Arming/Silent": "b-l-o-far-s",
        "Alarm/Other/Forced Arming/Silent/Partial Arm": "b-l-o-far-s-pa",
        "Alarm/Other/Failure to Test": "b-l-o-ftt",
        "Alarm/Other/Failure to Test/Silent": "b-l-o-ftt-s",
        "Alarm/Other/Failure to Test/Silent/Point not Tested": "b-l-o-ftt-s-pn",
        "Alarm/Other/Log": "b-l-o-log",
        "Alarm/Other/Panic": "b-l-o-pan",
        "Alarm/Other/Reset": "b-l-o-res",
        "Alarm/Other/Reset/Silent": "b-l-o-res-s",
        "Alarm/Other/Reset/Silent/Exp Mod Reset": "b-l-o-res-s-er",
        "Alarm/Other/Special": "b-l-o-spc",
        "Alarm/Other/Special/Audible": "b-l-o-spc-a",
        "Alarm/Other/Special/Audible/General Alarm": "b-l-o-spc-a-a",
        "Alarm/Other/Special/Audible/Personal Emergency": "b-l-o-spc-a-e",
        "Alarm/Other/Special/Audible/Air Flow Loss": "b-l-o-spc-a-f",
        "Alarm/Other/Special/Audible/Gas Detected": "b-l-o-spc-a-g",
        "Alarm/Other/Special/Audible/Low Gas Level": "b-l-o-spc-a-l",
        "Alarm/Other/Special/Audible/Water Leakage": "b-l-o-spc-a-w",
        "Alarm/Other/Special/Silent": "b-l-o-spc-s",
        "Alarm/Other/Special/Silent/Fail to Report": "b-l-o-spc-s-f",
        "Alarm/Other/Special/Silent/Listen in to Follow": "b-l-o-spc-s-li",
        "Alarm/Other/Supress": "b-l-o-sps",
        "Alarm/Other/Supress/Audible": "b-l-o-sps-a",
        "Alarm/Other/Supress/Audible/Gate Valve Tamper": "b-l-o-sps-a-g",
        "Alarm/Other/Supress/Silent": "b-l-o-sps-s",
        "Alarm/Other/Supress/Silent/Alarm Relay Disabled": "b-l-o-sps-s-ar",
        "Alarm/Other/Supress/Silent/Bell 1 Disabled": "b-l-o-sps-s-b1",
        "Alarm/Other/Supress/Silent/Bell 2 Disabled": "b-l-o-sps-s-b2",
        "Alarm/Other/Supress/Silent/Dialer Disabled": "b-l-o-sps-s-dd",
        "Alarm/Other/Supress/Silent/Reversing Relay Disabled": "b-l-o-sps-s-rr",
        "Alarm/Other/Supress/Silent/Radio Transmitter Disabled": "b-l-o-sps-s-rx",
        "Alarm/Other/Supress/Silent/Sounder relay Disabled": "b-l-o-sps-s-sr",
        "Alarm/Other/Supress/Silent/Trouble Relay Disabled": "b-l-o-sps-s-tr",
        "Alarm/Other/Tamper": "b-l-o-tam",
        "Alarm/Other/Tamper/Audible": "b-l-o-tam-a",
        "Alarm/Other/Tamper/Silent": "b-l-o-tam-s",
        "Alarm/Other/Tamper/Silent/Expansion Module": "b-l-o-tam-s-e",
        "Alarm/Other/Tamper/Silent/Panel Program Change": "b-l-o-tam-s-p",
        "Alarm/Other/Tamper/Silent/Sensor": "b-l-o-tam-s-s",
        "Alarm/Other/Tamper/Silent/Verify": "b-l-o-tam-s-v",
        "Alarm/Other/Trouble": "b-l-o-tbl",
        "Alarm/Other/Trouble/Audible": "b-l-o-tbl-a",
        "Alarm/Other/Trouble/Audible/Foil Break": "b-l-o-tbl-a-b",
        "Alarm/Other/Trouble/Audible/Low CO2": "b-l-o-tbl-a-c",
        "Alarm/Other/Trouble/Audible/Day Trouble": "b-l-o-tbl-a-d",
        "Alarm/Other/Trouble/Audible/Exit error": "b-l-o-tbl-a-ee",
        "Alarm/Other/Trouble/Audible/Low Water Level": "b-l-o-tbl-a-l",
        "Alarm/Other/Trouble/Audible/Low  Water Pressure": "b-l-o-tbl-a-p",
        "Alarm/Other/Trouble/Audible/Pump Failure": "b-l-o-tbl-a-u",
        "Alarm/Other/Trouble/Silent": "b-l-o-tbl-s",
        "Alarm/Other/Trouble/Silent/Sensor": "b-l-o-tbl-s-a",
        "Alarm/Other/Trouble/Silent/Alarm Relay": "b-l-o-tbl-s-ar",
        "Alarm/Other/Trouble/Silent/Low System Battery": "b-l-o-tbl-s-b",
        "Alarm/Other/Trouble/Silent/Bell 1": "b-l-o-tbl-s-b1",
        "Alarm/Other/Trouble/Silent/Bell 2": "b-l-o-tbl-s-b2",
        "Alarm/Other/Trouble/Silent/Battery Test Fail": "b-l-o-tbl-s-bt",
        "Alarm/Other/Trouble/Silent/Polling Loop Close": "b-l-o-tbl-s-c",
        "Alarm/Other/Trouble/Silent/Communication Fail": "b-l-o-tbl-s-cf",
        "Alarm/Other/Trouble/Silent/Exp Mod DC Loss": "b-l-o-tbl-s-dc",
        "Alarm/Other/Trouble/Silent/Detector Hi Sens": "b-l-o-tbl-s-dh",
        "Alarm/Other/Trouble/Silent/Detector Low Sens": "b-l-o-tbl-s-dl",
        "Alarm/Other/Trouble/Silent/Expansion Mod Fail": "b-l-o-tbl-s-e",
        "Alarm/Other/Trouble/Silent/Event Log 50% Full": "b-l-o-tbl-s-e50",
        "Alarm/Other/Trouble/Silent/Event Log 90% Full": "b-l-o-tbl-s-e90",
        "Alarm/Other/Trouble/Silent/Expansion Module Fail": "b-l-o-tbl-s-em",
        "Alarm/Other/Trouble/Silent/Event Log Overflow": "b-l-o-tbl-s-eo",
        "Alarm/Other/Trouble/Silent/Fire Trouble": "b-l-o-tbl-s-ft",
        "Alarm/Other/Trouble/Silent/Ground Fault": "b-l-o-tbl-s-gf",
        "Alarm/Other/Trouble/Silent/Exp Mod Low Battery": "b-l-o-tbl-s-lb",
        "Alarm/Other/Trouble/Silent/Protection Loop Open": "b-l-o-tbl-s-lo",
        "Alarm/Other/Trouble/Silent/Lost Polling": "b-l-o-tbl-s-lp",
        "Alarm/Other/Trouble/Silent/Long Range Radio": "b-l-o-tbl-s-lr",
        "Alarm/Other/Trouble/Silent/Protection Loop Short": "b-l-o-tbl-s-ls",
        "Alarm/Other/Trouble/Silent/RPM Supervision": "b-l-o-tbl-s-ms",
        "Alarm/Other/Trouble/Silent/Near Alarm": "b-l-o-tbl-s-n",
        "Alarm/Other/Trouble/Silent/Polling Loop Open": "b-l-o-tbl-s-o",
        "Alarm/Other/Trouble/Silent/AC Power Lost": "b-l-o-tbl-s-p",
        "Alarm/Other/Trouble/Silent/Printer Failure": "b-l-o-tbl-s-pf",
        "Alarm/Other/Trouble/Silent/Protection Loop": "b-l-o-tbl-s-pl",
        "Alarm/Other/Trouble/Silent/Printer Paper Out": "b-l-o-tbl-s-pp",
        "Alarm/Other/Trouble/Silent/Polling Loop Short": "b-l-o-tbl-s-ps",
        "Alarm/Other/Trouble/Silent/Radio Antenna Vswr": "b-l-o-tbl-s-ra",
        "Alarm/Other/Trouble/Silent/Repeater Failure": "b-l-o-tbl-s-rf",
        "Alarm/Other/Trouble/Silent/RF Low Battery": "b-l-o-tbl-s-rfb",
        "Alarm/Other/Trouble/Silent/Reversing Relay": "b-l-o-tbl-s-rr",
        "Alarm/Other/Trouble/Silent/RF Supervision": "b-l-o-tbl-s-rs",
        "Alarm/Other/Trouble/Silent/Smoke Det Hi Sens": "b-l-o-tbl-s-sh",
        "Alarm/Other/Trouble/Silent/Smoke Det Low Sens": "b-l-o-tbl-s-sl",
        "Alarm/Other/Trouble/Silent/System Peripheral": "b-l-o-tbl-s-sp",
        "Alarm/Other/Trouble/Silent/Sounder/Relay": "b-l-o-tbl-s-sr",
        "Alarm/Other/Trouble/Silent/System Shutdown": "b-l-o-tbl-s-ss",
        "Alarm/Other/Trouble/Silent/Self Test Failure": "b-l-o-tbl-s-st",
        "Alarm/Other/Trouble/Silent/Telco Line 1": "b-l-o-tbl-s-t1",
        "Alarm/Other/Trouble/Silent/Telco Line 2": "b-l-o-tbl-s-t2",
        "Alarm/Other/Trouble/Silent/Time/Date Inaccurate": "b-l-o-tbl-s-ti",
        "Alarm/Other/Trouble/Silent/Trouble Relay": "b-l-o-tbl-s-tr",
        "Alarm/Other/Trouble/Silent/RAM Checksum Bad": "b-l-o-tbl-s-x",
        "Alarm/Other/Trouble/Silent/ROM Checksum Bad": "b-l-o-tbl-s-y",
        "Alarm/Other/Temperature": "b-l-o-tem",
        "Alarm/Other/Temperature/Audible": "b-l-o-tem-a",
        "Alarm/Other/Temperature/Audible/High Temperature": "b-l-o-tem-a-h",
        "Alarm/Other/Temperature/Audible/Low Temperature": "b-l-o-tem-a-l",
        "Alarm/Other/Temperature/Audible/Loss of Heat": "b-l-o-tem-a-lh",
        "Alarm/Other/Temperature/Audible/Refrigeration": "b-l-o-tem-a-r",
        "Alarm/Other/Test": "b-l-o-tst",
        "Alarm/Other/Test/SIlent": "b-l-o-tst-s",
        "Alarm/Other/Test/SIlent/Fire Alarm": "b-l-o-tst-s-fa",
        "Alarm/Other/Test/SIlent/Manual": "b-l-o-tst-s-m",
        "Alarm/Other/Test/SIlent/Point Tested OK": "b-l-o-tst-s-pt",
        "Alarm/Other/Test/SIlent/System Remains in Trouble": "b-l-o-tst-s-st",
        "Alarm/Other/Test/SIlent/Walk Test Mode Entered": "b-l-o-tst-s-wm",
        "Alarm/Rescue": "b-l-r",
        "Alarm/Safety": "b-l-s",
        "Alarm/Transportation": "b-l-t",
        "Alarm/Transportation/Vehicle": "b-l-t-v",
        "Alarm/Transportation/Vehicle/Accident": "b-l-t-v-a",
        "Alarm/Transportation/Vehicle/Accident/Collision": "b-l-t-v-a-c",
        "Alarm/Transportation/Vehicle/Accident/Collision/Fixed Object": "b-l-t-v-a-c-f",
        "Alarm/Transportation/Vehicle/Accident/Collision/Non-Fixed Object": "b-l-t-v-a-c-n",
        "Alarm/Transportation/Vehicle/Accident/Equipment/Cargo Loss/Shift": "b-l-t-v-a-e",
        "Alarm/Transportation/Vehicle/Accident/Fire_Explosion": "b-l-t-v-a-f",
        "Alarm/Transportation/Vehicle/Accident/Immersion": "b-l-t-v-a-i",
        "Alarm/Transportation/Vehicle/Accident/Jacknife": "b-l-t-v-a-j",
        "Alarm/Transportation/Vehicle/Accident/Object Thrown/Fallen": "b-l-t-v-a-o",
        "Alarm/Transportation/Vehicle/Accident/Overturn_Rollover": "b-l-t-v-a-or",
        "Alarm/Transportation/Vehicle/Accident/Person Fell or Jumped": "b-l-t-v-a-p",
        "Alarm/Transportation/Vehicle/Other (Non Collision)": "b-l-t-v-o",
        "SEAD": "t-a-s",
        "Strike": "t-k",
        "Destroy": "t-k-d",
        "Investigate": "t-k-i",
        "Target": "t-k-t",
        "Mensurate": "t-m",
        "Tasking Update": "t-u",
        "Tasking Status Query": "t-u-q",
        "Tasking Cancel": "t-u-z",
        "Tasking (Experimental)": "t-x",
        "Tasking Data Retrieval": "t-x-i",
        "Link Dereference": "t-x-i-l",
        "App control- Sync (with peer)": "t-x-a-s",
        "App control- Sync (subscribe)": "t-x-a-s-c",
        "Filter": "t-x-a-f",
        "Open": "t-x-a-o",
        "Medevac": "t-x-v-m",
        "Reply": "y",
        "Ack": "y-a",
        "Rcvd": "y-a-r",
        "Wilco": "y-a-w",
        "Tasking Complete": "y-c",
        "Fail": "y-c-f",
        "Fail: No Assets": "y-c-f-a",
        "Fail: Bad Reqest (CANTPRO)": "y-c-f-b",
        "Fail: Denied": "y-c-f-d",
        "Fail: Insufficient Info": "y-c-f-i",
        "Fail: Rejected": "y-c-f-r",
        "Fail: C2 element": "y-c-f-r-c",
        "Fail: Platform (CANTCO)": "y-c-f-r-p",
        "Fail: Stale": "y-c-f-s",
        "Fail: Cancelled": "y-c-f-x",
        "Complete: Success": "y-c-s",
        "Status: Status": "y-s",
        "Status: Canceling": "y-s-c",
        "Status: Executing": "y-s-e",
        "Status: Approved": "y-s-e-a",
        "Status: Disseminating": "y-s-e-d",
        "Status: Disseminated": "y-s-e-d-c",
        "Status: Imagery Available": "y-s-i",
        "Status: MISREP available": "y-s-m",
        "Status: Planning": "y-s-p",
        "Status: Reviewing": "y-s-r",
        "METOC": "b-w",
        "ATMOSPHERIC": "b-w-A",
        "Temperature": "b-w-A-t",
        "PRESSURE SYSTEMS": "b-w-A-P",
        "LOW PRESSURE CENTER": "b-w-A-P-L",
        "HIGH PRESSURE CENTER": "b-w-A-P-H",
        "FRONTAL SYSTEMS": "b-w-A-P-F",
        "COLD FRONT": "b-w-A-P-F-C",
        "UPPER COLD FRONT": "b-w-A-P-F-C-U",
        "WARM FRONT": "b-w-A-P-F-W",
        "UPPER WARM FRONT": "b-w-A-P-F-W-U",
        "OCCLUDED FRONT": "b-w-A-P-F-O",
        "STATIONARY FRONT": "b-w-A-P-F-S",
        "LINES": "b-w-A-P-X",
        "TROUGH LINE": "b-w-A-P-X-T",
        "RIDGE LINE": "b-w-A-P-X-R",
        "SQUALL LINE": "b-w-A-P-X-S",
        "TURBULENCE": "b-w-A-T",
        "LIGHT TURBULENCE": "b-w-A-T-L",
        "MODERATE TURBULENCE": "b-w-A-T-M",
        "SEVERE TURBULENCE": "b-w-A-T-S",
        "EXTREME TURBULENCE": "b-w-A-T-E",
        "ICING": "b-w-A-I",
        "CLEAR ICING": "b-w-A-I-C",
        "LIGHT CLEAR ICING": "b-w-A-I-C-L",
        "MODERATE CLEAR ICING": "b-w-A-I-C-M",
        "SEVERE CLEAR ICING": "b-w-A-I-C-S",
        "RIME ICING": "b-w-A-I-R",
        "LIGHT RIME ICING": "b-w-A-I-R-L",
        "MODERATE RIME ICING": "b-w-A-I-R-M",
        "SEVERE RIME ICING": "b-w-A-I-R-S",
        "MIXED ICING": "b-w-A-I-M",
        "LIGHT MIXED ICING": "b-w-A-I-M-L",
        "MODERATE MIXED ICING": "b-w-A-I-M-M",
        "SEVERE MIXED ICING": "b-w-A-I-M-S",
        "WIND BARB": "b-w-A-W",
        "JET STREAM": "b-w-A-W-J",
        "FLIGHT RULES": "b-w-A-F",
        "INSTRUMENT CEILING": "b-w-A-F-I",
        "VISUAL CEILING": "b-w-A-F-V",
        "COVERAGE SYMBOLS": "b-w-A-C",
        "Cloud tops": "b-w-A-C-t",
        "Cloud base": "b-w-A-C-b",
        "Cloud ceiling": "b-w-A-C-c",
        "Total Cloud Coverage": "b-w-A-C-a",
        "CLEAR SKY (SKC)": "b-w-A-C-C",
        "SCATTERED SKY (SCT)": "b-w-A-C-S",
        "BROKEN SKY (BKN)": "b-w-A-C-B",
        "OVERCAST WITH BREAKS": "b-w-A-C-W",
        "OVERCAST (OVC)": "b-w-A-C-O",
        "SKY OBSCURED OR PARTIALLY OBSCURED": "b-w-A-C-P",
        "PRECIPITATION": "b-w-A-R",
        "RAIN (RA)": "b-w-A-R-R",
        "RAIN SHOWER": "b-w-A-R-R-S",
        "FREEZING RAIN (FZRA)": "b-w-A-R-R-F",
        "DRIZZLE (DZ)": "b-w-A-R-R-D",
        "FREEZING DRIZZLE (FZDZ)": "b-w-A-R-R-D-F",
        "SNOW(SN)": "b-w-A-R-S",
        "SNOW SHOWERS": "b-w-A-R-S-S",
        "SNOW GRAINS (SG)": "b-w-A-R-S-G",
        "HAIL": "b-w-A-R-H",
        "ICE PELLETS (PE)": "b-w-A-R-I",
        "ICE CRYSTALS (IC)": "b-w-A-R-C",
        "STORMS": "b-w-A-S",
        "THUNDERSTORMS (TS)": "b-w-A-S-T",
        "THUNDERSTORM (TS) WITH RAIN (RA) ": "b-w-A-S-T-R",
        "FUNNEL CLOUD (FC)/TORNADO/WATERSPOUT": "b-w-A-S-T-F",
        "LIGHTNING (LTG)": "b-w-A-S-T-L",
        "STORM SYSTEMS": "b-w-A-S-S",
        "TROPICAL STORM": "b-w-A-S-S-T",
        "HURRICANE": "b-w-A-S-S-H",
        "OBSTRUCTIONS TO VISIBILITY": "b-w-A-O",
        "BLOWING SNOW (BLSN)": "b-w-A-O-S",
        "FOG (FG)": "b-w-A-O-F",
        "FREEZING FOG (FZFG)": "b-w-A-O-F-F",
        "DUST/SAND STORM": "b-w-A-O-T",
        "DUST DEVIL": "b-w-A-O-D",
        "SMOKE (FU)": "b-w-A-O-K",
        "HAZE (HZ)": "b-w-A-O-H",
        "BLOWING DUST OR SAND": "b-w-A-O-B",
        "OCEANIC": "b-w-O",
        "SPACE": "b-w-S",
        "HEALTH/CASUALTY": "b-r-.-h-c",
        "MILITARY OPERATIONS OTHER THAN WAR (MOOTW)": "b-r-.-O",
        "VIOLENT ACTIVITIES (DEATH CAUSING)": "b-r-.-O-V",
        "ARSON/FIRE": "b-r-.-O-V-A",
        "ASSASSINATION/MURDER/EXECUTION": "b-r-.-O-V-M",
        "BOMB/BOMBING": "b-r-.-O-V-B",
        "BOOBY TRAP": "b-r-.-O-V-Y",
        "DRIVE BY SHOOTING": "b-r-.-O-V-D",
        "SNIPING": "b-r-.-O-V-S",
        "POISONING": "b-r-.-O-V-P",
        "LOCATIONS": "b-r-.-O-L",
        "BLACK LIST LOCATION": "b-r-.-O-L-B",
        "GRAY LIST LOCATION": "b-r-.-O-L-G",
        "WHITE LIST LOCATION": "b-r-.-O-L-W",
        "OPERATIONS": "b-r-.-O-O",
        "PATROLLING": "b-r-.-O-O-P",
        "RECRUITMENT": "b-r-.-O-O-R",
        "RECRUITMENT (WILLING)": "b-r-.-O-O-R-W",
        "RECRUITMENT (COERCED/IMPRESSED)": "b-r-.-O-O-R-C",
        "DEMONSTRATION": "b-r-.-O-O-D",
        "MINE LAYING": "b-r-.-O-O-M",
        "PSYCHOLOGICAL OPERATIONS (PSYOP)": "b-r-.-O-O-Y",
        "PSYOP (TV AND RADIO PROPAGANDA)": "b-r-.-O-O-Y-T",
        "PSYOP (WRITTEN PROPAGANA)": "b-r-.-O-O-Y-W",
        "HOUSE TO HOUSE PROPAGANDA": "b-r-.-O-O-Y-H",
        "FORAGING/SEARCHING": "b-r-.-O-O-F",
        "SPY": "b-r-.-O-O-S",
        "FOOD DISTRIBUTION": "b-r-.-O-O-O",
        "EXTORTION": "b-r-.-O-O-E",
        "HIJACKING": "b-r-.-O-O-H",
        "HIJACKING (VEHICLE)": "b-r-.-O-O-H-T",
        "HIJACKING (AIRPLANE)": "b-r-.-O-O-H-A",
        "HIJACKING (BOAT)": "b-r-.-O-O-H-V",
        "KIDNAPPING": "b-r-.-O-O-K",
        "ARREST": "b-r-.-O-O-A",
        "DRUG OPERATION": "b-r-.-O-O-U",
        "ITEMS": "b-r-.-O-I",
        "REFUGEES": "b-r-.-O-I-R",
        "SAFE HOUSE": "b-r-.-O-I-S",
        "GRAFITTI": "b-r-.-O-I-G",
        "VANDALISM/RAPE/LOOT/RANSACK/PLUNDER/SACK": "b-r-.-O-I-V",
        "KNOWN INSURGENT VEHICLE": "b-r-.-O-I-I",
        "DRUG VEHICLE": "b-r-.-O-I-D",
        "INTERNAL SECURITY FORCE": "b-r-.-O-I-F",
        "NON-COT OBJECT": "b-x.*"}