# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cricnotifier']

package_data = \
{'': ['*'], 'cricnotifier': ['static/icon/*']}

install_requires = \
['PyYAML',
 'beautifulsoup4',
 'lxml',
 'plyer',
 'pytest',
 'requests',
 'rich',
 'tabulate',
 'typer[all]>=0.6.1,<0.7.0',
 'win10toast']

entry_points = \
{'console_scripts': ['cricnotifier = cricnotifier.main:app']}

setup_kwargs = {
    'name': 'cricnotifier',
    'version': '2.0.4',
    'description': 'A cli application for real time cricket match notifications.',
    'long_description': '# cricNotifier [![GitHub release (latest by date)](https://img.shields.io/github/v/release/zweack/cricNotifier?style=flat-square)](https://github.com/zweack/cricNotifier/releases) [![GitHub](https://img.shields.io/github/license/zweack/cricNotifier?style=flat-square)](https://github.com/zweack/cricNotifier/blob/main/LICENSE) [![GitHub last commit](https://img.shields.io/github/last-commit/zweack/cricNotifier?style=flat-square)](https://github.com/zweack/cricNotifier/commits/main) [![GitHub issues](https://img.shields.io/github/issues/zweack/cricNotifier?style=flat-square)](https://github.com/zweack/cricNotifier/issues) [![Build Status](https://img.shields.io/travis/zweack/cricNotifier?style=flat-square)](https://travis-ci.org/zweack/cricNotifier)\n\nA CLI based application for real time cricket score updates. \n\n\n## Features\n- Rich command line interface\n- Choose among multiple live matches\n- Cross platform notifications, works on Windows and Linux systems\n\n\n## Installation \n\nMake sure you have python > 3.5 and pip installed, you can install it from [here](https://www.python.org/downloads/ "here")\n\nFor Linux systems, if you want to enable notifications, install dependencies for dbus-python as per specifications from your distro, e.g. for Ubuntu based distros, install following:\n```\nsudo apt-get -y install libglib2.0-dev libdbus-1-3 libdbus-1-dev\n```\n### Install using pip\n```\npip install cricNotifier\n```\n\n## Running the Application \n\nRun following command on your terminal\n```\ncricNotifier [argument]\n```\nArguments:\n```\nlist              List all available matches.\nselect            Select a match with an ID.\ninfo              Fetch info for a match.\nsquad             Fetch players for each team in the match.\nscore             Fetch latest score for a match.\ncommentary        Fetch commentary for last few overs.\n````\n\n## Examples\n#### Get list of currently available matches\n\n```\n$ cricnotifier list\n┌────┬─────────────────────────────────────────────────────────────────────────┐\n│  1 │ New Zealand v Pakistan                                                  │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│  2 │ Madhya Pradesh v Uttarakhand                                            │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│  3 │ Punjab v Tripura                                                        │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│  4 │ Karnataka v Meghalaya                                                   │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│  5 │ Nepal Police Club Women v Lumbini Province Women                        │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│  6 │ Sydney Thunder Women v Hobart Hurricanes Women                          │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│  7 │ BandeAmir Region v Speen Ghar Region                                    │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│  8 │ Boost Region v Mis Ainak Region                                         │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│  9 │ Burgher Recreation Club v Sebastianites Cricket and Athletic Club       │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 10 │ Galle Cricket Club v Moors Sports Club                                  │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 11 │ Kalutara Town Club v Ragama Cricket Club                                │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 12 │ Kandy Customs Cricket Club v Sinhalese Sports Club                      │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 13 │ Kurunegala Youth Cricket Club v Colts Cricket Club                      │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 14 │ Police Sports Club v Lankan Cricket Club                                │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 15 │ Ace Capital Cricket Club v Badureliya Sports Club                       │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 16 │ Bloomfield Cricket and Athletic Club v Tamil Union Cricket and Athletic │\n│    │ Club                                                                    │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 17 │ Chilaw Marians Cricket Club v Sri Lanka Air Force Sports Club           │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 18 │ Negombo Cricket Club v Panadura Sports Club                             │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 19 │ Saracens Sports Club v Nugegoda Sports Welfare Club                     │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 20 │ Sri Lanka Navy Sports Club v Sri Lanka Army Sports Club                 │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 21 │ Assam v Mumbai                                                          │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 22 │ Delhi v Uttar Pradesh                                                   │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 23 │ Haryana v Kerala                                                        │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 24 │ Bihar v Himachal Pradesh                                                │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 25 │ Nagaland v Saurashtra                                                   │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 26 │ Chandigarh v Jharkhand                                                  │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 27 │ Sikkim v Tamil Nadu                                                     │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 28 │ Karnali Province Women v Province Number Women                          │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 29 │ Mizoram v Vidarbha                                                      │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 30 │ Manipur v Puducherry                                                    │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 31 │ Arunachal Pradesh v Services                                            │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 32 │ Australia v England                                                     │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 33 │ Railways v Rajasthan                                                    │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 34 │ Goa v Hyderabad India                                                   │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 35 │ Jammu Kashmir v Maharashtra                                             │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 36 │ Baroda v Gujarat                                                        │\n├────┼─────────────────────────────────────────────────────────────────────────┤\n│ 37 │ Bengal v Odisha                                                         │\n└────┴─────────────────────────────────────────────────────────────────────────┘\n\nUse select command to select a match.\ne.g. for Bengal v Odisha, use\ncricnotifier select 37\n```\n\nToo many matches? Filter them using `--filter`\n```\n$ cricnotifier list --filter aus\n┌───┬─────────────────────┐\n│ 1 │ Australia v England │\n└───┴─────────────────────┘\n\nUse select command to select a match.\ne.g. for Australia v England , use\ncricnotifier select 1\n```\n\n#### Select a match using ID\nThis will cache ID of the match so that you dont have to provide match ID with every command.\nAlternatively you can always pass `--id` with any command which will have higher precedence.   \n\n```\n$ cricnotifier select 32\n[Info] You have selected: Australia vs England\n```\n\n#### Get info about selected match\n```\n$ cricnotifier info\n┌─────────────┬─────────────────────────────────────────────────────────────┐\n│ Description │ England tour of Australia, 3rd T20I: Australia v England at │\n│             │ Canberra, Oct 14, 2022                                      │\n├─────────────┼─────────────────────────────────────────────────────────────┤\n│ Series      │ England in Australia T20I Series                            │\n├─────────────┼─────────────────────────────────────────────────────────────┤\n│ Venue       │ Manuka Oval, Canberra                                       │\n├─────────────┼─────────────────────────────────────────────────────────────┤\n│ Summary     │ England 43/1 (5.2 ov, DJ Malan 16*, JC Buttler 20*, PJ      │\n│             │ Cummins 0/14)                                               │\n├─────────────┼─────────────────────────────────────────────────────────────┤\n│ Toss        │ Australia won the toss and choose to field first.           │\n└─────────────┴─────────────────────────────────────────────────────────────┘\n```\n\nAlternatively you can pass an ID which will override the preserved ID using select command.\n```\n$ cricnotifier info --id 28\n┌─────────────┬──────────────────────────────────────────────────────────────┐\n│ Description │ CAN National Women\'s Cricket Tournament, 12th Match, Group   │\n│             │ B: Karnali Province Women v Province Number 1 Women at       │\n│             │ Pokhara, Oct 14, 2022                                        │\n├─────────────┼──────────────────────────────────────────────────────────────┤\n│ Series      │ CAN National Women\'s Cricket Tournament                      │\n├─────────────┼──────────────────────────────────────────────────────────────┤\n│ Venue       │ Pokhara Rangasala                                            │\n├─────────────┼──────────────────────────────────────────────────────────────┤\n│ Summary     │ Karnali Province Women 53 (16.1 ov, AT Chetri 0*, A Khadiya  │\n│             │ 3/6) - Innings break                                         │\n├─────────────┼──────────────────────────────────────────────────────────────┤\n│ Toss        │ Karnali Province Women won the toss and choose to bat first. │\n└─────────────┴──────────────────────────────────────────────────────────────┘\n```\n\n#### Get squads for the match\n\n```\n$ cricnotifier squad\n┌───────────────────┬──────────────────────┐\n│ Australia         │ England              │\n├───────────────────┼──────────────────────┤\n│ Aaron Finch (c)   │ Jos Buttler (c) (wk) │\n├───────────────────┼──────────────────────┤\n│ Steven Smith      │ Alex Hales           │\n├───────────────────┼──────────────────────┤\n│ Mitchell Marsh    │ Dawid Malan          │\n├───────────────────┼──────────────────────┤\n│ Glenn Maxwell     │ Ben Stokes           │\n├───────────────────┼──────────────────────┤\n│ Marcus Stoinis    │ Harry Brook          │\n├───────────────────┼──────────────────────┤\n│ Tim David         │ Moeen Ali            │\n├───────────────────┼──────────────────────┤\n│ Matthew Wade (wk) │ Chris Woakes         │\n├───────────────────┼──────────────────────┤\n│ Pat Cummins       │ David Willey         │\n├───────────────────┼──────────────────────┤\n│ Mitchell Starc    │ Adil Rashid          │\n├───────────────────┼──────────────────────┤\n│ Adam Zampa        │ Mark Wood            │\n├───────────────────┼──────────────────────┤\n│ Josh Hazlewood    │ Reece Topley         │\n└───────────────────┴──────────────────────┘\n```\n\n#### Get latest score\n\n```\n$ cricnotifier score --id 32\n┌─────────────────────────────────────────────┐\n│ England vs Australia                        │\n├─────────────────────────────────────────────┤\n│ England: 26/1                               │\n│ Overs: 3.5                                  │\n│ Dawid Malan 10(8)* Jos Buttler 10(13)       │\n│ Australia won the toss and elected to field │\n└─────────────────────────────────────────────┘\n```\n\n### Get text commentary of the match\n\n```\n$ cricnotifier commentary --id 32\n[3.2]: Hazlewood to Buttler, 1 RUN\nGood length, top of off, he defends to the right of cover and pinches a single.\n\n[3.1]: Hazlewood to Buttler, FOUR\nLofted inside out over cover! Superb shot. Not a half volley, he opened up the chest and sliced \nit over cover with great timing.\n\n[2.6]: Cummins to Malan, NO RUN\n135kph, he plays and misses trying to glide one with the angle to third man.\n\n[2.5]: Cummins to Malan, FOUR\nPulled over midwicket! A bouncer that got high outside off but he was equal to it, high hands \nand he pulled with ease over the infield.\n\n[2.4]: Cummins to Malan, NO RUN\n136kph, short and wide, he cracks a cut with outstanding timing straight to Maxwell at point.\n\n[2.3]: Cummins to Malan, NO RUN\n136kph, good length top of off, he defends from the crease.\n\n[2.2]: Cummins to Malan, FOUR\nPinged off the pads! Half volley on middle, no swing and Malan clips this beautifully through \nmidwicket. Wonderful timing.\n\n[2.1]: Cummins to Buttler, 1 RUN\n131kph, back of a length, nipping back, thick inside edge onto pad and it balloons into the leg \nside safely for one.\n\n[1.6]: Hazlewood to Buttler, 1 RUN\n138kph, fuller length, angled into off, he defends pushing it to mid off and runs with the shot.\n\n[1.5]: Hazlewood to Buttler, NO RUN\n138kph, good length, angled into off, he defends getting a thickish inside edge to mid on, they \nlook at a single but Buttler sends\nhim back.\n\n[1.4]: Hazlewood to Buttler, NO RUN\n137kph, good length top of off, he defends from the crease.\n\n[1.3]: Hazlewood to Malan, 1 RUN\n143kph, good length, he defends firmly straight of mid off for a single.\n\n[1.2]: Hazlewood to Hales, OUT\nNicked straight to slip! A beauty! Back of a length angled into middle, it leaves him as he\'s \ncaught on the crease defending, gets a thick edge and it floats waist high to Finch who pouches \nit. Test match dismissal that. Amazing length and some late movement..\n\n[1.1]: Hazlewood to Hales, NO RUN\n136kph, good length, fifth stump channel, he leaves watchfully as it shapes away.\n```\n\n\n## Contributing\nThis project welcomes contributions and suggestions. Please feel free to create a PR, report an issue or put up a feature request.\n\n### Build cricNotifier locally\n#### Clone the Repository\n```\ngit clone https://github.com/zweack/cricNotifier.git && cd cricNotifier\n```\n#### Install Dependencies\nInstall [poetry](https://python-poetry.org/docs/#installation) for dependency management and run\n```\npoetry install\n```\nAlternatively, you can use pip \n```\npip install -r requirements.txt\n```\nYou are ready to roll!\n\n## License\ncricNotifier is licensed under the [MIT License](https://github.com/zweack/cricNotifier/blob/dev/LICENSE).\n',
    'author': 'Jeet Jain',
    'author_email': 'jeet88833@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
