"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabRunnerAutoscalingJobRunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const pascal_case_1 = require("pascal-case");
class GitlabRunnerAutoscalingJobRunner extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        this.configuration = {
            ...props.configuration,
            token: (_b = props.configuration.token) !== null && _b !== void 0 ? _b : (_c = props.token) === null || _c === void 0 ? void 0 : _c.stringValue,
            name: (_d = props.configuration.name) !== null && _d !== void 0 ? _d : GitlabRunnerAutoscalingJobRunner.generateUniqueName(),
        };
        this.instanceType = props.instanceType || aws_ec2_1.InstanceType.of(aws_ec2_1.InstanceClass.T3, aws_ec2_1.InstanceSize.MICRO);
        this.machineImage =
            props.machineImage ||
                aws_ec2_1.MachineImage.genericLinux({
                    [scope.region]: new aws_ec2_1.LookupMachineImage({
                        name: "ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server-*",
                        owners: ["099720109477"],
                        filters: {
                            architecture: ["x86_64"],
                            "image-type": ["machine"],
                            state: ["available"],
                            "root-device-type": ["ebs"],
                            "virtualization-type": ["hvm"],
                        },
                    }).getImage(scope).imageId,
                });
        this.role =
            props.role ||
                new aws_iam_1.Role(scope, `RunnersRoleFor${pascal_case_1.pascalCase(this.configuration.name)}`, {
                    assumedBy: new aws_iam_1.ServicePrincipal("ec2.amazonaws.com", {}),
                    managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName("AmazonEC2RoleforSSM")],
                });
        this.instanceProfile = new aws_iam_1.CfnInstanceProfile(scope, `RunnersInstanceProfileFor${pascal_case_1.pascalCase(this.configuration.name)}`, {
            roles: [this.role.roleName],
        });
        aws_cdk_lib_1.Tags.of(this.instanceProfile).add("RunnersInstanceProfile", "RunnersInstanceProfile");
        aws_cdk_lib_1.Tags.of(this.role).add("RunnersRole", "RunnersRole");
    }
    static generateUniqueName() {
        return `gitlab-runner-${new Date().getTime().toString().toString()}${Math.floor(Math.random() * 100000)}`;
    }
}
exports.GitlabRunnerAutoscalingJobRunner = GitlabRunnerAutoscalingJobRunner;
_a = JSII_RTTI_SYMBOL_1;
GitlabRunnerAutoscalingJobRunner[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.GitlabRunnerAutoscalingJobRunner", version: "0.1.10" };
//# sourceMappingURL=data:application/json;base64,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