# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['base_folder', 'simulations_observing_efficiency', 'mapmaking_naming', 'simulated_tubes',
           'read_instrument_model', 'get_telescope', 'get_observing_efficiency']

# Cell

import os

base_folder = os.environ.get(
    "S4REFSIMTOOL_INPUT",
    "/global/cscratch1/sd/keskital/s4sim/reference_tool_round_2/out",
)

# Cell

# computed from the hitmap, see 04_hitmap_wcov
simulations_observing_efficiency = {
    "pole": {
        "ULFPL1": 0.7094065625,
        "LFPL1": 0.7094065625,
        "LFPL2": 0.7094065625,
        "MFPL1": 0.7094065625,
        "MFPL2": 0.7094065625,
        "HFPL1": 0.7094065625,
        "HFPL2": 0.7094065625,
        "LFS1": 0.5410630787037037,
        "LFS2": 0.5410630787037037,
        "MFLS1": 0.5410630787037037,
        "MFHS1": 0.5410630787037037,
        "MFLS2": 0.5410630787037037,
        "MFHS2": 0.5410630787037037,
        "HFS1": 0.5410630787037037,
        "HFS2": 0.5410630787037037,
    },
    "chile": {
        "LFL1": 1.0367161458333334,
        "LFL2": 1.0367161458333334,
        "MFL1": 1.0367161458333334,
        "MFL2": 1.0367161458333334,
        "HFL1": 1.0350467156468064,
        "HFL2": 1.0350467156468064,
    },
}

mapmaking_naming = {
    "SAT": "telescope_all_time_all_filtered.fits.gz",
    "LAT": "filtered_telescope_all_time_all_bmap.fits",
}

simulated_tubes = dict(
    LFS=1,
    MFLS=1,
    MFHS=1,
    HFS=1,  # SAT
    LFL=8,
    MFL=54,
    HFL=23,  # LAT Chile
    ULFPL=4,
    LFPL=9,
    MFPL=54,
    HFPL=18,  # LAT Pole
)

# Cell

from astropy.table import QTable


def read_instrument_model(filename="instrument_model/cmbs4_instrument_model.tbl"):
    """Read the CMB-S4 instrument model

    Includes all instrument parameters with units except bandpasses

    Paramters
    ---------
    filename : str path
        path to instrument model in ASCII IPAC format
    Returns
    -------
    s4 : QTable
        astropy table with units, 1 row per channel
    """
    return QTable.read(filename, format="ascii.ipac")


def get_telescope(channel):
    """Identify if a channel is in SAT or LAT

    Parameters
    ----------
    channel : str
        channel tag, e.g. MFH1

    Returns
    -------
    telescope : str
        'SAT' or 'LAT'
    """
    return channel[-2] + "AT"


def get_observing_efficiency(observing_efficiency_config, site, telescope, channel):
    """Extract the observing frequency for a specific channel from
    the configuration dictionary

    Parameters
    ----------
    observing_efficiency_config : dict
        the order of keys should be site, telescope, channel
        e.g. {"Pole":{"LAT":{"HFL1":0.1}}, "default":0.2}
    site : str
        site, Pole or Chile
    telescope : str
        LAT or SAT
    channel: str
        e.g. HFL1

    Returns
    -------
    observing_efficiency : float
        observing efficiency in decimal form, for example .2 for 20%
        """
    if site in observing_efficiency_config:
        if telescope in observing_efficiency_config[site]:
            try:
                return observing_efficiency_config[site][telescope][channel]
            except KeyError:
                try:
                    return observing_efficiency_config[site][telescope]["default"]
                except KeyError:
                    pass
        try:
            return observing_efficiency_config[site]["default"]
        except KeyError:
            pass
    return observing_efficiency_config["default"]