# IDAES examples

This documentation contains examples for the IDAES platform.

## About IDAES

The Institute for Design of Advanced Energy Systems (IDAES) 
{cite}`miller2018idaes` was originated to bring the 
most advanced modeling and 
optimization capabilities to the challenges of transforming and decarbonizing the world’s energy systems to make them 
environmentally sustainable while maintaining high reliability and low cost.
For more information please see the [IDAES website](https://idaes.org/) and the online 
[IDAES documentation](https://idaes-pse.readthedocs.io/en/latest/index.html).

## About this documentation

The examples in this documentation show how to create, configure, and solve IDAES models for a variety of application.
Some of the examples are written in a tutorial style with separate "exercise" and "solution" sections to
facilitate use in a group setting.

All of the examples are written in Python as [Jupyter](https://jupyter.org) notebooks.
You can browse these notebooks online or download them to and run on your own machine.
The online examples have been created with the 
[JupyterBook](https://jupyterbook.org) software package.

### Prerequisites

Examples in this documentation are rigorously *tested* to ensure that they work with the *latest* version of the IDAES 
software. 
For more information on installing IDAES on your platform,
please refer to the [IDAES documentation](https://idaes-pse.readthedocs.io/en/latest/index.html).

### Getting the source code
The full source code for these examples is available from the 
[IDAES examples repository](https://github.com/IDAES/examples) on GitHub.
It may also be installed as a Python package from [PyPI](https://pypi.org/) with the command:

```
pip install idaes-examples
```

Please see the `README.md` file
in the [repository](https://github.com/IDAES/examples) for more information.

## Getting help

If you find the content of the examples hard to understand, or perhaps incorrect,
please reach out to us. Our primary public forum is the 
[idaes-pse discussions page](https://github.com/IDAES/idaes-pse/discussions),
where you can post questions and also see if others have had a similar
problem. You may also contact us directly by sending email to 
[idaes-support@idaes.org](mailto:idaes-support@idaes.org).


## Bibliography

```{bibliography}
```