"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParameterGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const rds_generated_1 = require("./rds.generated");
/**
 * A parameter group.
 * Represents both a cluster parameter group,
 * and an instance parameter group.
 *
 * @resource AWS::RDS::DBParameterGroup
 */
class ParameterGroup extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_ParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const family = props.engine.parameterGroupFamily;
        if (!family) {
            throw new Error("ParameterGroup cannot be used with an engine that doesn't specify a version");
        }
        this.family = family;
        this.description = props.description;
        this.parameters = (_b = props.parameters) !== null && _b !== void 0 ? _b : {};
    }
    /**
     * Imports a parameter group
     */
    static fromParameterGroupName(scope, id, parameterGroupName) {
        class Import extends core_1.Resource {
            bindToCluster(_options) {
                return { parameterGroupName };
            }
            bindToInstance(_options) {
                return { parameterGroupName };
            }
            addParameter(_key, _value) {
                return false;
            }
        }
        return new Import(scope, id);
    }
    bindToCluster(_options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_ParameterGroupClusterBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bindToCluster);
            }
            throw error;
        }
        if (!this.clusterCfnGroup) {
            const id = this.instanceCfnGroup ? 'ClusterParameterGroup' : 'Resource';
            this.clusterCfnGroup = new rds_generated_1.CfnDBClusterParameterGroup(this, id, {
                description: this.description || `Cluster parameter group for ${this.family}`,
                family: this.family,
                parameters: core_1.Lazy.any({ produce: () => this.parameters }),
            });
        }
        return {
            parameterGroupName: this.clusterCfnGroup.ref,
        };
    }
    bindToInstance(_options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_ParameterGroupInstanceBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bindToInstance);
            }
            throw error;
        }
        if (!this.instanceCfnGroup) {
            const id = this.clusterCfnGroup ? 'InstanceParameterGroup' : 'Resource';
            this.instanceCfnGroup = new rds_generated_1.CfnDBParameterGroup(this, id, {
                description: this.description || `Parameter group for ${this.family}`,
                family: this.family,
                parameters: core_1.Lazy.any({ produce: () => this.parameters }),
            });
        }
        return {
            parameterGroupName: this.instanceCfnGroup.ref,
        };
    }
    /**
     * Add a parameter to this parameter group
     *
     * @param key The key of the parameter to be added
     * @param value The value of the parameter to be added
     */
    addParameter(key, value) {
        this.parameters[key] = value;
        return true;
    }
}
exports.ParameterGroup = ParameterGroup;
_a = JSII_RTTI_SYMBOL_1;
ParameterGroup[_a] = { fqn: "@aws-cdk/aws-rds.ParameterGroup", version: "1.153.0" };
//# sourceMappingURL=data:application/json;base64,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