"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecret = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const secretsmanager = require("@aws-cdk/aws-secretsmanager");
const core_1 = require("@aws-cdk/core");
const util_1 = require("./private/util");
/**
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends secretsmanager.Secret {
    constructor(scope, id, props) {
        var _b, _c;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_DatabaseSecretProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const excludeCharacters = (_b = props.excludeCharacters) !== null && _b !== void 0 ? _b : util_1.DEFAULT_PASSWORD_EXCLUDE_CHARS;
        super(scope, id, {
            encryptionKey: props.encryptionKey,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            secretName: props.secretName,
            generateSecretString: {
                passwordLength: 30,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: (_c = props.masterSecret) === null || _c === void 0 ? void 0 : _c.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters,
            },
            replicaRegions: props.replicaRegions,
        });
        if (props.replaceOnPasswordCriteriaChanges) {
            const hash = crypto.createHash('md5');
            hash.update(JSON.stringify({
                // Use here the options that influence the password generation.
                // If at some point we add other password customization options
                // they sould be added here below (e.g. `passwordLength`).
                excludeCharacters,
            }));
            const logicalId = `${core_1.Names.uniqueId(this)}${hash.digest('hex')}`;
            const secret = this.node.defaultChild;
            secret.overrideLogicalId(logicalId.slice(-255)); // Take last 255 chars
        }
    }
}
exports.DatabaseSecret = DatabaseSecret;
_a = JSII_RTTI_SYMBOL_1;
DatabaseSecret[_a] = { fqn: "@aws-cdk/aws-rds.DatabaseSecret", version: "1.153.0" };
//# sourceMappingURL=data:application/json;base64,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